/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.model;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionScheme;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.Index;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.baja.agent.AgentList;
import javax.baja.category.BCategoryMask;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BDynamicOrionObject
extends BObject
implements BIOrionObject,
BIProtected {
    private OrionType orionType;
    private OrionSession session;
    private Map<String, Prop> properties = new HashMap<String, Prop>();
    private Set<String> nulls = new HashSet<String>();
    private BOrionDatabase db;
    private static final Index[] NO_INDEXES = new Index[0];
    public static final Type TYPE = Sys.loadType(BDynamicOrionObject.class);
    public static final int ORION_SET_NULL_PROPERTY = 704;

    public BDynamicOrionObject(OrionType orionType) {
        this.orionType = orionType;
    }

    @Override
    public OrionType getOrionType() {
        return this.orionType;
    }

    @Override
    public BOrionSpace getOrionSpace() {
        return this.db.getOrionSpace();
    }

    @Override
    public BOrionDatabase getOrionDatabase() {
        return this.db;
    }

    @Override
    public void setOrionDatabase(BOrionDatabase db) {
        this.db = db;
    }

    @Override
    public Object getHandle() {
        return null;
    }

    @Override
    public BOrd getNavOrd() {
        return BOrd.NULL;
    }

    @Override
    public BOrd getOrdInSpace() {
        return BOrd.NULL;
    }

    @Override
    public Index[] getIndexes() {
        return NO_INDEXES;
    }

    @Override
    public final boolean isAuditable() {
        return false;
    }

    public final String getObjectAuditString(Context cx) {
        return BOrionScheme.encodeKeysToString(this);
    }

    public final String getPropertyAuditString(Property prop, BValue value, Context cx) {
        return value.toString(cx);
    }

    public void setOrionSession(OrionSession session) {
        this.session = session;
    }

    public OrionSession getOrionSession() {
        return this.session;
    }

    @Override
    public void init(Property p, BValue v) {
        Prop prop = this.properties.get(p.getName());
        if (prop == null) {
            prop = new Prop(p);
            this.properties.put(p.getName(), prop);
        }
        prop.initValue(v);
    }

    @Override
    public void set(Property p, BValue v) {
        Prop prop = this.properties.get(p.getName());
        if (prop == null) {
            prop = new Prop(p);
            this.properties.put(p.getName(), prop);
        }
        prop.setValue(v);
    }

    @Override
    public BFacets getSlotFacets(Slot slot) {
        return slot.getFacets();
    }

    @Override
    public String getDisplayName(Slot slot, Context cx) {
        return slot.getDefaultDisplayName(cx);
    }

    @Override
    public BValue get(Property p) {
        Prop prop = this.properties.get(p.getName());
        if (prop == null) {
            return p.getDefaultValue();
        }
        return prop.getValue();
    }

    @Override
    public BValue get(String pname) {
        return this.get(this.getOrionType().getProperty(pname));
    }

    @Override
    public void copyFrom(BIOrionObject obj) {
        if (this.getOrionType() != obj.getOrionType()) {
            throw new OrionException("Type mismatch: " + obj.getOrionType() + " != " + this.getOrionType());
        }
        Property[] props = this.getOrionType().getProperties();
        for (int i = 0; i < props.length; ++i) {
            this.set(props[i], obj.get(props[i]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setModified(Property p, boolean mod) {
        Map<String, Prop> map = this.properties;
        synchronized (map) {
            Prop prop = this.properties.get(p.getName());
            if (prop != null) {
                prop.setModified(mod);
            }
        }
    }

    @Override
    public boolean isModified() {
        throw new OrionException("Not implemented.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isModified(Property p) {
        Map<String, Prop> map = this.properties;
        synchronized (map) {
            Prop prop = this.properties.get(p.getName());
            if (prop == null) {
                return false;
            }
            return prop.isModified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllModified() {
        Map<String, Prop> map = this.properties;
        synchronized (map) {
            Iterator<Prop> i = this.properties.values().iterator();
            while (i.hasNext()) {
                i.next().setModified(false);
            }
        }
    }

    @Override
    public String toDisplayString(Context cx) {
        int i;
        OrionType type = this.getOrionType();
        Property[] dps = type.getProperties();
        int displayCount = 0;
        StringBuffer s = new StringBuffer(64);
        for (i = 0; i < dps.length; ++i) {
            if (displayCount != 0) {
                s.append(", ");
            }
            if (!BOrionObject.isDisplayId(dps[i])) continue;
            s.append(this.get(dps[i]).toString(cx));
            ++displayCount;
        }
        if (displayCount == 0) {
            dps = type.getKey();
            for (i = 0; i < dps.length; ++i) {
                if (i != 0) {
                    s.append(", ");
                }
                s.append(this.get(dps[i]).toString(cx));
            }
        }
        return s.toString();
    }

    @Override
    public boolean equivalent(Object o) {
        return BOrionObject.equivalent(this, (BIOrionObject)o);
    }

    public BPermissions getPermissions(Context cx) {
        BOrionDatabase db = this.getOrionDatabase();
        if (db == null) {
            return BPermissions.all;
        }
        return db.getPermissions(cx);
    }

    public boolean canRead(OrdTarget cx) {
        if (cx.get() != this) {
            throw new IllegalStateException();
        }
        BPermissions permissions = cx.getPermissionsForTarget();
        return permissions.has(1);
    }

    public boolean canWrite(OrdTarget cx) {
        if (cx.get() != this) {
            throw new IllegalStateException();
        }
        BPermissions permissions = cx.getPermissionsForTarget();
        return permissions.has(2);
    }

    public boolean canInvoke(OrdTarget target) {
        return false;
    }

    public BCategoryMask getCategoryMask() {
        return BCategoryMask.NULL;
    }

    public BCategoryMask getAppliedCategoryMask() {
        return BCategoryMask.NULL;
    }

    public AgentList getAgents(Context cx) {
        AgentList baseAgents = super.getAgents(cx);
        BTypeSpec typeSpec = this.orionType.getOrionTypeId().getTypeSpec();
        TypeInfo typeInfo = typeSpec.getTypeInfo();
        AgentList typeAgents = Sys.getRegistry().getSpecificAgents(typeInfo);
        AgentList objAgents = Sys.getRegistry().getAgents(BIOrionObject.TYPE.getTypeInfo());
        int len = typeAgents.size();
        for (int i = 0; i < len; ++i) {
            objAgents.add(typeAgents.get(i));
        }
        return objAgents;
    }

    @Override
    public boolean beforeInsert(OrionSession session) {
        return true;
    }

    @Override
    public void afterInsert(OrionSession session) {
    }

    @Override
    public boolean beforeUpdate(OrionSession session) {
        return true;
    }

    @Override
    public void afterUpdate(OrionSession session) {
    }

    @Override
    public boolean beforeDelete(OrionSession session) {
        return true;
    }

    @Override
    public void afterDelete(OrionSession session) {
    }

    @Override
    public boolean isNull(Property p) {
        return this.nulls.contains(p.getName());
    }

    private void setNull(Property p, boolean isNull) {
        if (isNull) {
            this.nulls.add(p.getName());
        } else {
            this.nulls.remove(p.getName());
        }
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 704: {
                Property p = (Property)a;
                boolean isNull = (Boolean)b;
                this.setNull(p, isNull);
                return null;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    public Type getType() {
        return TYPE;
    }

    private class Prop {
        Property property;
        BValue value;
        boolean modified = false;

        public Prop(Property property) {
            this.property = property;
        }

        public void initValue(BValue value) {
            this.value = value;
        }

        public void setValue(BValue value) {
            this.value = value;
            this.modified = true;
        }

        public BValue getValue() {
            return this.value;
        }

        public void setModified(boolean modified) {
            this.modified = modified;
        }

        public boolean isModified() {
            return this.modified;
        }
    }
}

