/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.migrate;

import com.tridium.bql.cursor.BogCursor;
import com.tridium.orion.BAbstractOrionApp;
import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.BSchemaVersion;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.audit.BOrionAudit;
import com.tridium.orion.priv.model.SortingUtil;
import com.tridium.orion.priv.util.BOrionAppVersion;
import com.tridium.orion.priv.util.CountingUtil;
import com.tridium.orion.sql.BPage;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.util.ThrowableUtil;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.rdb.BRdbms;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

public class BOrionMigrator
extends BAbstractOrionApp {
    private static BFacets options = BFacets.make((String)"lexicon", (String)"orion");
    public static BEnumRange migrationTypeRange = BEnumRange.make(null, (int[])new int[]{0, 1, 2, 3}, (String[])new String[]{SlotPath.escape((String)"New Database"), SlotPath.escape((String)"Insert Only"), SlotPath.escape((String)"Overwrite"), SlotPath.escape((String)"Force Overwrite")}, (int)4, (BFacets)options);
    public static final Property oldDbOrd = BOrionMigrator.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (String)"rdb:Rdbms"));
    public static final Property appOrdList = BOrionMigrator.newProperty((int)0, (BValue)BOrdList.NULL, (BFacets)BFacets.make((BFacets)BFacets.make((String)"multiLine", (boolean)true), (BFacets)BFacets.make((String)"targetType", (String)"orion:IOrionApp")));
    public static final Property migrationType = BOrionMigrator.newProperty((int)0, (BValue)BDynamicEnum.make((int)0, (BEnumRange)migrationTypeRange), (BFacets)BFacets.make((BFacets)BFacets.make((String)"range", (BIDataValue)migrationTypeRange), (BFacets)BFacets.make((String)"fieldEditor", (String)"workbench:FrozenEnumFE")));
    public static final Property recordsMoved = BOrionMigrator.newProperty((int)3, (int)0, null);
    public static final Property result = BOrionMigrator.newProperty((int)3, (String)"", (BFacets)BFacets.make((String)"multiLine", (boolean)true));
    public static final Action migrate = BOrionMigrator.newAction((int)144, null);
    public static final Type TYPE = Sys.loadType(BOrionMigrator.class);
    private static final BIcon icon = BIcon.std((String)"move.png");
    private String warning;
    public static final int MAX_RESULT_SIZE = Integer.getInteger("niagara.query.maxResultSize", 5000);

    public BOrd getOldDbOrd() {
        return (BOrd)this.get(oldDbOrd);
    }

    public void setOldDbOrd(BOrd v) {
        this.set(oldDbOrd, (BValue)v, null);
    }

    public BOrdList getAppOrdList() {
        return (BOrdList)this.get(appOrdList);
    }

    public void setAppOrdList(BOrdList v) {
        this.set(appOrdList, (BValue)v, null);
    }

    public BDynamicEnum getMigrationType() {
        return (BDynamicEnum)this.get(migrationType);
    }

    public void setMigrationType(BDynamicEnum v) {
        this.set(migrationType, (BValue)v, null);
    }

    public int getRecordsMoved() {
        return this.getInt(recordsMoved);
    }

    public void setRecordsMoved(int v) {
        this.setInt(recordsMoved, v, null);
    }

    public String getResult() {
        return this.getString(result);
    }

    public void setResult(String v) {
        this.setString(result, v, null);
    }

    public void migrate() {
        this.invoke(migrate, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        new Thread((Runnable)new Invocation((BComponent)this, action, argument, cx)).start();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMigrate(Context cx) {
        if (!this.getStatus().isOk()) {
            this.setResult(Lexicon.make((String)"orion", (Context)cx).getText("orionMigrator.cannotMigrateStatus"));
            return;
        }
        if (this.getOldDbOrd().isNull()) {
            this.setResult(Lexicon.make((String)"orion", (Context)cx).getText("orionMigrator.cannotMigrateOldOrd"));
            return;
        }
        if (this.warning != null) {
            this.setResult(Lexicon.make((String)"orion", (Context)cx).getText("orionMigrator.cannotMigrateWarning", new Object[]{this.warning}));
            return;
        }
        try {
            OrionSession newSession = this.getOrionDatabase().createSession(null);
            OrionSession oldSession = this.getOldOrionDatabase().createSession(null);
            this.setRecordsMoved(0);
            try {
                Array a = new Array(OrionType.class);
                OrionType[] types = this.getOrionTypes();
                if (types.length == 0) {
                    this.setResult(Lexicon.make((String)"orion", (Context)cx).getText("orionMigrator.noTypesToMigrate"));
                    return;
                }
                a.addAll((Object[])SortingUtil.sortTypes(oldSession.getOrionDatabase(), types));
                if (this.getAppOrdList().equals((Object)BOrdList.NULL)) {
                    a.add((Object)BOrionAudit.ORION_TYPE);
                }
                types = (OrionType[])a.trim();
                for (int i = 0; i < types.length; ++i) {
                    int lastCurrentCount = -1;
                    int totalCount = CountingUtil.getCount(types[i], oldSession);
                    int currentCount = 0;
                    while (currentCount < totalCount && currentCount != lastCurrentCount) {
                        lastCurrentCount = currentCount;
                        BSqlQuery query = BSqlQuery.make(types[i]);
                        query.page(new BPage(currentCount, MAX_RESULT_SIZE));
                        OrionCursor c = oldSession.select(query);
                        while (c.next()) {
                            ++currentCount;
                            BOrionObject o = (BOrionObject)c.get();
                            try {
                                newSession.insert((BOrionObject)o.newCopy());
                            }
                            catch (Exception e) {
                                if (this.getMigrationType().getOrdinal() == 0) {
                                    throw e;
                                }
                                if (this.getMigrationType().getOrdinal() == 1) continue;
                                try {
                                    newSession.update((BOrionObject)o.newCopy());
                                }
                                catch (Exception ee) {
                                    if (this.getMigrationType().getOrdinal() == 2) {
                                        throw ee;
                                    }
                                    if (this.getMigrationType().getOrdinal() == 3) continue;
                                }
                            }
                            this.setRecordsMoved(this.getRecordsMoved() + 1);
                        }
                    }
                }
                BIOrionApp[] apps = this.getOrionApps();
                for (int i = 0; i < apps.length; ++i) {
                    BComponent c = (BComponent)apps[i];
                    BSchemaVersion schemaVersion = apps[i].getSchemaVersion();
                    BOrionAppVersion appVersion = (BOrionAppVersion)newSession.read(BOrionAppVersion.ORION_TYPE, new PropertyValue(BOrionAppVersion.app, (BValue)c.getType().getTypeSpec()));
                    if (appVersion == null) {
                        appVersion = new BOrionAppVersion();
                        appVersion.setApp(c.getType().getTypeSpec());
                        appVersion.setSchemaVersion(schemaVersion);
                        newSession.insert(appVersion);
                    } else {
                        appVersion.setSchemaVersion(schemaVersion);
                        newSession.update(appVersion);
                    }
                    c.set(this.getOrionAppProperty(c), (BValue)this.getDbOrd());
                }
            }
            finally {
                if (newSession != null) {
                    newSession.close();
                }
                if (oldSession != null) {
                    oldSession.close();
                }
            }
            this.setResult(Lexicon.make((String)"orion", (Context)cx).getText("orionMigrator.success"));
        }
        catch (Exception e) {
            this.setResult(Lexicon.make((String)"orion", (Context)cx).getText("orionMigrator.failure", new Object[]{ThrowableUtil.dumpToString((Throwable)e)}));
            e.printStackTrace();
        }
    }

    public BRdbms getOldRdbms() {
        if (this.getDbOrd().isNull()) {
            throw new OrionException("Database ORD not configured.");
        }
        return (BRdbms)this.getOldDbOrd().resolve((BObject)this).get();
    }

    public BOrionDatabase getOldOrionDatabase() {
        BRdbms rdbms = this.getOldRdbms();
        BOrionSpace orionSpace = (BOrionSpace)BOrd.make((String)"orion:").resolve((BObject)this).get();
        return orionSpace.getOrionDatabase(rdbms);
    }

    public BIOrionApp[] getAllOrionApps() {
        Array a = new Array(BIOrionApp.class);
        try (BogCursor c = new BogCursor((BComplex)Sys.getStation(), 99, new Type[]{BIOrionApp.TYPE}, false, null);){
            while (c.next()) {
                BIOrionApp app = (BIOrionApp)c.get();
                if (app instanceof BOrionMigrator) continue;
                a.add((Object)app);
            }
        }
        return (BIOrionApp[])a.trim();
    }

    public BIOrionApp[] getOrionApps() {
        Array a = new Array(BIOrionApp.class);
        BOrdList ordList = this.getAppOrdList();
        if (ordList.equals((Object)BOrdList.NULL)) {
            return this.getAllOrionApps();
        }
        for (int i = 0; i < ordList.size(); ++i) {
            BOrd ord = BOrd.make((String)("station:|" + ordList.get(i)));
            BIOrionApp app = (BIOrionApp)ord.get();
            a.add((Object)app);
        }
        return (BIOrionApp[])a.trim();
    }

    @Override
    public OrionType[] getOrionTypes() {
        Array a = new Array(OrionType.class);
        BIOrionApp[] apps = this.getOrionApps();
        for (int i = 0; i < apps.length; ++i) {
            BComponent c = (BComponent)apps[i];
            BOrd ord = (BOrd)c.get(this.getOrionAppProperty(c));
            if (!ord.isNull() && ord.equals((Object)this.getDbOrd())) {
                this.warning = Lexicon.make((String)"orion").getText("warningNewDbOrdAlreadyUsed", new Object[]{c.getDisplayName(null)});
                continue;
            }
            a.addAll((Object[])apps[i].getOrionTypes());
        }
        return (OrionType[])a.trim();
    }

    Property getOrionAppProperty(BComponent c) {
        if (c instanceof BAbstractOrionApp) {
            return BAbstractOrionApp.dbOrd;
        }
        if (c.get(BAbstractOrionApp.dbOrd.getName()) != null) {
            return c.getProperty(BAbstractOrionApp.dbOrd.getName());
        }
        Property[] props = c.getFrozenPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            BFacets facets;
            String targetType;
            if (!props[i].getType().equals(BOrd.TYPE) || !(targetType = (facets = props[i].getFacets()).gets("targetType", "")).equals("rdb:Rdbms")) continue;
            return props[i];
        }
        throw new IllegalStateException("Cannot find BIOrionApp database property");
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    @Override
    public void changed(Property property, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(appOrdList) && Sys.getStation().isRunning()) {
            this.configFatal(Lexicon.make((String)"orion", (Context)cx).getText("appOrdListChanged"));
        }
        super.changed(property, cx);
    }

    @Override
    public void orionReady(BOrionDatabase db) {
        if (this.warning != null) {
            this.setResult(this.warning);
        }
        super.orionReady(db);
    }

    @Override
    public void performSchemaUpgrade(BLocalOrionDatabase db, BSchemaVersion v) throws Exception {
    }

    @Override
    public BSchemaVersion getSchemaVersion() {
        return BSchemaVersion.DEFAULT;
    }

    public String getDisplayName(Slot slot, Context cx) {
        if (slot.equals((Object)dbOrd)) {
            return Lexicon.make((String)"orion", (Context)cx).getText("newDbOrd");
        }
        return super.getDisplayName(slot, cx);
    }

    public BIcon getIcon() {
        return icon;
    }
}

