/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.fox;

import com.tridium.fox.encoding.BogCodec;
import com.tridium.fox.encoding.DecoderFactory;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionModule;
import com.tridium.orion.BOrionRoot;
import com.tridium.orion.BOrionService;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.BOrionType;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.db.sql.Ddl;
import com.tridium.orion.priv.fox.BFoxOrionDatabase;
import com.tridium.orion.priv.fox.BOrionChannel;
import com.tridium.orion.priv.fox.FoxDbSpec;
import com.tridium.orion.priv.fox.FoxOrionSession;
import com.tridium.orion.sql.BSqlUpdate;
import com.tridium.orion.sql.PropertyValue;
import javax.baja.category.BCategoryMask;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.query.BExpression;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

class OrionRequest {
    private BOrionChannel channel;

    OrionRequest(BOrionChannel channel) {
        this.channel = channel;
    }

    public FoxResponse process(FoxRequest req) throws Exception {
        String command = req.command;
        if (command == "ping") {
            return this.ping(req);
        }
        if (command == "root") {
            return this.loadOrionRoot(req);
        }
        if (command == "closeSession") {
            return this.closeSession(req);
        }
        if (command == "commit") {
            return this.commit(req);
        }
        if (command == "rollback") {
            return this.rollback(req);
        }
        if (command == "exists") {
            return this.exists(req);
        }
        if (command == "updateRaw") {
            return this.updateRaw(req);
        }
        if (command == "qupdate") {
            return this.qupdate(req);
        }
        if (command == "deleteRaw") {
            return this.deleteRaw(req);
        }
        if (command == "insertRaw") {
            return this.insertRaw(req);
        }
        if (command == "invokeDdl") {
            return this.invokeDdl(req);
        }
        if (command == "getRdbmsTypeSpec") {
            return this.getRdbmsTypeSpec(req);
        }
        if (command == "qdelete") {
            return this.qdelete(req);
        }
        if (command == "getDbs") {
            return this.getOrionDatabases(req);
        }
        if (command == "listModules") {
            return this.listModules(req);
        }
        if (command == "listTypes") {
            return this.listTypes(req);
        }
        if (command == "getDbForApp") {
            return this.getDbForApp(req);
        }
        throw new InvalidCommandException(command);
    }

    public BTypeSpec getRdbmsTypeSpec(FoxOrionSession session) throws Exception {
        FoxRequest req = this.channel.makeRequest("getRdbmsTypeSpec");
        this.channel.setSession(session, req);
        FoxResponse resp = this.channel.sendSync(req);
        if (resp.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)resp);
        }
        this.channel.assignSessionId(session, (FoxMessage)resp);
        return BTypeSpec.make((String)resp.getString("result"));
    }

    private FoxResponse getRdbmsTypeSpec(FoxRequest req) throws Exception {
        try {
            FoxResponse resp = new FoxResponse(req);
            OrionSession session = this.channel.getSession((FoxMessage)req, resp, true);
            BLocalOrionDatabase db = (BLocalOrionDatabase)session.getOrionDatabase();
            resp.add("result", db.getRdbms().getType().getTypeSpec().toString());
            return resp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.exceptionToResponse(e);
        }
    }

    public void invokeDdl(FoxOrionSession session, String sql) throws Exception {
        FoxRequest req = this.channel.makeRequest("invokeDdl");
        this.channel.setSession(session, req);
        req.add("sql", sql);
        FoxResponse resp = this.channel.sendSync(req);
        if (resp.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)resp);
        }
    }

    private FoxResponse invokeDdl(FoxRequest req) throws Exception {
        try {
            FoxResponse resp = new FoxResponse(req);
            DbOrionSession session = (DbOrionSession)this.channel.getSession((FoxMessage)req, resp, true);
            Ddl ddlHelper = new Ddl(session);
            BPermissions permissions = this.channel.getPermissionsFor(session.getOrionDatabase());
            if (!permissions.hasAdminWrite()) {
                throw new PermissionException("Insufficient Permission");
            }
            ddlHelper.invokeDdl(req.getString("sql"));
            return resp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.exceptionToResponse(e);
        }
    }

    public void ping() throws Exception {
        FoxRequest req = this.channel.makeRequest("ping");
        FoxResponse resp = this.channel.sendSync(req);
        if (resp.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)resp);
        }
        if (!resp.getBoolean("enabled")) {
            throw new OrionException("Target disabled.");
        }
    }

    private FoxResponse ping(FoxRequest req) throws Exception {
        try {
            FoxResponse resp = new FoxResponse(req);
            boolean enabled = false;
            BOrionService service = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            enabled = !service.getStatus().isDisabled();
            resp.add("enabled", enabled);
            return resp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.exceptionToResponse(e);
        }
    }

    public BOrionRoot loadOrionRoot() throws Exception {
        FoxRequest req = this.channel.makeRequest("root");
        FoxResponse resp = this.channel.sendSync(req);
        if (resp.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)resp);
        }
        String pstr = resp.getString("p", null);
        if (pstr == null) {
            return null;
        }
        BPermissions permissions = (BPermissions)BPermissions.DEFAULT.decodeFromString(resp.getString("p"));
        BCategoryMask catMask = (BCategoryMask)BCategoryMask.DEFAULT.decodeFromString(resp.getString("c"));
        BOrionRoot root = new BOrionRoot(permissions);
        root.setCategoryMask(catMask, Context.decoding);
        return root;
    }

    private FoxResponse loadOrionRoot(FoxRequest req) throws Exception {
        try {
            FoxResponse resp = new FoxResponse(req);
            BOrionService service = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            BOrionSpace space = service.getOrionSpace();
            BComponent root = space.getRootComponent();
            BPermissions permissions = this.channel.getPermissionsFor(root);
            if (!permissions.hasOperatorRead()) {
                return resp;
            }
            resp.add("p", this.channel.getPermissionsFor(root).encodeToString());
            resp.add("c", root.getCategoryMask().encodeToString());
            return resp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.exceptionToResponse(e);
        }
    }

    public void closeSession(FoxOrionSession session) throws Exception {
        FoxRequest req = this.channel.makeRequest("closeSession");
        this.channel.setSession(session, req);
        FoxResponse resp = this.channel.sendSync(req);
        if (resp.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)resp);
        }
        session.closed();
    }

    private FoxResponse closeSession(FoxRequest req) throws Exception {
        try {
            FoxResponse resp = new FoxResponse(req);
            int sessionId = req.getInt("sessionId");
            OrionSession session = this.channel.getSession((FoxMessage)req, resp, false);
            session.close();
            this.channel.unregisterSession(sessionId);
            return resp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.exceptionToResponse(e);
        }
    }

    public void commit(FoxOrionSession session) throws Exception {
        FoxRequest req = this.channel.makeRequest("commit");
        this.channel.setSession(session, req);
        FoxResponse resp = this.channel.sendSync(req);
        if (resp.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)resp);
        }
        this.channel.assignSessionId(session, (FoxMessage)resp);
    }

    private FoxResponse commit(FoxRequest req) throws Exception {
        try {
            FoxResponse resp = new FoxResponse(req);
            OrionSession session = this.channel.getSession((FoxMessage)req, resp, true);
            session.commit();
            return resp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.exceptionToResponse(e);
        }
    }

    public void rollback(FoxOrionSession session) throws Exception {
        FoxRequest req = this.channel.makeRequest("rollback");
        this.channel.setSession(session, req);
        FoxResponse resp = this.channel.sendSync(req);
        if (resp.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)resp);
        }
        this.channel.assignSessionId(session, (FoxMessage)resp);
    }

    private FoxResponse rollback(FoxRequest req) throws Exception {
        try {
            FoxResponse resp = new FoxResponse(req);
            OrionSession session = this.channel.getSession((FoxMessage)req, resp, true);
            session.rollback();
            return resp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.exceptionToResponse(e);
        }
    }

    public BOrionModule[] listModules(BFoxOrionDatabase db) throws Exception {
        FoxRequest req = this.channel.makeRequest("listModules");
        req.add("dbId", db.getId());
        FoxResponse resp = this.channel.sendSync(req);
        if (resp.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)resp);
        }
        FoxTuple[] list = resp.list("m");
        BOrionModule[] modules = new BOrionModule[list.length];
        for (int i = 0; i < list.length; ++i) {
            FoxMessage msg = (FoxMessage)list[i];
            String moduleName = msg.getString("n");
            BCategoryMask catMask = (BCategoryMask)BCategoryMask.DEFAULT.decodeFromString(msg.getString("c"));
            BPermissions permissions = (BPermissions)BPermissions.DEFAULT.decodeFromString(msg.getString("p"));
            modules[i] = new BOrionModule(moduleName, permissions);
            modules[i].setCategoryMask(catMask, Context.decoding);
        }
        return modules;
    }

    private FoxResponse listModules(FoxRequest req) throws Exception {
        try {
            FoxResponse resp = new FoxResponse(req);
            String dbId = req.getString("dbId");
            BOrionService service = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            BOrionDatabase db = service.getOrionDatabase(dbId);
            BOrionModule[] modules = db.getModules();
            for (int i = 0; i < modules.length; ++i) {
                BPermissions permissions = this.channel.getPermissionsFor(modules[i]);
                if (!permissions.hasOperatorRead()) continue;
                FoxMessage mmsg = new FoxMessage("m");
                mmsg.add("n", modules[i].getName());
                mmsg.add("c", modules[i].getCategoryMask().encodeToString());
                mmsg.add("p", permissions.encodeToString());
                resp.add("m", mmsg);
            }
            return resp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.exceptionToResponse(e);
        }
    }

    public BOrionType[] listTypes(BFoxOrionDatabase db, BOrionModule module) throws Exception {
        FoxResponse resp;
        FoxRequest req = this.channel.makeRequest("listTypes");
        req.add("dbId", db.getId());
        if (module != null) {
            req.add("m", module.getModuleName());
        }
        if ((resp = this.channel.sendSync(req)).getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)resp);
        }
        FoxTuple[] list = resp.list("t");
        BOrionType[] types = new BOrionType[list.length];
        for (int i = 0; i < list.length; ++i) {
            FoxMessage msg = (FoxMessage)list[i];
            String moduleName = msg.getString("m");
            String typeName = msg.getString("t");
            BCategoryMask catMask = (BCategoryMask)BCategoryMask.DEFAULT.decodeFromString(msg.getString("c"));
            BPermissions permissions = (BPermissions)BPermissions.DEFAULT.decodeFromString(msg.getString("p"));
            types[i] = new BOrionType(moduleName, typeName, permissions);
            types[i].setCategoryMask(catMask, Context.decoding);
        }
        return types;
    }

    private FoxResponse listTypes(FoxRequest req) throws Exception {
        try {
            FoxResponse resp = new FoxResponse(req);
            String dbId = req.getString("dbId");
            String moduleName = req.getString("m", null);
            BOrionService service = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            BOrionDatabase db = service.getOrionDatabase(dbId);
            BOrionModule module = moduleName == null ? null : db.getModule(moduleName);
            BOrionType[] types = service.getOrionSpace().listTypes(db, module);
            for (int i = 0; i < types.length; ++i) {
                BPermissions permissions = this.channel.getPermissionsFor(types[i]);
                if (!permissions.hasOperatorRead()) continue;
                FoxMessage tmsg = new FoxMessage("t");
                tmsg.add("m", types[i].getModule().getModuleName());
                tmsg.add("t", types[i].getTypeName());
                tmsg.add("c", types[i].getCategoryMask().encodeToString());
                tmsg.add("p", permissions.encodeToString());
                resp.add("t", tmsg);
            }
            return resp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.exceptionToResponse(e);
        }
    }

    public String getDbForApp(BOrd appOrd) throws Exception {
        FoxRequest req = this.channel.makeRequest("getDbForApp");
        req.add("appOrd", appOrd.encodeToString());
        FoxResponse resp = this.channel.sendSync(req);
        if (resp.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)resp);
        }
        return resp.getString("dbId", null);
    }

    private FoxResponse getDbForApp(FoxRequest req) throws Exception {
        try {
            FoxResponse resp = new FoxResponse(req);
            BOrd appOrd = (BOrd)BOrd.DEFAULT.decodeFromString(req.getString("appOrd"));
            BIOrionApp app = (BIOrionApp)appOrd.get();
            BOrionService service = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            BOrionSpace space = service.getOrionSpace();
            BOrionDatabase db = space.getOrionDatabaseForApp(app);
            if (db != null) {
                resp.add("dbId", db.getId());
            }
            return resp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.exceptionToResponse(e);
        }
    }

    public boolean exists(FoxOrionSession session, OrionType type, PropertyValue[] keys) throws Exception {
        FoxRequest req = this.channel.makeRequest("exists");
        this.channel.setSession(session, req);
        req.add("objType", type.getOrionTypeId().encodeToString());
        this.channel.encodePropertyValues((FoxMessage)req, "key", keys);
        FoxResponse resp = this.channel.sendSync(req);
        if (resp.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)resp);
        }
        this.channel.assignSessionId(session, (FoxMessage)resp);
        return resp.getBoolean("result");
    }

    private FoxResponse exists(FoxRequest req) throws Exception {
        try {
            FoxResponse resp = new FoxResponse(req);
            OrionSession session = this.channel.getSession((FoxMessage)req, resp, true);
            BOrionTypeId objTypeId = (BOrionTypeId)BOrionTypeId.DEFAULT.decodeFromString(req.getString("objType"));
            OrionType objType = session.getOrionDatabase().getType(objTypeId);
            PropertyValue[] keys = this.channel.decodePropertyValues(objType, (FoxMessage)req, "key");
            BIOrionObject obj = session.read(objType, keys);
            resp.add("result", obj != null && this.channel.getPermissionsFor(obj).hasOperatorRead());
            return resp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.exceptionToResponse(e);
        }
    }

    public int qupdate(FoxOrionSession session, BSqlUpdate update) throws Exception {
        FoxRequest req = this.channel.makeRequest("qupdate");
        this.channel.setSession(session, req);
        BogCodec.add((FoxMessage)req, (String)"update", (BValue)update, null);
        FoxResponse resp = this.channel.sendSync(req);
        if (resp.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)resp);
        }
        this.channel.assignSessionId(session, (FoxMessage)resp);
        return resp.getInt("result");
    }

    private FoxResponse qupdate(FoxRequest req) throws Exception {
        try {
            FoxResponse resp = new FoxResponse(req);
            OrionSession session = this.channel.getSession((FoxMessage)req, resp, true);
            BSqlUpdate update = (BSqlUpdate)((Object)DecoderFactory.decode((FoxMessage)req, (String)"update", null));
            resp.add("result", session.update(update));
            return resp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.exceptionToResponse(e);
        }
    }

    public int updateRaw(FoxOrionSession session, String sql, BSimple[] paramValues) throws Exception {
        FoxResponse resp;
        FoxRequest req = this.channel.makeRequest("updateRaw");
        this.channel.setSession(session, req);
        req.add("sql", sql);
        if (paramValues != null) {
            this.channel.encodeParameters((FoxMessage)req, paramValues);
        }
        if ((resp = this.channel.sendSync(req)).getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)resp);
        }
        this.channel.assignSessionId(session, (FoxMessage)resp);
        return resp.getInt("result");
    }

    private FoxResponse updateRaw(FoxRequest req) throws Exception {
        try {
            FoxResponse resp = new FoxResponse(req);
            OrionSession session = this.channel.getSession((FoxMessage)req, resp, true);
            BPermissions permissions = this.channel.getPermissionsFor(session.getOrionDatabase());
            String sql = req.getString("sql");
            BSimple[] paramValues = this.channel.decodeParameters((FoxMessage)req);
            int result = 0;
            if (!permissions.hasAdminWrite()) {
                throw new PermissionException("Insufficient Permission");
            }
            result = session.update(sql, paramValues);
            resp.add("result", result);
            return resp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.exceptionToResponse(e);
        }
    }

    public int qdelete(FoxOrionSession session, OrionType type, BExpression condition) throws Exception {
        FoxResponse resp;
        FoxRequest req = this.channel.makeRequest("qdelete");
        this.channel.setSession(session, req);
        req.add("typeId", type.getOrionTypeId().encodeToString());
        req.add("hasCondition", condition != null);
        if (condition != null) {
            BogCodec.add((FoxMessage)req, (String)"condition", (BValue)condition, null);
        }
        if ((resp = this.channel.sendSync(req)).getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)resp);
        }
        this.channel.assignSessionId(session, (FoxMessage)resp);
        return resp.getInt("result");
    }

    private FoxResponse qdelete(FoxRequest req) throws Exception {
        try {
            FoxResponse resp = new FoxResponse(req);
            OrionSession session = this.channel.getSession((FoxMessage)req, resp, true);
            OrionType type = session.getOrionDatabase().getType(BOrionTypeId.make(req.getString("typeId")));
            BExpression condition = null;
            if (req.getBoolean("hasCondition")) {
                condition = (BExpression)DecoderFactory.decode((FoxMessage)req, (String)"condition", null);
            }
            resp.add("result", session.delete(type, condition));
            return resp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.exceptionToResponse(e);
        }
    }

    public int insertRaw(FoxOrionSession session, String sql, BSimple[] paramValues) throws Exception {
        FoxResponse resp;
        FoxRequest req = this.channel.makeRequest("insertRaw");
        this.channel.setSession(session, req);
        req.add("sql", sql);
        if (paramValues != null) {
            this.channel.encodeParameters((FoxMessage)req, paramValues);
        }
        if ((resp = this.channel.sendSync(req)).getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)resp);
        }
        this.channel.assignSessionId(session, (FoxMessage)resp);
        return resp.getInt("result");
    }

    private FoxResponse insertRaw(FoxRequest req) throws Exception {
        try {
            FoxResponse resp = new FoxResponse(req);
            OrionSession session = this.channel.getSession((FoxMessage)req, resp, true);
            BPermissions permissions = this.channel.getPermissionsFor(session.getOrionDatabase());
            int result = 0;
            if (!permissions.hasAdminWrite()) {
                throw new PermissionException("Insufficient Permission");
            }
            String sql = req.getString("sql");
            BSimple[] paramValues = this.channel.decodeParameters((FoxMessage)req);
            result = session.insert(sql, paramValues);
            resp.add("result", result);
            return resp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.exceptionToResponse(e);
        }
    }

    public int deleteRaw(FoxOrionSession session, String sql, BSimple[] paramValues) throws Exception {
        FoxResponse resp;
        FoxRequest req = this.channel.makeRequest("deleteRaw");
        this.channel.setSession(session, req);
        req.add("sql", sql);
        if (paramValues != null) {
            this.channel.encodeParameters((FoxMessage)req, paramValues);
        }
        if ((resp = this.channel.sendSync(req)).getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)resp);
        }
        this.channel.assignSessionId(session, (FoxMessage)resp);
        return resp.getInt("result");
    }

    private FoxResponse deleteRaw(FoxRequest req) throws Exception {
        try {
            FoxResponse resp = new FoxResponse(req);
            OrionSession session = this.channel.getSession((FoxMessage)req, resp, true);
            BPermissions permissions = this.channel.getPermissionsFor(session.getOrionDatabase());
            int result = 0;
            if (!permissions.hasAdminWrite()) {
                throw new PermissionException("Insufficient Permission");
            }
            String sql = req.getString("sql");
            BSimple[] paramValues = this.channel.decodeParameters((FoxMessage)req);
            result = session.delete(sql, paramValues);
            resp.add("result", result);
            return resp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.exceptionToResponse(e);
        }
    }

    public FoxDbSpec[] getOrionDatabases() throws Exception {
        FoxResponse resp = this.channel.sendSync(this.channel.makeRequest("getDbs"));
        if (resp.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)resp);
        }
        FoxTuple[] dbs = resp.list("db");
        FoxDbSpec[] result = new FoxDbSpec[dbs.length];
        for (int i = 0; i < dbs.length; ++i) {
            FoxMessage dbMsg = (FoxMessage)dbs[i];
            BCategoryMask catMask = (BCategoryMask)BCategoryMask.DEFAULT.decodeFromString(dbMsg.getString("c"));
            BPermissions permissions = (BPermissions)BPermissions.DEFAULT.decodeFromString(dbMsg.getString("p"));
            result[i] = new FoxDbSpec(dbMsg.getString("name"), dbMsg.getString("id"), catMask, permissions);
        }
        return result;
    }

    private FoxResponse getOrionDatabases(FoxRequest req) throws Exception {
        try {
            FoxResponse resp = new FoxResponse(req);
            BOrionService service = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            BOrionRoot root = (BOrionRoot)service.getOrionSpace().getRootComponent();
            Array temp = new Array(BOrionDatabase.class);
            SlotCursor c = root.getProperties();
            while (c.next(BOrionDatabase.class)) {
                BOrionDatabase db = (BOrionDatabase)c.get();
                BPermissions permissions = this.channel.getPermissionsFor(db);
                if (!permissions.hasOperatorRead()) continue;
                FoxMessage dbMsg = new FoxMessage("db");
                dbMsg.add("name", db.getName());
                dbMsg.add("id", db.getId());
                dbMsg.add("c", db.getCategoryMask().encodeToString());
                dbMsg.add("p", permissions.encodeToString());
                resp.add("db", dbMsg);
            }
            return resp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.exceptionToResponse(e);
        }
    }

    public FoxResponse exceptionToResponse(Throwable e) {
        FoxResponse resp = new FoxResponse();
        resp.add("exception", e.toString());
        return resp;
    }
}

