/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.fox;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionService;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.fox.BFoxOrionSpace;
import com.tridium.orion.priv.fox.FoxOrionSession;
import com.tridium.orion.priv.fox.OrionCircuit;
import com.tridium.orion.priv.fox.OrionRequest;
import com.tridium.orion.sql.PropertyValue;
import java.io.IOException;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.nre.util.IntHashMap;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BSpace;
import javax.baja.sync.SetCategoryMaskOp;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BOrionChannel
extends BFoxChannel
implements NavListener {
    private IntHashMap sessionReg = new IntHashMap();
    private int nextId = 0;
    public static final Type TYPE = Sys.loadType(BOrionChannel.class);
    private Object syncLock = new Object();
    private SyncBuffer syncBuffer;
    OrionRequest requestHandler = new OrionRequest(this);
    OrionCircuit circuitHandler = new OrionCircuit(this);

    public BOrionChannel() {
        super("orion");
    }

    protected boolean useSharedKeyEncryption() {
        return true;
    }

    Context makeOrionEncryptionContext(Context baseContext, boolean outgoing) {
        return this.makeEncryptionContext(baseContext, outgoing);
    }

    public FoxResponse process(FoxRequest req) throws Exception {
        return this.requestHandler.process(req);
    }

    public void circuitOpened(FoxCircuit circuit) throws Exception {
        this.circuitHandler.circuitOpened(circuit);
    }

    public void sessionOpened() throws Exception {
        BNavRoot.INSTANCE.addNavListener((NavListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionClosed(Throwable cause) {
        BNavRoot.INSTANCE.removeNavListener((NavListener)this);
        OrionSession[] sessions = null;
        IntHashMap intHashMap = this.sessionReg;
        synchronized (intHashMap) {
            sessions = (OrionSession[])this.sessionReg.toArray((Object[])new OrionSession[this.sessionReg.size()]);
        }
        for (int i = 0; i < sessions.length; ++i) {
            try {
                sessions[i].close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void encodePropertyValues(FoxMessage msg, String name, PropertyValue[] values) throws Exception {
        for (int i = 0; i < values.length; ++i) {
            FoxMessage vmsg = new FoxMessage(name);
            vmsg.add("name", values[i].getProperty().getName());
            vmsg.add("type", values[i].getProperty().getType().getTypeSpec().encodeToString());
            vmsg.add("value", PropertyValue.encodeValueToString(values[i].getValue()));
            msg.add(name, vmsg);
        }
    }

    PropertyValue[] decodePropertyValues(OrionType objType, FoxMessage msg, String name) throws Exception {
        FoxTuple[] msgs = msg.list(name);
        PropertyValue[] values = new PropertyValue[msgs.length];
        for (int i = 0; i < msgs.length; ++i) {
            FoxMessage valueMsg = (FoxMessage)msgs[i];
            String valueName = valueMsg.getString("name");
            Type valueType = ((BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(valueMsg.getString("type"))).getResolvedType();
            BValue value = PropertyValue.decodeValueFromString(valueType, valueMsg.getString("value"));
            values[i] = new PropertyValue(objType.getProperty(valueName), value);
        }
        return values;
    }

    void encodeParameters(FoxMessage msg, BSimple[] paramValues) throws Exception {
        FoxMessage pmsg = new FoxMessage("params");
        pmsg.add("count", paramValues.length);
        for (int i = 0; i < paramValues.length; ++i) {
            FoxMessage param = new FoxMessage("p");
            param.add("t", paramValues[i].getType().getTypeSpec().encodeToString());
            param.add("v", paramValues[i].encodeToString());
            param.add("i", i);
            pmsg.add("p", param);
        }
        msg.add("params", pmsg);
    }

    BSimple[] decodeParameters(FoxMessage msg) throws Exception {
        FoxMessage pmsg = (FoxMessage)msg.getOptional("params");
        if (pmsg == null) {
            return new BSimple[0];
        }
        int pcount = pmsg.getInt("count");
        BSimple[] paramValues = new BSimple[pcount];
        FoxTuple[] plist = pmsg.list("p");
        for (int i = 0; i < pcount; ++i) {
            FoxMessage p = (FoxMessage)plist[i];
            int index = p.getInt("i");
            Type t = ((BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(p.getString("t"))).getResolvedType();
            paramValues[index] = (BSimple)((BSimple)t.getInstance()).decodeFromString(p.getString("v"));
        }
        return paramValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int registerSession(OrionSession session) {
        IntHashMap intHashMap = this.sessionReg;
        synchronized (intHashMap) {
            int id = this.nextId;
            this.nextId = (this.nextId + 1) % 0x7FFFFFFE;
            while (this.sessionReg.get(id) != null) {
                id = this.nextId;
                this.nextId = (this.nextId + 1) % 0x7FFFFFFE;
            }
            this.sessionReg.put(id, (Object)session);
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterSession(int sessionId) {
        IntHashMap intHashMap = this.sessionReg;
        synchronized (intHashMap) {
            this.sessionReg.remove(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OrionSession getSession(int sessionId) {
        IntHashMap intHashMap = this.sessionReg;
        synchronized (intHashMap) {
            return (OrionSession)this.sessionReg.get(sessionId);
        }
    }

    void setSession(FoxOrionSession session, FoxRequest req) {
        req.add("dbId", session.getOrionDatabase().getId());
        req.add("sessionId", session.getSessionId());
        req.add("autoCommit", session.getAutoCommit());
        try {
            req.add("facets", session.getFacets().encodeToString());
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    OrionSession getSession(FoxMessage req, FoxResponse resp, boolean create) throws Exception {
        int sessionId = req.getInt("sessionId");
        boolean autoCommit = req.getBoolean("autoCommit");
        if (sessionId == -1) {
            if (create) {
                String dbId = req.getString("dbId");
                BOrionService service = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
                BOrionDatabase db = service.getOrionDatabase(dbId);
                OrionSession session = db.createSession((Context)new BasicContext(this.getSessionContext(), BFacets.make((String)req.getString("facets"))));
                session.setAutoCommit(autoCommit);
                sessionId = this.registerSession(session);
                resp.add("sessionId", sessionId);
                return session;
            }
            throw new OrionException("Invalid session id. (" + sessionId + ")");
        }
        OrionSession session = this.getSession(sessionId);
        if (session.getAutoCommit() != autoCommit) {
            session.setAutoCommit(autoCommit);
        }
        if (session == null) {
            throw new OrionException("Invalid session id. (" + sessionId + ")");
        }
        return session;
    }

    void setSession(FoxOrionSession session, FoxCircuit circuit) throws Exception {
        FoxMessage req = new FoxMessage("session");
        req.add("dbId", session.getOrionDatabase().getId());
        req.add("sessionId", session.getSessionId());
        req.add("autoCommit", session.getAutoCommit());
        try {
            req.add("facets", session.getFacets().encodeToString());
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        circuit.writeMessage(req);
        circuit.flush();
    }

    OrionSession getSession(FoxCircuit circuit, FoxMessage resp, boolean create) throws Exception {
        FoxMessage req = circuit.readMessage();
        int sessionId = req.getInt("sessionId");
        boolean autoCommit = req.getBoolean("autoCommit");
        if (sessionId == -1) {
            if (create) {
                String dbId = req.getString("dbId");
                BOrionService service = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
                BOrionDatabase db = service.getOrionDatabase(dbId);
                OrionSession session = db.createSession((Context)new BasicContext(this.getSessionContext(), BFacets.make((String)req.getString("facets"))));
                session.setAutoCommit(autoCommit);
                sessionId = this.registerSession(session);
                resp.add("sessionId", sessionId);
                return session;
            }
            throw new OrionException("Invalid session id. (" + sessionId + ")");
        }
        OrionSession session = this.getSession(sessionId);
        if (session == null) {
            throw new OrionException("Invalid session id. (" + sessionId + ")");
        }
        resp.add("sessionId", sessionId);
        if (session.getAutoCommit() != autoCommit) {
            session.setAutoCommit(autoCommit);
        }
        return session;
    }

    FoxMessage assignSessionId(FoxOrionSession session, FoxMessage resp) throws Exception {
        int sessionId = resp.getInt("sessionId", -1);
        if (sessionId == -1) {
            if (session.getSessionId() == -1) {
                throw new OrionException("Missing session id.");
            }
            return resp;
        }
        session.open(resp.getInt("sessionId"));
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void navEvent(NavEvent event) {
        BINavNode parent = event.getParent();
        if (!(parent instanceof BComponent)) {
            return;
        }
        BSpace space = ((BComponent)parent).getSpace();
        if (!(space instanceof BOrionSpace) || space instanceof BFoxOrionSpace) {
            return;
        }
        if (event.getId() != 6) {
            return;
        }
        Object object = this.syncLock;
        synchronized (object) {
            boolean startThread = false;
            if (this.syncBuffer == null) {
                startThread = true;
                this.syncBuffer = new SyncBuffer((BComponentSpace)((BOrionSpace)space), true);
            }
            switch (event.getId()) {
                case 6: {
                    this.syncBuffer.add((SyncOp)new SetCategoryMaskOp((BComponent)parent, event.getNewChildName()));
                }
            }
            if (startThread) {
                new SyncThread().start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncToClient() throws Exception {
        SyncBuffer toSend = null;
        Object object = this.syncLock;
        synchronized (object) {
            toSend = this.syncBuffer;
            this.syncBuffer = null;
        }
        this.circuitHandler.sendSyncBufferToClient(toSend);
    }

    public Type getType() {
        return TYPE;
    }

    private class SyncThread
    extends Thread {
        @Override
        public void run() {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                BOrionChannel.this.syncToClient();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

