/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db.sql;

import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.TableDefinition;
import com.tridium.orion.priv.db.sql.NameGenerator;
import com.tridium.orion.priv.db.sql.SqlHelper;
import com.tridium.orion.priv.db.sql.SqlVisitor;
import com.tridium.orion.priv.model.DynamicOrionProperty;
import com.tridium.orion.sql.BExtentProjection;
import com.tridium.orion.sql.BPage;
import com.tridium.orion.sql.BSqlCase;
import com.tridium.orion.sql.BSqlJoin;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.BSubSqlQuery;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BExpression;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.query.BQueryNode;
import javax.baja.query.BTypedExtent;
import javax.baja.query.expression.BFieldExpression;
import javax.baja.query.expression.BFunctionExpression;
import javax.baja.query.expression.BSimpleExpression;
import javax.baja.rdb.BRdbms;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Property;
import javax.baja.util.BTypeSpec;

public class SelectVisitor
extends SqlVisitor {
    protected static final BTypeSpec DB2 = BTypeSpec.make((String)"rdbDb2:Db2Database");
    protected static final BTypeSpec ORACLE = BTypeSpec.make((String)"rdbOracle:OracleDatabase");
    protected static final BTypeSpec HSQL = BTypeSpec.make((String)"rdbHsqlDb:HsqlDatabase");
    protected static final BTypeSpec SQL_SERVER = BTypeSpec.make((String)"rdbSqlServer:SqlServerDatabase");
    protected static final BTypeSpec MY_SQL = BTypeSpec.make((String)"rdbMySQL:MySQLDatabase");
    protected BQuery query;
    protected Array<Property> returnTypeProps;
    protected boolean isSelectAll = false;

    public SelectVisitor(BLocalOrionDatabase db) {
        this(db, null);
    }

    public SelectVisitor(BLocalOrionDatabase db, SqlHelper helper) {
        super(db);
        this.helper = helper;
    }

    public OrionType getResultType() {
        return this.query.getProjection() instanceof BExtentProjection ? this.getExtentType() : BOrionSpace.createDynamicType((Property[])this.returnTypeProps.trim());
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.query = null;
        this.returnTypeProps = new Array(Property.class);
        this.isSelectAll = false;
    }

    private void setBufferFromQT(StringBuffer sb) {
        sb.append(this.queryText);
        this.queryText = new StringBuffer();
    }

    private String getAlias(BExpression projectionExpr) {
        BProjectionColumn c = (BProjectionColumn)projectionExpr.getParent();
        if (c.hasAlias()) {
            return c.getAlias();
        }
        return null;
    }

    protected boolean inProjectionColumn(BQueryNode node) {
        return node.getParent() != null && node.getParent().getType().is(BProjectionColumn.TYPE);
    }

    protected OrionType getExtentType() {
        try {
            return (OrionType)this.query.getExtent().asTypedExtent().listTypes()[0];
        }
        catch (Exception x) {
            throw new OrionException("Failed to build query because the extent is not set, or is not a BTypedExtent.", x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(BQuery node) {
        this.initialize();
        this.query = node;
        this.helper = new SqlHelper(this.db, this.query);
        StringBuffer proj = new StringBuffer();
        proj.append("SELECT ");
        if (node.hasProjection()) {
            try {
                this.setUseParameterSubstitution(true);
                this.visit(node.getProjection());
                this.setBufferFromQT(proj);
            }
            finally {
                this.setUseParameterSubstitution(false);
            }
        }
        StringBuffer join = new StringBuffer();
        if (this.query instanceof BSqlQuery) {
            try {
                this.setUseParameterSubstitution(true);
                this.visit(((BSqlQuery)this.query).getJoins());
            }
            finally {
                this.setUseParameterSubstitution(false);
            }
        }
        this.setBufferFromQT(join);
        StringBuffer pred = new StringBuffer();
        if (node.hasPredicate()) {
            pred.append("WHERE ");
            this.visit(node.getPredicate());
            this.setBufferFromQT(pred);
        }
        StringBuffer groupBy = new StringBuffer();
        if (node.hasGrouping()) {
            groupBy.append("GROUP BY ");
            this.visit(node.getGrouping());
            this.setBufferFromQT(groupBy);
        }
        StringBuffer having = new StringBuffer();
        if (node.hasHaving()) {
            try {
                this.setUseParameterSubstitution(true);
                having.append("HAVING ");
                this.visit(node.getHaving());
                this.setBufferFromQT(having);
            }
            finally {
                this.setUseParameterSubstitution(false);
            }
        }
        StringBuffer orderBy = new StringBuffer();
        if (node.hasOrdering()) {
            orderBy.append("ORDER BY ");
            this.visit(node.getOrdering());
            this.setBufferFromQT(orderBy);
        }
        this.queryText.append(proj);
        if (node.hasExtent()) {
            this.queryText.append("FROM ");
            this.visit(node.getExtent());
        }
        this.queryText.append(join);
        this.queryText.append(pred);
        this.queryText.append(groupBy);
        this.queryText.append(having);
        if (this.query instanceof BSqlQuery && ((BSqlQuery)this.query).hasPage() && this.dbSupportsPagination()) {
            this.queryText = this.paginate((BSqlQuery)this.query, orderBy);
        } else {
            this.queryText.append(orderBy);
        }
    }

    public void visit(BExpression expr) {
        if (expr instanceof BSqlCase) {
            this.visit((BSqlCase)expr);
        } else if (expr instanceof BSubSqlQuery) {
            this.visitQuery((BSubSqlQuery)expr);
        } else {
            super.visit(expr);
        }
    }

    public void visit(BProjectionColumn node) {
        if (node.getColumnExpression() instanceof BFieldExpression) {
            this.visit((BFieldExpression)node.getColumnExpression());
        } else {
            super.visit(node);
        }
    }

    public void visit(BSqlJoin[] inner) {
        if (inner.length == 0) {
            return;
        }
        for (int i = 0; i < inner.length; ++i) {
            this.visit(inner[i]);
        }
    }

    public void visit(BSqlJoin join) {
        this.queryText.append(' ').append(TextUtil.toFriendly((String)join.getJoinKind().getTag()).toUpperCase()).append(' ');
        this.visit(join.getJoinTable());
        this.queryText.append(" ON ");
        this.visit(join.getOnExpr());
        this.queryText.append(' ');
    }

    @Override
    public void visit(BFieldExpression node) {
        String resolved = this.helper.resolveField(node);
        this.queryText.append(resolved);
        if (this.inProjectionColumn((BQueryNode)node)) {
            if (this.isSelectAll) {
                throw new OrionException("Orion Queries cannot contain multiple columns in the projection if '*' is specified.");
            }
            if (resolved.equals("*")) {
                this.isSelectAll = true;
            }
            String name = this.getAlias((BExpression)node);
            Property p = this.helper.getFieldProperty(node);
            if (name == null) {
                name = p.getName();
            } else {
                this.queryText.append(' ').append(this.idioms().toAliasString(name));
            }
            this.returnTypeProps.add((Object)new DynamicOrionProperty(name, p.getType(), p.getDefaultValue(), p.getFacets(), p.getDefaultFlags()));
        }
    }

    public void visit(BFunctionExpression node) {
        super.visit(node);
        if (this.inProjectionColumn((BQueryNode)node)) {
            String name = null;
            name = this.getAlias((BExpression)node);
            if (name == null) {
                SelectVisitor v = new SelectVisitor(this.db, this.helper);
                v.visit((BFunctionExpression)node.newCopy());
                name = v.getQueryString();
            }
            this.returnTypeProps.add((Object)BOrionSpace.createProperty(name, node.getFunctionType()));
        }
    }

    @Override
    public void visit(BSimpleExpression node) {
        super.visit(node);
        if (this.inProjectionColumn((BQueryNode)node)) {
            String name = null;
            name = this.getAlias((BExpression)node);
            if (name == null) {
                name = "";
            }
            this.returnTypeProps.add((Object)BOrionSpace.createProperty(name, node.getSimpleValue().getType()));
        }
    }

    public void visit(BSqlCase node) {
        this.queryText.append(" CASE ");
        if (node.hasCase()) {
            this.visit(node.getCase());
        }
        BSqlCase.WhenTuple[] whenTuples = node.getWhenTuples();
        for (int i = 0; i < whenTuples.length; ++i) {
            this.queryText.append(" WHEN ");
            this.visit(whenTuples[i].whenExpr);
            this.queryText.append(" THEN ");
            this.visit(whenTuples[i].thenExpr);
        }
        if (node.hasElse()) {
            this.queryText.append(" ELSE ");
            this.visit(node.getElse());
        }
        this.queryText.append(" END ");
    }

    public void visitQuery(BSubSqlQuery query) {
        SelectVisitor visitor = new SelectVisitor(this.db);
        visitor.visit(query.getQuery());
        Array a = visitor.parameters;
        this.parameters.addAll(a);
        visitor.parameters.clear();
        this.queryText.append("(");
        this.queryText.append(visitor.getQueryString());
        this.queryText.append(")");
    }

    public static boolean dbSupportsFlexibleOnClause(BRdbms rdbms) {
        BTypeSpec spec = rdbms.getType().getTypeSpec();
        return !spec.equals((Object)MY_SQL);
    }

    public static boolean dbSupportsFlexibleOrderByForDistict(BRdbms rdbms) {
        BTypeSpec spec = rdbms.getType().getTypeSpec();
        return spec.equals((Object)MY_SQL);
    }

    public boolean dbSupportsPagination() {
        return SelectVisitor.dbSupportsPagination(this.db.getRdbms());
    }

    public static boolean dbSupportsPagination(BRdbms rdbms) {
        BTypeSpec spec = rdbms.getType().getTypeSpec();
        if (spec.equals((Object)SQL_SERVER)) {
            BFrozenEnum version = (BFrozenEnum)rdbms.get("version");
            return !version.getTag().equals("sqlServer2000");
        }
        return spec.equals((Object)ORACLE) || spec.equals((Object)DB2) || spec.equals((Object)HSQL) || spec.equals((Object)MY_SQL);
    }

    private StringBuffer paginate(BSqlQuery query, StringBuffer orderBy) {
        OrionType base = (OrionType)((BTypedExtent)query.getExtent()).listTypes()[0];
        TableDefinition baseDef = TableDefinition.get(this.db, base);
        NameGenerator nameGen = new NameGenerator(new TableDefinition[]{baseDef});
        return new StringBuffer(this.applyPagination(nameGen, query.getPage(), orderBy.toString(), this.queryText.toString()));
    }

    private String applyPagination(NameGenerator nameGen, BPage page, String orderBy, String sql) {
        BTypeSpec spec = this.db.getRdbms().getType().getTypeSpec();
        if (spec.equals((Object)ORACLE)) {
            int minRow = page.getOffset() + 1;
            int maxRow = minRow + page.getLimit() - 1;
            String a = nameGen.generateUniqueName("A");
            String r = nameGen.generateUniqueName("R");
            return "SELECT * FROM (SELECT " + a + ".*, ROWNUM " + r + " FROM (" + sql + " " + orderBy + ") " + a + " WHERE ROWNUM <= " + maxRow + ") WHERE " + r + " >= " + minRow;
        }
        if (spec.equals((Object)DB2)) {
            int minRow = page.getOffset() + 1;
            int maxRow = minRow + page.getLimit() - 1;
            String a = nameGen.generateUniqueName("A");
            String b = nameGen.generateUniqueName("B");
            String r = nameGen.generateUniqueName("R");
            return "SELECT * FROM (SELECT " + a + ".*, ROWNUMBER() OVER (" + orderBy + ") AS " + r + " FROM (" + sql + ") AS " + a + ") AS " + b + " WHERE " + r + " <= " + maxRow + " AND " + r + " >= " + minRow;
        }
        if (spec.equals((Object)SQL_SERVER)) {
            int minRow = page.getOffset();
            int maxRow = minRow + page.getLimit();
            int range = maxRow - minRow;
            if (minRow == 0) {
                int indexOf = sql.indexOf("SELECT ");
                if (indexOf != 0) {
                    return sql;
                }
                String select = "SELECT";
                int distinctIndexOf = sql.indexOf("SELECT DISTINCT");
                if (distinctIndexOf == 0) {
                    select = "SELECT DISTINCT";
                }
                sql = select + " TOP " + range + " " + sql.substring(indexOf + select.length());
                if (orderBy == null || orderBy.length() == 0) {
                    return sql;
                }
                return sql + " " + orderBy;
            }
            String a = nameGen.generateUniqueName("A");
            String b = nameGen.generateUniqueName("B");
            String r = nameGen.generateUniqueName("R");
            if (orderBy == null || orderBy.length() == 0) {
                orderBy = "ORDER BY (SELECT 1)";
            } else {
                String[] split = TextUtil.split((String)orderBy, (char)' ');
                for (int i = 0; i < split.length; ++i) {
                    if (split[i].indexOf(".") <= -1) continue;
                    split[i] = a + split[i].substring(split[i].indexOf("."));
                }
                orderBy = TextUtil.join((String[])split, (char)' ');
            }
            return "SELECT TOP " + range + " * FROM (SELECT *, ROW_NUMBER() OVER (" + orderBy + ") AS " + r + " FROM (" + sql + ") " + a + ") " + b + " WHERE " + r + " > " + minRow;
        }
        if (spec.equals((Object)HSQL)) {
            int n = sql.indexOf(32);
            if (page.getOffset() == 0) {
                return sql.substring(0, n) + " TOP " + page.getLimit() + " " + sql.substring(n) + " " + orderBy;
            }
            return sql.substring(0, n) + " LIMIT " + page.getOffset() + " " + page.getLimit() + sql.substring(n) + " " + orderBy;
        }
        if (spec.equals((Object)MY_SQL)) {
            orderBy = orderBy == null || orderBy.length() == 0 ? "" : " " + orderBy;
            return sql + orderBy + " LIMIT " + page.getOffset() + ", " + page.getLimit();
        }
        throw new IllegalStateException();
    }
}

