/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.db.TableDefinition;
import com.tridium.orion.sql.BatchStatement;
import com.tridium.rdb.jdbc.RdbmsDialect;
import java.sql.Connection;
import java.util.logging.Logger;
import javax.baja.nre.util.Array;

public abstract class DbBatch
implements BatchStatement {
    protected final Logger log = Logger.getLogger("orion.jdbc");
    protected final DbOrionSession session;
    protected final BLocalOrionDatabase db;
    protected final RdbmsDialect dialect;
    protected final Connection conn;
    protected final OrionType type;
    protected final Array arr;
    protected final TableDefinition tableDef;
    protected int chunkSize;

    public DbBatch(DbOrionSession session, OrionType type) {
        this.session = session;
        this.db = (BLocalOrionDatabase)session.getOrionDatabase();
        this.dialect = (RdbmsDialect)this.db.getRdbms().getRdbmsContext();
        this.conn = session.getConnection();
        this.type = type;
        this.arr = new Array(type.getTypeClass());
        this.tableDef = TableDefinition.get(this.db, type);
    }

    @Override
    public void add(BIOrionObject object) {
        if (!object.getOrionType().equals(this.type)) {
            throw new OrionException("Type mismatch: object type (" + object.getOrionType() + ")  is not the same as the batch type (" + this.type + ").");
        }
        this.arr.add((Object)object);
    }

    @Override
    public BIOrionObject get(int index) {
        return (BIOrionObject)this.arr.get(index);
    }

    @Override
    public int size() {
        return this.arr.size();
    }

    @Override
    public void clear() {
        this.arr.clear();
    }

    @Override
    public OrionType getOrionType() {
        return this.type;
    }

    @Override
    public void setChunkSize(int chunkSize) {
        if (chunkSize < 0) {
            throw new OrionException("Invalid chunkSize of '" + chunkSize + "'.  The chunkSize must be >= 0.");
        }
        this.chunkSize = chunkSize;
    }

    @Override
    public int getChunkSize() {
        return this.chunkSize;
    }
}

