/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion;

import java.util.HashMap;
import javax.baja.naming.BasicQuery;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.SyntaxException;
import javax.baja.nre.util.Array;

public class OrionQuery
extends BasicQuery {
    private String dbName;
    private String moduleName;
    private String typeName;
    private PathElem[] path;

    public OrionQuery(String body) {
        super("orion", body);
        this.parse(body);
    }

    public boolean isSpace() {
        return this.getBody().length() == 0;
    }

    public boolean isRoot() {
        return !this.isSpace() && this.dbName == null && this.moduleName == null && this.typeName == null;
    }

    public String getDatabaseName() {
        return this.dbName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getPathLength() {
        return this.path.length;
    }

    public String getPathName(int index) {
        return this.path[index].name;
    }

    public String[] getParamNames(int index) {
        return this.path[index].getParamNames();
    }

    public String getParam(int index, String paramName) {
        return this.path[index].getParam(paramName);
    }

    public void normalize(OrdQueryList list, int index) {
        if (this.dbName != null) {
            list.shiftToSession(index);
            if (list.isSameScheme(index, index + 1)) {
                OrionQuery q1 = this;
                OrionQuery q2 = (OrionQuery)list.get(index + 1);
                if (q1.getDatabaseName() != null && q2.getDatabaseName() == null) {
                    list.merge(index, (OrdQuery)new OrionQuery("//" + q1.getDatabaseName() + q2.getBody()));
                }
            }
        }
    }

    private void parse(String body) {
        int to;
        if (body.length() == 0) {
            return;
        }
        int pathStart = 0;
        int from = 0;
        if (body.startsWith("//")) {
            pathStart = body.indexOf(47, 2);
            if (pathStart == -1) {
                this.dbName = body.substring(2);
            } else {
                this.dbName = body.substring(2, pathStart);
                from = pathStart;
            }
            if (this.dbName == null || this.dbName.length() == 0) {
                this.dbName = null;
                return;
            }
            if (pathStart == -1) {
                return;
            }
        } else {
            from = body.indexOf(47);
            if (from != 0) {
                throw new SyntaxException("Orion query must begin with a /.");
            }
        }
        Array tempPath = new Array(PathElem.class);
        do {
            if ((to = body.indexOf(47, from + 1)) == -1) {
                tempPath.add((Object)new PathElem(body.substring(from + 1)));
                break;
            }
            tempPath.add((Object)new PathElem(body.substring(from + 1, to)));
            from = to;
        } while (to != -1);
        int pathLen = tempPath.size();
        this.moduleName = null;
        this.typeName = null;
        if (pathLen >= 1) {
            this.moduleName = ((PathElem)tempPath.get((int)0)).name;
        }
        if (pathLen >= 2) {
            this.typeName = ((PathElem)tempPath.get((int)1)).name;
        }
        this.path = pathLen > 2 ? (PathElem[])tempPath.copy(2).trim() : new PathElem[0];
    }

    public static class PathElem {
        public final String name;
        private HashMap<String, String> params;

        public PathElem(String s) {
            if (s.length() == 0) {
                throw new SyntaxException("Path element length == 0.");
            }
            this.name = this.parse(s);
        }

        public String toString() {
            return this.name;
        }

        public String[] getParamNames() {
            return this.params.keySet().toArray(new String[this.params.size()]);
        }

        public String getParam(String name) {
            return this.params.get(name);
        }

        private String parse(String s) {
            int colon = s.indexOf(58);
            if (colon == -1) {
                return s;
            }
            this.params = this.parseParams(s.substring(colon + 1));
            return s.substring(0, colon);
        }

        private HashMap<String, String> parseParams(String s) {
            if (s.length() == 0) {
                throw new SyntaxException("Empty parameter list.");
            }
            HashMap<String, String> tempParams = new HashMap<String, String>();
            int from = 0;
            int to = 0;
            do {
                if ((to = s.indexOf(61, from)) == -1) {
                    throw new SyntaxException("Invalid parameter list: " + s);
                }
                String paramName = s.substring(from, to);
                from = to + 1;
                String paramValue = (to = s.indexOf(59, from)) == -1 ? s.substring(from) : s.substring(from, to);
                tempParams.put(paramName, paramValue);
                from = to + 1;
            } while (to != -1);
            return tempParams;
        }
    }
}

