/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionModule;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.BOrionType;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionQuery;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.fox.BFoxOrionSpace;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.util.EscUtil;
import java.io.IOException;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.Array;
import javax.baja.rdb.BRdbms;
import javax.baja.space.BSpace;
import javax.baja.space.BSpaceScheme;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BOrionScheme
extends BSpaceScheme {
    static OrionEsc esc = new OrionEsc();
    public static final String SCHEME = "orion";
    public static final BOrionScheme INSTANCE = new BOrionScheme();
    public static final Type TYPE = Sys.loadType(BOrionScheme.class);

    protected BOrionScheme() {
        super(SCHEME);
    }

    public Type getSpaceType() {
        return BOrionSpace.TYPE;
    }

    public OrdQuery parse(String queryBody) {
        return new OrionQuery(queryBody);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrdTarget resolve(OrdTarget base, OrdQuery query, BSpace space) {
        BOrionType type;
        BOrionModule module;
        OrionQuery oq = (OrionQuery)query;
        if (oq.isSpace()) {
            return new OrdTarget(base, (BObject)space);
        }
        if (oq.isRoot()) {
            return new OrdTarget(base, (BObject)((BOrionSpace)space).getRootComponent());
        }
        BOrionDatabase db = null;
        String dbName = oq.getDatabaseName();
        if (dbName != null) {
            db = ((BOrionSpace)space).getOrionDatabase(dbName);
        } else {
            BObject baseObj = base.get();
            if (baseObj instanceof BRdbms) {
                db = ((BOrionSpace)space).getOrionDatabase((BRdbms)baseObj);
            } else if (baseObj instanceof BOrionDatabase) {
                db = (BOrionDatabase)baseObj;
            } else {
                throw new UnresolvedException("Invalid ord base: " + baseObj);
            }
        }
        String moduleName = oq.getModuleName();
        if (moduleName == null) {
            return new OrdTarget(base, (BObject)db);
        }
        if (space instanceof BFoxOrionSpace) {
            db.loadSlots();
        }
        if ((module = db.getModule(moduleName)) == null) {
            throw new UnresolvedException("Module not found: " + moduleName);
        }
        String typeName = oq.getTypeName();
        if (typeName == null) {
            return new OrdTarget(base, (BObject)module);
        }
        if (space instanceof BFoxOrionSpace) {
            module.loadSlots();
        }
        if ((type = module.getType(typeName)) == null) {
            throw new UnresolvedException("Type not found: " + typeName);
        }
        int pathLen = oq.getPathLength();
        if (pathLen == 0) {
            return new OrdTarget(base, (BObject)type);
        }
        if (space instanceof BFoxOrionSpace) {
            type.loadSlots();
        }
        BValue current = null;
        Array props = new Array(Property.class);
        BComponent component = null;
        for (int p = 0; p < pathLen; ++p) {
            if (oq.getPathName(p).equals("key") && p == 0) {
                OrionType orionType = type.getOrionType();
                Property[] key = orionType.getKey();
                PropertyValue[] keyVals = new PropertyValue[key.length];
                for (int i = 0; i < key.length; ++i) {
                    BSimple def = (BSimple)key[i].getDefaultValue();
                    BSimple keyValue = null;
                    String paramValue = oq.getParam(p, key[i].getName());
                    try {
                        keyValue = (BSimple)def.decodeFromString(esc.unescape(paramValue));
                    }
                    catch (IOException ex) {
                        throw new UnresolvedException("Cannot decode key value: " + paramValue, (Throwable)ex);
                    }
                    keyVals[i] = new PropertyValue(key[i], (BValue)keyValue);
                }
                BIOrionObject obj = null;
                try (OrionSession session = db.createSession(null);){
                    obj = session.read(orionType, keyVals);
                }
                if (obj == null) {
                    throw new UnresolvedException();
                }
                current = (BObject)obj;
                if (!(current instanceof BComponent)) continue;
                component = (BComponent)current;
                continue;
            }
            if (component == null) {
                throw new UnresolvedException();
            }
            String propName = oq.getPathName(p);
            if (current instanceof BIOrionObject) {
                BIOrionObject obj = (BIOrionObject)current;
                OrionType orionType = obj.getOrionType();
                Property prop = orionType.getProperty(propName);
                if (prop == null) {
                    throw new UnresolvedException();
                }
                props.add((Object)prop);
                current = obj.get(prop);
                continue;
            }
            if (!(current instanceof BComplex)) continue;
            Property prop = ((BComplex)current).getProperty(propName);
            if (prop == null) {
                throw new UnresolvedException();
            }
            props.add((Object)prop);
            current = ((BComplex)current).get(prop);
        }
        if (props.size() == 0) {
            return new OrdTarget(base, current);
        }
        Property[] propPath = (Property[])props.trim();
        return new OrdTarget(base, component, current, (Slot)propPath[0], propPath);
    }

    public static BOrd getOrdInSpace(BOrionDatabase db) {
        return BOrd.make((String)("orion://" + db.getName()));
    }

    public static BOrd getOrdInSpace(BOrionDatabase db, BOrionTypeId typeId) {
        if (typeId.isDynamic()) {
            return BOrd.NULL;
        }
        if (db != null) {
            return BOrd.make((String)("orion://" + db.getName() + "/" + typeId.getModuleName() + "/" + typeId.getTypeName()));
        }
        return BOrd.make((String)("orion:/" + typeId.getModuleName() + "/" + typeId.getTypeName()));
    }

    public static BOrd getOrdInSpace(BOrionModule module) {
        BOrionDatabase db = module.getOrionDatabase();
        if (db != null) {
            return BOrd.make((String)("orion://" + db.getName() + "/" + module.getName()));
        }
        return BOrd.make((String)("orion:/" + module.getName()));
    }

    public static BOrd getOrdInSpace(BOrionType type) {
        BOrionDatabase db = type.getOrionDatabase();
        if (db == null) {
            return null;
        }
        if (db != null) {
            return BOrd.make((String)("orion://" + db.getName() + "/" + type.getModule().getName() + "/" + type.getName()));
        }
        return BOrd.make((String)("orion:/" + type.getModule().getName() + "/" + type.getName()));
    }

    public static BOrd getOrdInSpace(BIOrionObject obj) {
        String keys = BOrionScheme.encodeKeysToString(obj);
        BOrionDatabase db = obj.getOrionDatabase();
        OrionType type = obj.getOrionType();
        if (db == null) {
            return BOrd.make((String)("orion:/" + type.getModule().getModuleName() + "/" + type.getTypeName() + "/key:" + keys));
        }
        return BOrd.make((String)("orion://" + db.getName() + "/" + type.getModule().getModuleName() + "/" + type.getTypeName() + "/key:" + keys));
    }

    public static BOrd makeOrdInSession(BOrd dbOrd, OrionType type, PropertyValue[] keyValues) throws Exception {
        if (keyValues == null || keyValues.length == 0) {
            throw new IllegalArgumentException("Key values required.");
        }
        StringBuffer s = new StringBuffer(128);
        s.append(dbOrd);
        s.append('/').append(type.getModule().getModuleName());
        s.append('/').append(type.getTypeName());
        s.append('/').append("key:");
        for (int i = 0; i < keyValues.length; ++i) {
            if (i != 0) {
                s.append(';');
            }
            s.append(keyValues[i].getProperty().getName()).append("=").append(esc.escape(((BSimple)keyValues[i].getValue()).encodeToString()));
        }
        return BOrd.make((String)s.toString());
    }

    public static String encodeKeysToString(BIOrionObject obj) {
        OrionType type = obj.getOrionType();
        Property[] key = type.getKey();
        return BOrionScheme.encodePropertiesToString(obj, key);
    }

    public static String encodePropertiesToString(BIOrionObject obj, Property[] key) {
        StringBuffer keyStr = new StringBuffer(64);
        for (int i = 0; i < key.length; ++i) {
            if (i != 0) {
                keyStr.append(';');
            }
            BSimple keyVal = (BSimple)obj.get(key[i]);
            keyStr.append(key[i].getName());
            keyStr.append('=');
            try {
                keyStr.append(esc.escape(keyVal.encodeToString()));
                continue;
            }
            catch (IOException ex) {
                throw new OrionException("Cannot encodePropertiesToString for: " + obj.getType());
            }
        }
        return keyStr.toString();
    }

    public Type getType() {
        return TYPE;
    }

    static class OrionEsc
    extends EscUtil {
        OrionEsc() {
        }

        public boolean isStart(int c) {
            return c != 59;
        }

        public boolean isPart(int c) {
            return c != 59;
        }
    }
}

