/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetAws.ui.config;

import com.tridium.bacnet.ui.config.BBacnetConfigManager;
import com.tridium.bacnetAws.BBacnetAwsDevice;
import com.tridium.bacnetAws.datatypes.BCreateObjectParameters;
import com.tridium.bacnetAws.datatypes.BObjectParameters;
import com.tridium.driver.util.StringUtil;
import com.tridium.sys.registry.NTypeInfo;
import java.util.Comparator;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.config.BBacnetDeviceObject;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BBacnetAwsConfigManager
extends BBacnetConfigManager {
    public static final Type TYPE = Sys.loadType(BBacnetAwsConfigManager.class);
    static final UiLexicon lex = UiLexicon.makeUiLexicon(BBacnetAwsConfigManager.class);
    private static final int OBJECT_IDENT_COLUMN = 2;

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new AwsModel(this);
    }

    protected MgrController makeController() {
        return new AwsController(this);
    }

    CommandArtifact doCreate() throws Exception {
        MgrEdit edit = this.getController().promptForNew(null);
        if (edit == null) {
            return null;
        }
        MgrEditRow[] rows = edit.getRows();
        if (rows.length == 0) {
            return null;
        }
        edit.checkTargetNames();
        if (!edit.prompt()) {
            return null;
        }
        String[] names = new String[rows.length];
        BBacnetObjectIdentifier[] oids = new BBacnetObjectIdentifier[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            BBacnetObjectIdentifier oid;
            BValue cell = rows[i].getCell(2);
            if (cell == null || !(cell instanceof BBacnetObjectIdentifier)) continue;
            names[i] = rows[i].getName();
            oids[i] = oid = (BBacnetObjectIdentifier)cell;
        }
        BComponent parent = edit.getAddContainer();
        BOrd parentOrd = parent.getOrdInSession();
        BCreateObjectParameters params = new BCreateObjectParameters();
        params.setParentOrd(parentOrd);
        params.setObjectIds(StringUtil.toString((BSimple[])oids));
        params.setNames(StringUtil.toString((String[])names));
        this.getAwsDevice().createObject(params);
        return null;
    }

    CommandArtifact doDelete() throws Exception {
        BComponent[] ca = this.getController().getSelectedComponents();
        BOrd[] ords = new BOrd[ca.length];
        BBacnetObjectIdentifier[] oids = new BBacnetObjectIdentifier[ca.length];
        for (int i = 0; i < ca.length; ++i) {
            oids[i] = ((BBacnetObject)ca[i]).getObjectId();
            ords[i] = ca[i].getOrdInSpace();
        }
        BObjectParameters params = new BObjectParameters();
        params.setOrds(StringUtil.toString((BSimple[])ords));
        params.setObjectIds(StringUtil.toString((BSimple[])oids));
        this.getAwsDevice().deleteObject(params);
        return null;
    }

    BBacnetAwsDevice getAwsDevice() {
        return (BBacnetAwsDevice)super.getDevice();
    }

    public class AwsController
    extends BBacnetConfigManager.Controller {
        public final MgrController.MgrCommand create;
        public final MgrController.MgrCommand delete;

        public AwsController(BBacnetAwsConfigManager manager) {
            super((BBacnetConfigManager)BBacnetAwsConfigManager.this, (BBacnetConfigManager)manager);
            this.create = new Create((BWidget)manager);
            this.delete = new Delete((BWidget)manager);
            this.create.setFlags(7);
            this.delete.setFlags(7);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return AwsController.append((MgrController.IMgrCommand[])super.makeCommands(), (MgrController.IMgrCommand[])new MgrController.IMgrCommand[]{this.create, this.delete});
        }

        public BWidget makeActionBar() {
            MgrController.IMgrCommand[] cmds = super.makeCommands();
            MgrController.IMgrCommand[] cmds2 = new MgrController.IMgrCommand[]{this.create, this.delete};
            BEdgePane pane = new BEdgePane();
            pane.setTop(this.makeActionPane(cmds));
            pane.setCenter((BWidget)new BBorderPane(this.makeActionPane(cmds2)));
            return pane;
        }

        public void updateCommands() {
            super.updateCommands();
            BBacnetDevice dev = BBacnetAwsConfigManager.this.getDevice();
            this.create.setEnabled(dev.isServiceSupported("createObject"));
            this.delete.setEnabled(dev.isServiceSupported("deleteObject") && this.getSelectedRows().length > 0);
        }

        class Delete
        extends MgrController.MgrCommand {
            Delete(BWidget owner) {
                super(owner, (Lexicon)lex, "configCommand.delete");
            }

            public CommandArtifact doInvoke() throws Exception {
                return BBacnetAwsConfigManager.this.doDelete();
            }
        }

        class Create
        extends MgrController.MgrCommand {
            Create(BWidget owner) {
                super(owner, (Lexicon)lex, "configCommand.create");
            }

            public CommandArtifact doInvoke() throws Exception {
                return BBacnetAwsConfigManager.this.doCreate();
            }
        }
    }

    public class AwsModel
    extends BBacnetConfigManager.Model {
        public AwsModel(BBacnetAwsConfigManager mgr) {
            super((BBacnetConfigManager)BBacnetAwsConfigManager.this, (BBacnetConfigManager)mgr);
        }

        public MgrTypeInfo[] getNewTypes() {
            Array a = new Array(TypeInfo.class);
            TypeInfo[] types = Sys.getRegistry().getConcreteTypes(BBacnetObject.TYPE.getTypeInfo());
            for (int i = 0; i < types.length; ++i) {
                if (types[i].is(BBacnetDeviceObject.TYPE)) continue;
                a.add((Object)types[i]);
            }
            a = a.sort((Comparator)new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (o1 == null || o2 == null) {
                        throw new NullPointerException();
                    }
                    if (o1 instanceof NTypeInfo && o2 instanceof NTypeInfo) {
                        NTypeInfo n1 = (NTypeInfo)o1;
                        NTypeInfo n2 = (NTypeInfo)o2;
                        BBacnetObject b1 = (BBacnetObject)n1.getInstance();
                        BBacnetObject b2 = (BBacnetObject)n2.getInstance();
                        if (b1.getType() == BBacnetObject.TYPE) {
                            return b2.getType() == BBacnetObject.TYPE ? 0 : 100;
                        }
                        if (b2.getType() == BBacnetObject.TYPE) {
                            return -100;
                        }
                        return b1.getObjectType().getOrdinal() - b2.getObjectType().getOrdinal();
                    }
                    throw new ClassCastException("Cannot compare " + o1.getClass() + " and " + o2.getClass());
                }
            });
            MgrTypeInfo[] ret = MgrTypeInfo.makeArray((TypeInfo[])((TypeInfo[])a.trim()));
            return ret;
        }
    }
}

