/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetAws.migration;

import java.io.File;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.log.Log;
import javax.baja.nre.util.FileUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.xml.XElem;

public class MigrateOwsToAws {
    protected static final String MODULE_AWS = "bacAws=bacnetAws";
    protected static final String MODULE_OWS = "bacOws=bacnetOws";
    protected static final String MODULE_BAC = "bac=bacnet";
    protected final File input;
    protected final File stubbed;
    private static final Logger logger = Logger.getLogger("migration");
    private static final Log loggerXml = Log.getLog((String)"sys.xml");

    public MigrateOwsToAws(File input) {
        this.input = input;
        this.stubbed = new File(input.getParentFile(), "stub_" + input.getName());
        this.stubbed.deleteOnExit();
        loggerXml.setSeverity(3);
    }

    public final void convert() throws Exception {
        this.log("\nMigrating " + this.input.getAbsolutePath() + " ...");
        this.stubBog();
        this.migrateBog();
    }

    protected void log(String msg) {
        System.out.println(msg);
    }

    private void stubBog() throws Exception {
        XElem bog = ((ValueDocDecoder.BogElement)new ValueDocDecoder(this.input).parse()).getXmlElement();
        LinkedList<XElem> todo = new LinkedList<XElem>();
        todo.add(bog);
        while (!todo.isEmpty()) {
            XElem elem = (XElem)todo.removeFirst();
            this.stub(elem);
            XElem[] children = elem.elems();
            for (int i = 0; i < children.length; ++i) {
                todo.add(children[i]);
            }
        }
        bog.write(this.stubbed);
    }

    private void stub(XElem elem) throws Exception {
        String t = elem.get("t", null);
        if (t == null) {
            return;
        }
        String[] toks = TextUtil.split((String)t, (char)':');
        if ("bacOws".equals(toks[0])) {
            if ("BacnetOwsNetwork".equals(toks[1])) {
                this.stub(elem, MODULE_AWS, "bacAws:BacnetAwsNetwork");
            } else if ("BacnetOwsDeviceFolder".equals(toks[1])) {
                this.stub(elem, MODULE_AWS, "bacAws:BacnetAwsDeviceFolder");
            } else if ("BacnetOwsHistoryDeviceExt".equals(toks[1])) {
                this.stub(elem, MODULE_AWS, "bacAws:BacnetAwsHistoryDeviceExt");
            } else if ("LocalBacnetOwsDevice".equals(toks[1])) {
                this.stub(elem, MODULE_AWS, "bacAws:LocalBacnetAwsDevice");
            } else if ("BacnetThreadPoolWorker".equals(toks[1])) {
                this.stub(elem, MODULE_OWS, "bacOws:BacnetThreadPoolWorker");
            }
        } else if ("bac".equals(toks[0])) {
            if ("BacnetDevice".equals(toks[1])) {
                this.stubIfContainedBy(elem, MODULE_AWS, "bacAws:BacnetAwsDevice", "bacAws:BacnetAwsNetwork");
            }
            if ("BacnetHistoryDeviceExt".equals(toks[1])) {
                this.stubIfContainedBy(elem, MODULE_AWS, "bacAws:BacnetAwsHistoryDeviceExt", "bacAws:BacnetAwsDevice");
            }
            if ("BacnetConfigDeviceExt".equals(toks[1])) {
                this.stubIfContainedBy(elem, MODULE_AWS, "bacAws:BacnetAwsConfigDeviceExt", "bacAws:BacnetAwsDevice");
            }
        } else {
            this.doStub(elem, toks[0], toks[1]);
        }
    }

    protected void stub(XElem elem, String moduleStr, String typeStr) {
        elem.setAttr("m", moduleStr);
        elem.setAttr("t", typeStr);
    }

    protected void stubIfContainedBy(XElem elem, String moduleStr, String typeStr, String parentTypeStr) {
        boolean parentMatch = false;
        for (XElem x = elem.parent(); x != null; x = x.parent()) {
            if (!x.get("t", "").equals(parentTypeStr)) continue;
            parentMatch = true;
            break;
        }
        if (parentMatch) {
            elem.setAttr("t", typeStr);
        }
    }

    protected void doStub(XElem elem, String module, String type) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateBog() throws Exception {
        BComponent station = new ValueDocDecoder(this.stubbed).decodeDocument().asComponent();
        this.scanStubbedStation(station);
        this.doMigration();
        File parent = this.input.getParentFile();
        File preMig = new File(parent, "preMigrate_" + this.input.getName());
        FileUtil.move((File)this.input, (File)preMig);
        this.log("Backed up original bog as: " + preMig.getAbsolutePath());
        encoder.setZipped(true);
        try (ValueDocEncoder encoder = new ValueDocEncoder(this.input);){
            encoder.encodeDocument((BValue)station);
            this.log("Success! Migrated bog: " + this.input.getAbsolutePath());
        }
    }

    private void scanStubbedStation(BComponent station) {
        BComponent c;
        LinkedList<BComponent> todo = new LinkedList<BComponent>();
        todo.add(station);
        while (!todo.isEmpty() && !this.scanned(c = (BComponent)todo.removeFirst())) {
            BComponent[] children = c.getChildComponents();
            for (int i = 0; i < children.length; ++i) {
                todo.add(children[i]);
            }
        }
        todo.clear();
    }

    protected boolean scanned(BComponent c) {
        return true;
    }

    protected void doMigration() throws Exception {
    }

    public static void main(String[] args) throws Exception {
        try {
            if (args.length == 0) {
                MigrateOwsToAws.usage("Missing bog file argument");
            }
            MigrateOwsToAws.migrate(new File(args[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            MigrateOwsToAws.exitWithStatusCode(2);
        }
        MigrateOwsToAws.exitWithStatusCode(0);
    }

    public static void usage(String msg) {
        if (msg != null) {
            System.err.println("ERROR: " + msg);
        }
        System.out.println("  MigrateOwsToAws <bog>\n");
        MigrateOwsToAws.exitWithStatusCode(1);
    }

    private static void migrate(File input) throws Exception {
        XElem bog = ((ValueDocDecoder.BogElement)new ValueDocDecoder(input).parse()).getXmlElement();
        LinkedList<XElem> todo = new LinkedList<XElem>();
        todo.add(bog);
        while (!todo.isEmpty()) {
            XElem elem = (XElem)todo.removeFirst();
            XElem[] children = elem.elems();
            for (int i = 0; i < children.length; ++i) {
                todo.add(children[i]);
            }
        }
        MigrateOwsToAws migrator = new MigrateOwsToAws(input);
        migrator.convert();
    }

    private static void exitWithStatusCode(int errorCode) {
        try {
            if (errorCode == 0) {
                logger.info("exiting JVM successfully ");
            } else {
                logger.severe("exiting JVM  with error code :" + errorCode);
            }
            System.exit(errorCode);
        }
        catch (Exception e) {
            logger.severe("failed to exit JVM :" + e);
        }
    }
}

