/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.nav.tree;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.workbench.nav.NavMonitor;
import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavFileNode;
import javax.baja.nav.BNavFileSpace;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.virtual.BVirtualGateway;
import javax.baja.workbench.nav.tree.NavTreeModel;

public class NavTreeNode
extends TreeNode {
    private static ThreadLocal<BINavNode> currentNodeInRefresh = new ThreadLocal();
    static BImage defaultIcon = BImage.make((String)"module://icons/x16/object.png");
    final BINavNode navNode;
    String navName;
    BOrd navOrd;
    protected NavTreeNode[] children;
    BIcon icon;
    BImage iconImage;
    boolean isDragOver;
    boolean performFullLoad = false;
    boolean buildChildren = false;

    public NavTreeNode(NavTreeNode parent, BINavNode navNode) {
        this((NavTreeModel)parent.getModel(), parent, navNode);
    }

    public NavTreeNode(NavTreeModel model, NavTreeNode parent, BINavNode navNode) {
        super((TreeModel)model, (TreeNode)parent);
        this.navNode = navNode;
        this.navName = navNode.getNavName();
        this.navOrd = navNode.getNavOrd();
        model.add(this);
    }

    public Object getSubject() {
        return this.navNode;
    }

    public BINavNode getNavNode() {
        return this.navNode;
    }

    public String getText() {
        return this.navNode.getNavDisplayName(null);
    }

    public BImage getIcon() {
        BIcon icon = this.navNode.getNavIcon();
        if (icon != this.icon) {
            this.icon = icon;
            this.iconImage = BImage.make((BIcon)icon);
            this.iconImage.sync();
        }
        if (this.iconImage == null) {
            this.iconImage = defaultIcon;
        }
        if (this.navNode instanceof BISpaceNode && ((BISpaceNode)this.navNode).isPendingMove()) {
            return this.iconImage.getDisabledImage();
        }
        return this.iconImage;
    }

    public boolean hasChildren() {
        return this.navNode.hasNavChildren();
    }

    public int getChildCount() {
        return this.getChildren().length;
    }

    public TreeNode getChild(int index) {
        return this.getChildren()[index];
    }

    public NavTreeNode getChild(String navName, boolean autoLoad) {
        if (this.children == null && !autoLoad) {
            return null;
        }
        NavTreeNode[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!navName.equals(children[i].navName)) continue;
            return children[i];
        }
        return null;
    }

    public NavTreeNode getChild(BINavNode navNode, boolean autoLoad) {
        if (this.children == null && !autoLoad) {
            return null;
        }
        NavTreeNode[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!navNode.equals(children[i].navNode)) continue;
            return children[i];
        }
        return null;
    }

    public NavTreeNode[] getChildren() {
        if (this.buildChildren || this.children == null) {
            this.buildChildren = false;
            BWidgetShell shell = this.getShell();
            if (shell != null) {
                shell.enterBusy();
            }
            try {
                this.children = this.buildChildren();
            }
            catch (Throwable e) {
                this.children = new NavTreeNode[0];
                e.printStackTrace();
                BDialog.error((BWidget)this.getTree(), (String)BDialog.TITLE_ERROR, (Object)"Cannot expand tree", (Throwable)e);
            }
            finally {
                if (shell != null) {
                    shell.exitBusy();
                }
            }
        }
        return this.children;
    }

    protected NavTreeNode[] buildChildren() {
        NavTreeModel model = (NavTreeModel)this.getModel();
        BINavNode[] navKids = this.navNode.getNavChildren();
        ArrayList<NavTreeNode> acc = new ArrayList<NavTreeNode>(navKids.length);
        for (int i = 0; i < navKids.length; ++i) {
            NavTreeNode node = model.makeNavTreeNode(this, navKids[i]);
            if (node == null) continue;
            acc.add(node);
        }
        return acc.toArray(new NavTreeNode[acc.size()]);
    }

    public void addChild(NavTreeNode child) {
        if (this.children == null) {
            return;
        }
        if (child == null) {
            throw new NullPointerException();
        }
        NavTreeNode[] temp = new NavTreeNode[this.children.length + 1];
        System.arraycopy(this.children, 0, temp, 0, this.children.length);
        temp[this.children.length] = child;
        this.children = temp;
        this.getModel().updateTree();
    }

    public void removeChild(NavTreeNode child) {
        ((NavTreeModel)this.getModel()).remove(child);
        if (this.children == null || this.children.length == 0) {
            return;
        }
        if (child == null) {
            throw new NullPointerException();
        }
        if (this.getNavNode() instanceof BComponent) {
            BComponent comp = (BComponent)this.getNavNode();
            if (comp instanceof BVirtualGateway) {
                try {
                    comp = ((BVirtualGateway)comp).getVirtualSpace().getRootComponent();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!((ComponentSlotMap)comp.fw(1)).isBrokerPropsLoaded()) {
                this.performFullLoad = true;
            }
        }
        NavTreeNode[] kids = this.children;
        NavTreeNode[] temp = new NavTreeNode[kids.length - 1];
        boolean found = false;
        int n = 0;
        for (int i = 0; i < kids.length; ++i) {
            boolean match;
            boolean bl = match = kids[i] == child;
            if (!match && n >= temp.length) {
                return;
            }
            if (!found && match) {
                found = true;
                continue;
            }
            temp[n++] = kids[i];
        }
        if (found) {
            this.children = temp;
            if (this.children == null || this.children.length == 0) {
                this.getTree().setExpanded((TreeNode)this, false);
            }
            this.getModel().updateTree();
        }
    }

    public void replaceChild(NavTreeNode oldChild, NavTreeNode newChild) {
        ((NavTreeModel)this.getModel()).remove(oldChild);
        ((NavTreeModel)this.getModel()).add(newChild);
        boolean match = false;
        boolean n = false;
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] != oldChild) continue;
            match = true;
            this.children[i] = newChild;
        }
        if (!match) {
            throw new IllegalStateException();
        }
        if (oldChild.isExpanded()) {
            newChild.setExpanded(true);
        }
        this.getModel().updateTree();
    }

    public void expanded() {
        if (this.performFullLoad) {
            this.performFullLoad = false;
            this.buildChildren = true;
        }
        NavMonitor.touch();
    }

    public static boolean performingRefresh(BINavNode navNode) {
        if (navNode == null) {
            return false;
        }
        return navNode == currentNodeInRefresh.get();
    }

    public void refresh() {
        this.refresh(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh(boolean update) {
        try {
            int i;
            currentNodeInRefresh.set(this.navNode);
            if (update && this.navNode instanceof BComponent) {
                BComponentSpace space;
                BComponent comp = (BComponent)this.navNode;
                if (comp instanceof BVirtualGateway) {
                    try {
                        comp = ((BVirtualGateway)comp).getVirtualSpace().getRootComponent();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((space = comp.getComponentSpace()) != null) {
                    space.update(comp, 0);
                }
            }
            if (update && (this.navNode instanceof BNavFileSpace || this.navNode instanceof BNavFileNode)) {
                for (BINavNode p = this.navNode; p != null; p = p.getNavParent()) {
                    if (!(p instanceof BFoxSession)) continue;
                    BFoxSession session = (BFoxSession)p;
                    session.loadNavFileSpace();
                    break;
                }
            }
            if (this.children == null) {
                return;
            }
            NavTreeModel model = (NavTreeModel)this.getModel();
            BINavNode[] navKids = this.navNode.getNavChildren();
            NavTreeNode[] existing = (NavTreeNode[])this.children.clone();
            ArrayList<NavTreeNode> acc = new ArrayList<NavTreeNode>();
            for (i = 0; i < navKids.length; ++i) {
                BINavNode navKid = navKids[i];
                NavTreeNode treeKid = null;
                for (int j = 0; j < existing.length; ++j) {
                    if (existing[j] == null || !navKid.equals(existing[j].navNode)) continue;
                    treeKid = existing[j];
                    treeKid.remap();
                    existing[j] = null;
                    break;
                }
                if (treeKid == null) {
                    treeKid = model.makeNavTreeNode(this, navKid);
                }
                if (treeKid == null) continue;
                acc.add(treeKid);
            }
            for (i = 0; i < existing.length; ++i) {
                if (existing[i] == null) continue;
                model.remove(existing[i]);
            }
            this.children = acc.toArray(new NavTreeNode[acc.size()]);
            this.getModel().updateTree();
        }
        finally {
            currentNodeInRefresh.set(null);
        }
    }

    public void resetSession() {
        for (BINavNode current = (BINavNode)this.getSubject(); current != null; current = current.getNavParent()) {
            if (!(current instanceof BFoxSession)) continue;
            ((BFoxSession)current).userActivity();
            break;
        }
    }

    void remap() {
        String name = this.navNode.getNavName();
        BOrd ord = this.navNode.getNavOrd();
        if (!name.equals(this.navName) || !ord.equals((Object)this.navOrd)) {
            NavTreeModel model = (NavTreeModel)this.getModel();
            model.remap(this, this.navOrd, ord);
            this.navName = name;
            this.navOrd = ord;
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].remap();
                }
            }
        }
    }
}

