/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr.tag;

import com.tridium.workbench.shell.BFontSize;
import com.tridium.workbench.shell.BGeneralOptions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.logging.Logger;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.TagDictionary;
import javax.baja.tag.TagDictionaryService;
import javax.baja.tag.TagGroupInfo;
import javax.baja.tag.TagInfo;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.WidgetSubscriber;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.ui.treetable.TreeTableController;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.TreeTableNode;
import javax.baja.ui.util.BTitlePane;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrTagDictionary;
import javax.baja.workbench.mgr.tag.BTagFilterEnum;

@NiagaraType
@NiagaraSlots(actions={@NiagaraAction(name="updateDictionary")})
public class BTagDictionaryPane
extends BEdgePane {
    public static final Action updateDictionary = BTagDictionaryPane.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BTagDictionaryPane.class);
    public static Logger logger = Logger.getLogger("tagDictionaryPane");
    private static BIcon tagIcon = BIcon.std((String)"tag.png");
    private static BImage filterIcon = BImage.make((String)"module://icons/x16/filter.png");
    private static BImage searchIcon = BImage.make((String)"module://icons/x16/find.png");
    private static BIcon dictionaryIcon = BIcon.make((BIcon)BIcon.std((String)"book.png"), (BIcon)BIcon.std((String)"badges/tag.png"));
    private BLabel filterLabel;
    private MgrTagDictionary mgr;
    private BComponent tagEditComp;
    private BListDropDown tdChoice;
    private BTextField tagSearchEntry;
    private String tagSearch;
    private BListDropDown tagFilter;
    private BTreeTable tagTable;
    private DictionaryModel tableModel;
    private FilterSubscriber subscriber;

    public void updateDictionary() {
        this.invoke(updateDictionary, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BTagDictionaryPane() {
    }

    public BTagDictionaryPane(MgrTagDictionary mgr, BComponent tagEditComp) {
        this.mgr = mgr;
        this.tagEditComp = tagEditComp;
        BFlowPane header = new BFlowPane();
        header.add(null, (BValue)new BLabel(BImage.make((BIcon)dictionaryIcon)));
        this.tdChoice = new BListDropDown();
        this.tagSearchEntry = new BTagSearchTextField(this.mgr);
        this.tagSearchEntry.setVisibleColumns(10);
        this.tagSearch = "";
        this.tagFilter = new BListDropDown();
        this.subscriber = new FilterSubscriber((BWidget)this);
        this.subscriber.subscribe((BComponent)this.tagSearchEntry);
        this.filterLabel = new BLabel(filterIcon);
        header.add(null, (BValue)this.tdChoice);
        header.add(null, (BValue)new BLabel(searchIcon, ""));
        header.add(null, (BValue)this.tagSearchEntry);
        header.add(null, (BValue)this.filterLabel);
        header.add(null, (BValue)this.tagFilter);
        BList list = this.tagFilter.getList();
        int[] ordinals = BTagFilterEnum.DEFAULT.getRange().getOrdinals();
        for (int i = 0; i < ordinals.length; ++i) {
            list.addItem((Object)BTagFilterEnum.make(ordinals[i]));
        }
        this.tagFilter.setSelectedItem((Object)BTagFilterEnum.bestOnly);
        TagDictionaryService service = mgr.getTagDictionaryService();
        if (service != null) {
            for (TagDictionary td : service.getTagDictionaries()) {
                this.tdChoice.getList().addItem((Object)td);
            }
            if (this.tdChoice.getList().getItemCount() > 0) {
                this.tdChoice.setSelectedIndex(0);
            }
        }
        if (BGeneralOptions.make().getFontSize() == BFontSize.large) {
            this.setTop((BWidget)new BBorderPane((BWidget)header, BInsets.make((double)0.0, (double)0.0, (double)5.0, (double)0.0)));
        } else {
            this.setTop((BWidget)new BBorderPane((BWidget)header, BInsets.make((double)0.0, (double)0.0, (double)10.0, (double)0.0)));
        }
        this.tableModel = new DictionaryModel();
        this.tagTable = new BTreeTable((TreeTableModel)this.tableModel);
        this.tagTable.setController((TableController)new TagDictionaryTableController());
        BTitlePane titlePane = BTitlePane.makePane((String)this.getLexicon().get("tagDictionary.title", "Tag Dictionary"), (BTable)this.tagTable);
        if (this.tdChoice.getList().getItemCount() > 0) {
            this.tableModel.setTagDictionary((TagDictionary)this.tdChoice.getSelectedItem());
        }
        this.setCenter((BWidget)titlePane);
        this.linkTo((BComponent)this.tdChoice, (Slot)BListDropDown.valueModified, (Slot)updateDictionary);
        this.linkTo((BComponent)this.tagFilter, (Slot)BListDropDown.valueModified, (Slot)updateDictionary);
        if (mgr.getManager() != null && mgr.getManager() instanceof BAbstractManager) {
            this.linkTo((BComponent)mgr.getManager(), (Slot)BAbstractManager.handleDbSelection, (Slot)updateDictionary);
        }
        this.doUpdateDictionary();
    }

    public void setTagEditComp(BComponent tagEditComp) {
        this.tagEditComp = tagEditComp;
    }

    public BComponent getTagEditComp() {
        return this.tagEditComp;
    }

    public String getNamespace() {
        TagDictionary td = (TagDictionary)this.tdChoice.getSelectedItem();
        if (td == null) {
            return null;
        }
        return td.getNamespace();
    }

    public void setNamespace(String namespace) {
        Optional td = this.mgr.getTagDictionaryService().getTagDictionary(namespace);
        if (td.isPresent()) {
            this.tdChoice.setSelectedItem(td.get());
        }
    }

    public String getTagSearch() {
        return this.tagSearch;
    }

    public void setTagSearch(String tagSearch) {
        this.tagSearch = tagSearch;
        this.tagSearchEntry.setText(tagSearch);
        this.searchUpdate();
    }

    public BTreeTable getTable() {
        return this.tagTable;
    }

    public void doUpdateDictionary() {
        TagDictionary td = null;
        if (this.tdChoice.getList().getItemCount() > 0) {
            td = (TagDictionary)this.tdChoice.getSelectedItem();
        }
        this.tableModel.setTagDictionary(td);
        this.tableModel.updateTable(true);
    }

    public void setTagFilter(BTagFilterEnum tagFilterSel) {
        this.tagFilter.setSelectedItem((Object)tagFilterSel);
    }

    public BTagFilterEnum getTagFilter() {
        return (BTagFilterEnum)((Object)this.tagFilter.getSelectedItem());
    }

    public void setTagFilterVisible(boolean visible) {
        this.tagFilter.setVisible(visible);
        this.filterLabel.setVisible(visible);
    }

    public void setTagsRootExpanded(boolean expand) {
        Optional<TagsRoot> tagsRoot = this.tableModel.getTagsRoot();
        this.tableModel.updateTable(true);
        if (tagsRoot.isPresent()) {
            tagsRoot.get().setExpanded(expand);
        }
    }

    public void setTagGroupsRootExpanded(boolean expand) {
        Optional<TagGroupsRoot> tagGroupsRoot = this.tableModel.getTagGroupsRoot();
        this.tableModel.updateTable(true);
        if (tagGroupsRoot.isPresent()) {
            tagGroupsRoot.get().setExpanded(expand);
        }
    }

    private void searchUpdate() {
        Optional<TagsRoot> tagsRoot = this.tableModel.getTagsRoot();
        Optional<TagGroupsRoot> tagGroupsRoot = this.tableModel.getTagGroupsRoot();
        if (tagsRoot != null && tagsRoot.isPresent()) {
            TagsRoot tr = tagsRoot.get();
            tr.updateTagNodes();
            tr.setExpanded(false);
            tr.setExpanded(true);
        }
        if (tagGroupsRoot.isPresent()) {
            TagGroupsRoot gr = tagGroupsRoot.get();
            gr.updateTagGroupNodes();
            gr.setExpanded(false);
            gr.setExpanded(true);
        }
    }

    class FilterSubscriber
    extends WidgetSubscriber {
        BWidget owner;

        FilterSubscriber(BWidget owner) {
            this.owner = owner;
        }

        public void keyTyped(BKeyEvent event) {
            if (event.getWidget().equals((Object)BTagDictionaryPane.this.tagSearchEntry)) {
                BTagDictionaryPane.this.tagSearch = BTagDictionaryPane.this.tagSearchEntry.getText();
                if (BTagDictionaryPane.this.tagSearch.endsWith(":")) {
                    String dctnFilter = BTagDictionaryPane.this.tagSearch.substring(0, BTagDictionaryPane.this.tagSearch.length() - 1);
                    BList list = BTagDictionaryPane.this.tdChoice.getList();
                    for (int i = 0; i < list.getItemCount(); ++i) {
                        if (!(list.getItem(i) instanceof TagDictionary) || !((TagDictionary)list.getItem(i)).getNamespace().toLowerCase().startsWith(dctnFilter.toLowerCase())) continue;
                        BTagDictionaryPane.this.tagSearch = "";
                        list.setSelectedIndex(i);
                        BTagDictionaryPane.this.tdChoice.repaint();
                        BTagDictionaryPane.this.doUpdateDictionary();
                        BTagDictionaryPane.this.tableModel.updateTable(true);
                        break;
                    }
                    BTagDictionaryPane.this.tagSearch = "";
                    BTagDictionaryPane.this.tagSearchEntry.setText("");
                } else {
                    BTagDictionaryPane.this.searchUpdate();
                }
            }
        }
    }

    private class TagDictionaryTableController
    extends TreeTableController {
        private TagDictionaryTableController() {
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            BTagDictionaryPane.this.mgr.getManager().getController().cellDoubleClicked(this.getTreeTable(), event, row, column);
        }
    }

    private class TagGroupNode
    extends TreeTableNode {
        private TagGroupInfo tagGroup;

        public TagGroupNode(TreeTableNode parent, TagGroupInfo tagGroup) {
            super(parent);
            this.tagGroup = tagGroup;
        }

        public boolean isGroup() {
            return false;
        }

        public Object getSubject() {
            return this.tagGroup;
        }

        public Object getValueAt(int col) {
            switch (col) {
                case 0: {
                    return this.tagGroup.getGroupId().getName();
                }
                case 1: {
                    return "Tag Group";
                }
            }
            return "";
        }

        public BImage getIcon() {
            BImage icon = BImage.make((BIcon)tagIcon);
            if (BTagDictionaryPane.this.mgr.isExisting(this.tagGroup)) {
                icon = icon.getDisabledImage();
            }
            return icon;
        }
    }

    private class TagNode
    extends TreeTableNode {
        private TagInfo tag;

        public TagNode(TreeTableNode parent, TagInfo tag) {
            super(parent);
            this.tag = tag;
        }

        public boolean isGroup() {
            return false;
        }

        public Object getSubject() {
            return this.tag;
        }

        public Object getValueAt(int col) {
            switch (col) {
                case 0: {
                    return this.tag.getTagId().getName();
                }
                case 1: {
                    return this.tag.getTagType().getTypeName();
                }
            }
            return "";
        }

        public BImage getIcon() {
            BImage icon = BImage.make((BIcon)tagIcon);
            if (BTagDictionaryPane.this.mgr.isExisting(this.tag)) {
                icon = icon.getDisabledImage();
            }
            return icon;
        }
    }

    private class TagGroupsRoot
    extends TreeTableNode
    implements DictionaryRoot {
        private ArrayList<TreeTableNode> tagGroups;
        private ArrayList<TagGroupInfo> tagGroupInfos;

        public TagGroupsRoot(TreeTableModel model) {
            super(model);
        }

        @Override
        public void updateDictionary(TagDictionary dictionary) {
            this.tagGroups = null;
        }

        public boolean isGroup() {
            return true;
        }

        public Object getValueAt(int column) {
            if (column == 0) {
                return BTagDictionaryPane.this.getLexicon().get("tagGroup.objects", "Tag Groups");
            }
            return "";
        }

        public int getChildCount() {
            this.reload();
            if (this.tagGroups == null) {
                return 0;
            }
            return this.tagGroups.size();
        }

        public TreeTableNode getChild(int index) {
            this.reload();
            return this.tagGroups.get(index);
        }

        public void reload() {
            if (this.tagGroups != null) {
                return;
            }
            this.tagGroupInfos = new ArrayList();
            Type baseType = BTagDictionaryPane.this.mgr.getManager().getModel().getBaseNewType();
            if (baseType == null) {
                return;
            }
            int filterSelect = ((BTagFilterEnum)((Object)BTagDictionaryPane.this.tagFilter.getSelectedItem())).getOrdinal();
            Entity[] prototypes = BTagDictionaryPane.this.mgr.getNewEntityPrototypes();
            TagDictionary td = ((DictionaryModel)this.getModel()).getDictionary();
            if (td != null) {
                Iterator i = td.getTagGroups();
                block5: while (i.hasNext()) {
                    TagGroupInfo tagGroupInfo = (TagGroupInfo)i.next();
                    block0 : switch (filterSelect) {
                        case 2: {
                            if ((prototypes.length != 0 || !tagGroupInfo.isIdealFor(baseType)) && (prototypes.length <= 0 || !tagGroupInfo.isIdealFor(baseType) || !tagGroupInfo.isValidFor(prototypes[0]))) break;
                            this.tagGroupInfos.add(tagGroupInfo);
                            break;
                        }
                        case 0: {
                            this.tagGroupInfos.add(tagGroupInfo);
                            break;
                        }
                        case 1: {
                            if (prototypes == null || prototypes.length == 0 && BTagDictionaryPane.this.tagEditComp != null) {
                                prototypes = new Entity[]{BTagDictionaryPane.this.tagEditComp};
                            }
                            for (int e = 0; e < prototypes.length; ++e) {
                                if (!tagGroupInfo.isValidFor(prototypes[e])) continue;
                                this.tagGroupInfos.add(tagGroupInfo);
                                break block0;
                            }
                            continue block5;
                        }
                    }
                }
                this.updateTagGroupNodes();
                if (baseType.getTypeName().contains("ControlPoint")) {
                    Optional<TagGroupsRoot> groupsRoot = BTagDictionaryPane.this.tableModel.getTagGroupsRoot();
                    BTagDictionaryPane.this.tableModel.updateTable(true);
                    if (groupsRoot.isPresent()) {
                        groupsRoot.get().setExpanded(true);
                    }
                }
            }
        }

        protected void updateTagGroupNodes() {
            if (this.tagGroupInfos == null) {
                return;
            }
            this.tagGroups = new ArrayList();
            for (TagGroupInfo tag : this.tagGroupInfos) {
                if (BTagDictionaryPane.this.tagSearch != null && BTagDictionaryPane.this.tagSearch.length() != 0 && !tag.getName().startsWith(BTagDictionaryPane.this.tagSearch)) continue;
                this.tagGroups.add(new TagGroupNode(this, tag));
            }
        }

        public BImage getIcon() {
            return BImage.make((BIcon)tagIcon);
        }
    }

    private class TagsRoot
    extends TreeTableNode
    implements DictionaryRoot {
        private ArrayList<TreeTableNode> tags;
        private ArrayList<TagInfo> tagInfos;

        public TagsRoot(TreeTableModel model) {
            super(model);
        }

        @Override
        public void updateDictionary(TagDictionary dictionary) {
            this.tags = null;
        }

        public boolean isGroup() {
            return true;
        }

        public Object getValueAt(int column) {
            if (column == 0) {
                return BTagDictionaryPane.this.getLexicon().get("tag.objects", "Tags");
            }
            return "";
        }

        public int getChildCount() {
            this.reload();
            if (this.tags == null) {
                return 0;
            }
            return this.tags.size();
        }

        public TreeTableNode getChild(int index) {
            this.reload();
            return this.tags.get(index);
        }

        public void reload() {
            if (this.tags != null) {
                return;
            }
            this.tagInfos = new ArrayList();
            Type baseType = BTagDictionaryPane.this.mgr.getManager().getModel().getBaseNewType();
            if (baseType == null) {
                logger.warning(BTagDictionaryPane.this.mgr.getManager().getModel().getClass().getTypeName() + "does not implement getBaseNewType() method");
                return;
            }
            int filterSelect = ((BTagFilterEnum)((Object)BTagDictionaryPane.this.tagFilter.getSelectedItem())).getOrdinal();
            Entity[] prototypes = BTagDictionaryPane.this.mgr.getNewEntityPrototypes();
            TagDictionary td = ((DictionaryModel)this.getModel()).getDictionary();
            if (td != null) {
                Iterator i = td.getTags();
                block5: while (i.hasNext()) {
                    TagInfo tagInfo = (TagInfo)i.next();
                    block0 : switch (filterSelect) {
                        case 2: {
                            if (!tagInfo.isIdealFor(baseType)) break;
                            this.tagInfos.add(tagInfo);
                            break;
                        }
                        case 0: {
                            this.tagInfos.add(tagInfo);
                            break;
                        }
                        case 1: {
                            if (prototypes == null || prototypes.length == 0 && BTagDictionaryPane.this.tagEditComp != null) {
                                prototypes = new Entity[]{BTagDictionaryPane.this.tagEditComp};
                            }
                            for (int e = 0; e < prototypes.length; ++e) {
                                if (!tagInfo.isValidFor(prototypes[e])) continue;
                                this.tagInfos.add(tagInfo);
                                break block0;
                            }
                            continue block5;
                        }
                    }
                }
                this.updateTagNodes();
            }
            if (baseType.getTypeName().contains("Device")) {
                Optional<TagsRoot> tagsRoot = BTagDictionaryPane.this.tableModel.getTagsRoot();
                BTagDictionaryPane.this.tableModel.updateTable(true);
                if (tagsRoot.isPresent()) {
                    tagsRoot.get().setExpanded(true);
                }
            }
        }

        protected void updateTagNodes() {
            this.getTable().getSelection().deselectAll();
            this.tags = new ArrayList();
            for (TagInfo tag : this.tagInfos) {
                boolean checkExactMatch = BTagDictionaryPane.this.tagSearch.length() > 2 && BTagDictionaryPane.this.tagSearch.endsWith(" ");
                boolean searchMatch = false;
                searchMatch = checkExactMatch ? tag.getName().equals(BTagDictionaryPane.this.tagSearch.trim()) : tag.getName().startsWith(BTagDictionaryPane.this.tagSearch);
                if (BTagDictionaryPane.this.tagSearch != null && BTagDictionaryPane.this.tagSearch.length() != 0 && !searchMatch) continue;
                this.tags.add(new TagNode(this, tag));
            }
            if (this.tags.size() == 1) {
                this.getTable().getSelection().select(1);
            }
        }

        public BImage getIcon() {
            return BImage.make((BIcon)tagIcon);
        }
    }

    private static interface DictionaryRoot {
        public void updateDictionary(TagDictionary var1);
    }

    private class DictionaryModel
    extends TreeTableModel {
        private TagDictionary dictionary;
        private ArrayList<TreeTableNode> roots = new ArrayList(2);

        public DictionaryModel() {
            this.roots.add(new TagsRoot(this));
            this.roots.add(new TagGroupsRoot(this));
        }

        public void setTagDictionary(TagDictionary dictionary) {
            boolean wasNull = this.dictionary == null;
            this.dictionary = dictionary;
            for (TreeTableNode root : this.roots) {
                if (!(root instanceof DictionaryRoot)) continue;
                ((DictionaryRoot)root).updateDictionary(dictionary);
            }
            this.updateTreeTable(wasNull);
        }

        public TagDictionary getDictionary() {
            return this.dictionary;
        }

        public int getRootCount() {
            return this.roots.size();
        }

        public Optional<TagsRoot> getTagsRoot() {
            for (TreeTableNode root : this.roots) {
                if (!(root instanceof TagsRoot)) continue;
                return Optional.of((TagsRoot)root);
            }
            return Optional.empty();
        }

        public Optional<TagGroupsRoot> getTagGroupsRoot() {
            for (TreeTableNode root : this.roots) {
                if (!(root instanceof TagGroupsRoot)) continue;
                return Optional.of((TagGroupsRoot)root);
            }
            return Optional.empty();
        }

        public TreeTableNode getRoot(int index) {
            return this.roots.get(index);
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int index) {
            switch (index) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Type";
                }
            }
            return "Default-" + index;
        }
    }

    private static class BTagSearchTextField
    extends BTextField {
        private MgrTagDictionary mgr;

        BTagSearchTextField(MgrTagDictionary mgr) {
            this.mgr = mgr;
        }

        public void focusGained(BFocusEvent event) {
            super.focusGained(event);
            this.mgr.getManager().getController().setQuickCommandsEnabled(false);
        }

        public void focusLost(BFocusEvent event) {
            super.focusLost(event);
            this.mgr.getManager().getController().setQuickCommandsEnabled(true);
        }
    }
}

