/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BImage;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.SimpleDragRenderer;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.ui.treetable.DynamicTreeTableModel;
import javax.baja.ui.treetable.TreeTableCellRenderer;
import javax.baja.ui.treetable.TreeTableController;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.TreeTableNode;
import javax.baja.ui.treetable.TreeTableSelection;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrTemplate;

public class BTemplateTable
extends BTreeTable {
    public static final Type TYPE = Sys.loadType(BTemplateTable.class);
    BAbstractManager manager;
    MgrColumn[] cols;
    MgrTemplate mgrTemplate;
    DynamicTreeTableModel dynamicModel;
    TemplateTreeModel treeTableModel;

    public Type getType() {
        return TYPE;
    }

    public BTemplateTable() {
        throw new IllegalStateException();
    }

    public BTemplateTable(MgrTemplate template) {
        this.manager = template.getManager();
        this.mgrTemplate = template;
        this.treeTableModel = new TemplateTreeModel();
        this.dynamicModel = new DynamicTreeTableModel((TreeTableModel)this.treeTableModel);
        this.updateColumns();
        this.setModel((TableModel)this.dynamicModel);
        this.setSelection((TableSelection)new Selection());
        this.setController((TableController)new Controller());
        this.setCellRenderer((TableCellRenderer)new Renderer());
        this.setMultipleSelection(false);
    }

    public BAbstractManager getManager() {
        return this.manager;
    }

    public MgrColumn columnIndexToMgrColumn(int column) {
        return this.mgrTemplate.cols[this.dynamicModel.toRootColumnIndex(column)];
    }

    public Object getObjectAt(int row) {
        TemplateTableNode node = (TemplateTableNode)this.treeTableModel.rowToNode(row);
        if (node != null) {
            return node.template;
        }
        return null;
    }

    public Object getSelectedObject() {
        int sel = this.getSelection().getRow();
        if (sel < 0) {
            return null;
        }
        return this.getObjectAt(sel);
    }

    public Object[] getSelectedObjects() {
        int[] sel = this.getSelection().getRows();
        Object[] obj = new Object[sel.length];
        for (int i = 0; i < sel.length; ++i) {
            obj[i] = this.getObjectAt(sel[i]);
        }
        return obj;
    }

    public void mouseDragStarted(BMouseEvent event) {
        int[] rows = this.getSelection().getRows();
        if (rows.length == 0) {
            return;
        }
        int rowY = this.getRowAt(event.getY());
        boolean found = false;
        for (int i = 0; i < rows.length; ++i) {
            if (rowY != rows[i]) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        BImage[] icons = new BImage[rows.length];
        String[] text = new String[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            int row = rows[i];
            TemplateTableNode node = (TemplateTableNode)this.treeTableModel.rowToNode(row);
            icons[i] = node.getIcon();
            text[i] = "" + node.getValueAt(0);
        }
        SimpleDragRenderer dragRenderer = new SimpleDragRenderer(icons, text);
        dragRenderer.font = Theme.table().getCellFont();
        String payload = "dragFromTemplate:" + this.getManager().hashCode();
        this.startDrag(event, TransferEnvelope.make((String)payload), (DragRenderer)dragRenderer);
    }

    void updateColumns() {
        this.cols = this.mgrTemplate.getColumns();
        for (int i = 0; i < this.cols.length; ++i) {
            this.dynamicModel.setShowColumn(i, !this.cols[i].isUnseen());
        }
    }

    void resetIcons() {
        TemplateTableNode[] roots = this.treeTableModel.roots;
        for (int i = 0; i < roots.length; ++i) {
            this.resetIcons(roots[i]);
        }
        this.repaint();
    }

    void resetIcons(TemplateTableNode node) {
        node.icon = null;
        if (node.children != null) {
            for (int i = 0; i < node.children.length; ++i) {
                this.resetIcons(node.children[i]);
            }
        }
    }

    static TemplateTableNode[] sort(TemplateTableNode[] roots, int col, boolean ascending) {
        TemplateTableNode[] sorted = (TemplateTableNode[])roots.clone();
        Object[] keys = new Object[sorted.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = sorted[i].getValueAt(col);
        }
        SortUtil.sort((Object[])keys, (Object[])sorted, (boolean)ascending);
        return sorted;
    }

    class TemplateTableNode
    extends TreeTableNode {
        Object template;
        TemplateTableNode[] children;
        BImage icon;

        TemplateTableNode(TemplateTreeModel model, Object discovery) {
            super((TreeTableModel)model);
            this.template = discovery;
        }

        TemplateTableNode(TemplateTableNode parent, Object discovery) {
            super((TreeTableNode)parent);
            this.template = discovery;
        }

        public Object getSubject() {
            return this.template;
        }

        public boolean isGroup() {
            return BTemplateTable.this.mgrTemplate.isGroup(this.template);
        }

        public boolean hasChildren() {
            return BTemplateTable.this.mgrTemplate.hasChildren(this.template);
        }

        public int getChildCount() {
            return this.getChildren().length;
        }

        public TreeTableNode getChild(int index) {
            return this.getChildren()[index];
        }

        TreeTableNode[] getChildren() {
            if (this.children == null) {
                Object[] kidDis = BTemplateTable.this.mgrTemplate.getChildren(this.template);
                TemplateTableNode[] kidNodes = new TemplateTableNode[kidDis.length];
                for (int i = 0; i < kidNodes.length; ++i) {
                    kidNodes[i] = new TemplateTableNode(this, kidDis[i]);
                }
                this.children = kidNodes;
            }
            return this.children;
        }

        public Object getValueAt(int col) {
            return BTemplateTable.this.cols[col].get(this.template);
        }

        public BImage getIcon() {
            if (this.icon == null) {
                this.icon = BTemplateTable.this.mgrTemplate.getIcon(this.template);
            }
            return this.icon;
        }
    }

    class Renderer
    extends TreeTableCellRenderer {
        Renderer() {
        }

        public String getCellText(TableCellRenderer.Cell cell) {
            try {
                Object obj = BTemplateTable.this.getObjectAt(cell.row);
                MgrColumn col = BTemplateTable.this.columnIndexToMgrColumn(cell.column);
                return col.toDisplayString(obj, cell.value, BTemplateTable.this.manager.getCurrentContext());
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }
    }

    class TemplateTreeModel
    extends TreeTableModel {
        TemplateTableNode[] roots = new TemplateTableNode[0];

        TemplateTreeModel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateTreeTable(boolean resize) {
            BWbShell shell = BTemplateTable.this.getManager().getWbShell();
            if (shell == null) {
                return;
            }
            shell.enterBusy();
            try {
                Object[] tmpls = BTemplateTable.this.mgrTemplate.getRoots();
                TemplateTableNode[] roots = new TemplateTableNode[tmpls.length];
                for (int i = 0; i < roots.length; ++i) {
                    TemplateTableNode root = this.discoveryToRoot(tmpls[i]);
                    if (root == null) {
                        root = new TemplateTableNode(this, tmpls[i]);
                    }
                    roots[i] = root;
                }
                int sortCol = BTemplateTable.this.dynamicModel.toRootColumnIndex(BTemplateTable.this.getSortColumn());
                if (sortCol >= 0) {
                    roots = BTemplateTable.sort(roots, sortCol, BTemplateTable.this.isSortAscending());
                }
                this.roots = roots;
                super.updateTreeTable(resize);
            }
            finally {
                shell.exitBusy();
            }
        }

        public int getRootCount() {
            return this.roots.length;
        }

        public TreeTableNode getRoot(int index) {
            return this.roots[index];
        }

        public boolean isDepthExpandable(int depth) {
            return BTemplateTable.this.mgrTemplate.isDepthExpandable(depth);
        }

        public int getColumnCount() {
            return BTemplateTable.this.cols.length;
        }

        public String getColumnName(int col) {
            return BTemplateTable.this.mgrTemplate.cols[col].getDisplayName();
        }

        public boolean isColumnSortable(int col) {
            return true;
        }

        public void sortByColumn(int col, boolean ascending) {
            this.getSelection().deselectAll();
            this.roots = BTemplateTable.sort(this.roots, col, ascending);
            super.updateTreeTable(false);
        }

        TemplateTableNode discoveryToRoot(Object discovery) {
            TemplateTableNode[] roots = this.roots;
            for (int i = 0; i < roots.length; ++i) {
                if (roots[i].template != discovery) continue;
                return roots[i];
            }
            return null;
        }
    }

    class Controller
    extends TreeTableController {
        Controller() {
        }

        public void cellDoubleClicked(BMouseEvent event, int row, int col) {
            BTemplateTable.this.getManager().getController().cellDoubleClicked(BTemplateTable.this, event, row, col);
        }

        public BMenu makeOptionsMenu() {
            BMenu menu = super.makeOptionsMenu();
            return BTemplateTable.this.getManager().getController().makeOptionsMenu(BTemplateTable.this, menu);
        }

        protected void headerPopup(BMouseEvent event, int column) {
            BTemplateTable.this.getManager().getController().headerPopup(BTemplateTable.this, event, column);
        }
    }

    class Selection
    extends TreeTableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            BTemplateTable.this.manager.getController().updateCommands();
        }
    }
}

