/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import com.tridium.ui.UiEnv;
import com.tridium.ui.awt.AwtShellManager;
import com.tridium.ui.theme.Theme;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.baja.gx.BInsets;
import javax.baja.gx.IRectGeom;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;

public class BMgrEditDialog
extends BDialog {
    public static final Action editorModified = BMgrEditDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType(BMgrEditDialog.class);
    public static int MAX_DIALOG_WIDTH = 750;
    public static final int MAX_DIALOG_HEIGHT = 750;
    Lexicon lex = Lexicon.make(BMgrEditDialog.class);
    String lexCannotEdit = this.lex.getText("mgr.cannotEdit");
    BAbstractManager manager;
    Command ok;
    Command cancel;
    MgrEdit edit;
    BTable table;
    BGridPane inputPane;
    ColumnInput[] inputs;
    MgrEditRow[] oldSelection;
    int result;

    public void editorModified(BWidgetEvent event) {
        this.invoke(editorModified, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMgrEditDialog() {
        throw new IllegalStateException();
    }

    public BMgrEditDialog(MgrEdit edit, boolean selectAll) throws Exception {
        this(edit, selectAll, edit.new MgrEdit.TagTableCellRenderer());
    }

    public BMgrEditDialog(MgrEdit edit, boolean selectAll, MgrEdit.TagTableCellRenderer cellRenderer) throws Exception {
        super((BWidget)edit.getManager(), edit.getTitle(), true);
        this.manager = edit.manager;
        this.edit = edit;
        this.table = new BTable((TableModel)edit, (TableController)new Controller());
        this.table.setSelection((TableSelection)new Selection());
        this.table.setCellRenderer((TableCellRenderer)cellRenderer);
        this.makeInputPane();
        this.ok = new Ok((BWidget)this);
        this.cancel = new Cancel((BWidget)this);
        BGridPane actions = new BGridPane();
        actions.setColumnAlign(BHalign.fill);
        actions.setUniformColumnWidth(true);
        actions.add(null, (BValue)new BButton(this.ok));
        actions.add(null, (BValue)new BButton(this.cancel));
        BTabbedPane tabbedPane = new BTabbedPane();
        BEdgePane pane = new BEdgePane();
        pane.setTop((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.make((double)5.0, (double)5.0, (double)5.0, (double)5.0)));
        BScrollPane inputScrollPane = new BScrollPane((BWidget)this.inputPane);
        tabbedPane.addPane("Properties", (BWidget)new BBorderPane((BWidget)inputScrollPane, BBorder.inset, BInsets.make((double)0.0, (double)5.0, (double)5.0, (double)5.0)));
        tabbedPane.setShowSingleTab(false);
        pane.setCenter((BWidget)tabbedPane);
        BScrollPane scrollPane = new BScrollPane((BWidget)pane);
        scrollPane.setViewportBackground(Theme.widget().getControlBackground());
        BEdgePane content = new BEdgePane();
        content.setCenter((BWidget)new BBorderPane((BWidget)scrollPane));
        content.setBottom((BWidget)new BBorderPane((BWidget)actions, 0.0, 10.0, 10.0, 10.0));
        this.setContent((BWidget)content);
        this.setupKeyEvents();
        if (selectAll) {
            this.table.getSelection().selectAll();
        }
    }

    public BAbstractManager getManager() {
        return this.manager;
    }

    public MgrEdit getEdit() {
        return this.edit;
    }

    public int getResult() {
        return this.result;
    }

    public MgrEditRow[] getSelectedRows() {
        int[] sel = this.table.getSelection().getRows();
        MgrEditRow[] rows = new MgrEditRow[sel.length];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = this.edit.getRow(sel[i]);
        }
        return rows;
    }

    private void makeInputPane() throws Exception {
        int i;
        MgrEditRow[] rows = new MgrEditRow[]{this.edit.getRow(0)};
        MgrColumn[] cols = this.edit.getColumns();
        this.inputs = new ColumnInput[cols.length];
        for (i = 0; i < this.inputs.length; ++i) {
            this.inputs[i] = new ColumnInput(cols[i], i);
        }
        this.inputPane = new BGridPane(2);
        this.inputPane.setColumnGap(10.0);
        this.inputPane.setHalign(BHalign.left);
        this.inputPane.setValign(BValign.top);
        for (i = 0; i < this.inputs.length; ++i) {
            ColumnInput input = this.inputs[i];
            input.installLabel();
            try {
                input.installEditor(cols[i].toEditor(rows, i, null), rows);
                continue;
            }
            catch (Exception e) {
                input.installEditor(null, rows);
            }
        }
    }

    public boolean syncInputPane() {
        MgrEditRow[] newSelection = this.getSelectedRows();
        this.removeDuplicates(newSelection);
        try {
            this.saveInputPane(this.oldSelection);
        }
        catch (Throwable e) {
            e.printStackTrace();
            if (this.isShowing()) {
                BDialog.error((BWidget)this, (String)BDialog.TITLE_ERROR, (Object)"Cannot save to table", (Throwable)e);
            }
            return false;
        }
        try {
            this.loadInputPane(newSelection);
        }
        catch (Throwable e) {
            e.printStackTrace();
            if (this.isShowing()) {
                BDialog.error((BWidget)this, (String)"Cannot load from table", (Object)e);
            }
            return false;
        }
        this.oldSelection = newSelection;
        this.table.repaint();
        return true;
    }

    private void removeDuplicates(MgrEditRow[] toRemove) {
        if (this.oldSelection != null) {
            ArrayList<MgrEditRow> returnList = new ArrayList<MgrEditRow>();
            List<MgrEditRow> toRemoveList = Arrays.asList(toRemove);
            for (MgrEditRow row : this.oldSelection) {
                if (toRemoveList.contains(row)) continue;
                returnList.add(row);
            }
            if (returnList.size() != 0 || this.oldSelection.length != toRemove.length) {
                this.oldSelection = returnList.toArray(new MgrEditRow[returnList.size()]);
            }
        }
    }

    protected void loadInputPane(MgrEditRow[] selection) throws Exception {
        for (ColumnInput input : this.inputs) {
            input.load(selection);
        }
    }

    protected void saveInputPane(MgrEditRow[] selection) throws Exception {
        if (selection == null || selection.length == 0) {
            return;
        }
        for (ColumnInput input : this.inputs) {
            input.save(selection);
        }
        this.edit.validate(selection);
    }

    private void copy(BComponent from, BComponent to) {
        for (Property prop : from.getProperties()) {
            String propName;
            int flags = from.getFlags((Slot)prop);
            if ((flags & 5) != 0 || to.get(propName = prop.getName()).equivalent((Object)from.get(prop))) continue;
            to.set(propName, from.get(prop).newCopy(true));
        }
    }

    public void doEditorModified(BWidgetEvent event) {
        String name = event.getWidget().getName();
        int index = Integer.parseInt(name.substring("editor".length()));
        this.inputs[index].modified(this.getSelectedRows());
    }

    void typeChanged() throws Exception {
        MgrEditRow[] selection = this.getSelectedRows();
        for (ColumnInput input : this.inputs) {
            if (input.col instanceof MgrColumn.Type) continue;
            input.load(selection);
        }
    }

    public boolean checkNames() {
        MgrEditRow[] rows = this.edit.getRows();
        for (int i = 0; i < rows.length; ++i) {
            String name = rows[i].getName();
            if (name == null || this.edit.isNameUnique(rows[i], name)) continue;
            String msg = this.lex.getText("mgr.duplicateName", new Object[]{name});
            BDialog.error((BWidget)this, (Object)msg);
            return false;
        }
        return true;
    }

    public void computePreferredSize() {
        super.computePreferredSize();
        double pw = this.getPreferredWidth() + 20.0;
        double ph = this.getPreferredHeight() + 20.0;
        IRectGeom screen = UiEnv.get().getScreenBounds((BWidget)this);
        double sw = screen.width() - 50.0;
        double sh = screen.height() - 50.0;
        if (pw > sw) {
            pw = sw;
        }
        if (ph > sh) {
            ph = sh;
        }
        if (pw > (double)MAX_DIALOG_WIDTH) {
            pw = MAX_DIALOG_WIDTH;
        }
        if (ph > 750.0) {
            ph = 750.0;
        }
        this.setPreferredSize(pw, ph);
    }

    public void handleEnter() {
        this.syncInputPane();
    }

    static boolean hasSelectionChanged(int[] a, int[] b) {
        if (a.length != b.length) {
            return true;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return true;
        }
        return false;
    }

    private void setupKeyEvents() {
        AwtShellManager manager = (AwtShellManager)this.widgetSupport(null);
        manager.addKeyListener((java.awt.event.KeyListener)new KeyListener());
    }

    void updateTableSelection(KeyEvent event, int code) {
        BKeyEvent e = new BKeyEvent(401, (BWidget)this.table, event.getModifiers(), code, event.getKeyChar());
        this.table.getController().keyPressed(e);
        BWidget focus = this.getCurrentFocus();
        if (focus instanceof BTextField) {
            ((BTextField)focus).getSelection().selectAll();
        }
    }

    public void windowClosing(BWindowEvent event) {
        super.windowClosing(event);
        this.cancel.invoke();
    }

    class Cancel
    extends Command {
        Cancel(BWidget owner) {
            super(owner, UiLexicon.bajaui().getText("dialog.cancel"));
        }

        public CommandArtifact doInvoke() {
            BMgrEditDialog.this.result = 2;
            BMgrEditDialog.this.close();
            return null;
        }
    }

    class Ok
    extends Command {
        Ok(BWidget owner) {
            super(owner, UiLexicon.bajaui().getText("dialog.ok"));
        }

        public CommandArtifact doInvoke() {
            if (!BMgrEditDialog.this.syncInputPane()) {
                return null;
            }
            if (!BMgrEditDialog.this.checkNames()) {
                return null;
            }
            try {
                BMgrEditDialog.this.edit.validate(BMgrEditDialog.this.edit.getRows());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (BMgrEditDialog.this.isShowing()) {
                    BDialog.error((BWidget)BMgrEditDialog.this, (String)BDialog.TITLE_ERROR, (Object)"Cannot save all rows to table", (Throwable)e);
                }
                return null;
            }
            BMgrEditDialog.this.result = 1;
            BMgrEditDialog.this.close();
            return null;
        }
    }

    class KeyListener
    implements java.awt.event.KeyListener {
        KeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (BMgrEditDialog.this.getCurrentFocus() == BMgrEditDialog.this.table) {
                return;
            }
            if (event.isConsumed()) {
                return;
            }
            int code = event.getKeyCode();
            switch (code) {
                case 33: 
                case 34: 
                case 38: 
                case 40: {
                    BMgrEditDialog.this.updateTableSelection(event, code);
                    break;
                }
                case 10: {
                    if (BMgrEditDialog.this.getSelectedRows().length > 1) break;
                    if (event.isControlDown()) {
                        BMgrEditDialog.this.ok.invoke();
                        break;
                    }
                    BMgrEditDialog.this.updateTableSelection(event, 40);
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }
    }

    class Selection
    extends TableSelection {
        int[] oldSel = new int[0];

        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            int[] curSel = this.getRows();
            if (BMgrEditDialog.hasSelectionChanged(curSel, this.oldSel)) {
                int[] saveOldSel = (int[])this.oldSel.clone();
                this.oldSel = curSel;
                if (!BMgrEditDialog.this.syncInputPane()) {
                    this.oldSel = saveOldSel;
                    this.select(saveOldSel);
                }
            }
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }
    }

    class ColumnInput {
        MgrColumn col;
        int colIndex;
        String labelKey;
        String editorKey;
        BLabel label;
        BWbEditor editor;
        BLink linkFromEditor;

        ColumnInput(MgrColumn col, int colIndex) {
            this.col = col;
            this.colIndex = colIndex;
            this.labelKey = "label" + colIndex;
            this.editorKey = "editor" + colIndex;
            this.label = new BLabel(col.getIcon(), col.getDisplayName());
            this.label.setFont(Theme.widget().getBoldText());
        }

        void installLabel() {
            BMgrEditDialog.this.inputPane.add(this.labelKey, (BValue)this.label);
        }

        void installEditor(BWbEditor editor, MgrEditRow[] selectedRows) {
            Property editorProp;
            BWbEditor widget;
            BWbEditor oldEditor = this.editor;
            this.editor = editor;
            if (editor == null || !this.col.isCellValid(selectedRows[0])) {
                this.label.setImage(this.col.getIcon().getDisabledImage());
                this.label.setEnabled(false);
                if (editor != null) {
                    editor.setEnabled(false);
                }
            } else {
                this.label.setImage(this.col.getIcon());
                this.label.setEnabled(true);
                if (editor != null) {
                    editor.setEnabled(true);
                }
            }
            this.label.repaint();
            if (editor != null) {
                widget = editor;
                editor.setReadonly(BMgrEditDialog.this.edit.isReadonly(selectedRows, this.col));
            } else if (oldEditor != null) {
                widget = oldEditor;
                oldEditor.setReadonly(true);
            } else {
                widget = !this.col.isCellValid(selectedRows[0]) ? new BLabel("") : new BLabel(BMgrEditDialog.this.lexCannotEdit);
            }
            if (this.linkFromEditor != null) {
                BMgrEditDialog.this.remove((BComplex)this.linkFromEditor);
            }
            if (editor != null) {
                BMgrEditDialog.this.linkTo((BComponent)editor, (Slot)BWbEditor.pluginModified, (Slot)editorModified);
            }
            if ((editorProp = BMgrEditDialog.this.inputPane.getProperty(this.editorKey)) == null) {
                BMgrEditDialog.this.inputPane.add(this.editorKey, (BValue)widget);
            } else if (BMgrEditDialog.this.inputPane.get(editorProp) != widget) {
                BMgrEditDialog.this.inputPane.set(editorProp, (BValue)widget);
            }
        }

        void load(MgrEditRow[] selection) throws Exception {
            if (selection == null || selection.length == 0) {
                this.installEditor(null, new MgrEditRow[0]);
            } else {
                try {
                    this.installEditor(this.col.toEditor(selection, this.colIndex, this.editor), selection);
                }
                catch (Exception e) {
                    this.installEditor(null, selection);
                }
            }
        }

        void save(MgrEditRow[] selection) throws Exception {
            if (this.editor != null && this.editor.isModified()) {
                this.col.fromEditor(selection, this.colIndex, this.editor);
                if (this.col instanceof MgrColumn.Type) {
                    BMgrEditDialog.this.typeChanged();
                }
            }
        }

        void modified(MgrEditRow[] selection) {
            BLabel label = (BLabel)BMgrEditDialog.this.inputPane.get(this.labelKey);
            try {
                if (selection != null && selection.length > 0) {
                    this.save(selection);
                    label.setImage(this.col.getIcon());
                    BMgrEditDialog.this.repaint();
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            label.setImage(this.col.getIcon().getHighlightedImage());
            label.repaint();
        }
    }
}

