/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BImage;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.SimpleDragRenderer;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.ui.treetable.DynamicTreeTableModel;
import javax.baja.ui.treetable.TreeTableCellRenderer;
import javax.baja.ui.treetable.TreeTableController;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.TreeTableNode;
import javax.baja.ui.treetable.TreeTableSelection;
import javax.baja.ui.treetable.TreeTableSubject;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrLearn;

public class BLearnTable
extends BTreeTable {
    public static final Type TYPE = Sys.loadType(BLearnTable.class);
    BAbstractManager manager;
    MgrColumn[] cols;
    MgrLearn learn;
    DynamicTreeTableModel dynamicModel;
    Model treeTableModel;

    public Type getType() {
        return TYPE;
    }

    public BLearnTable() {
        throw new IllegalStateException();
    }

    public BLearnTable(MgrLearn learn) {
        this.manager = learn.getManager();
        this.learn = learn;
        this.treeTableModel = new Model();
        this.dynamicModel = new DynamicTreeTableModel((TreeTableModel)this.treeTableModel);
        this.updateColumns();
        this.setModel((TableModel)this.dynamicModel);
        this.setSelection((TableSelection)new Selection());
        this.setController((TableController)new Controller());
        this.setCellRenderer((TableCellRenderer)new Renderer());
    }

    public BAbstractManager getManager() {
        return this.manager;
    }

    public MgrColumn columnIndexToMgrColumn(int column) {
        return this.learn.cols[this.dynamicModel.toRootColumnIndex(column)];
    }

    public Object getObjectAt(int row) {
        Node node = (Node)this.treeTableModel.rowToNode(row);
        if (node != null) {
            return node.discovery;
        }
        return null;
    }

    public Object getSelectedObject() {
        int sel = this.getSelection().getRow();
        if (sel < 0) {
            return null;
        }
        return this.getObjectAt(sel);
    }

    public Object[] getSelectedObjects() {
        int[] sel = this.getSelection().getRows();
        Object[] obj = new Object[sel.length];
        for (int i = 0; i < sel.length; ++i) {
            obj[i] = this.getObjectAt(sel[i]);
        }
        return obj;
    }

    public void mouseDragStarted(BMouseEvent event) {
        int[] rows = this.getSelection().getRows();
        if (rows.length == 0) {
            return;
        }
        int rowY = this.getRowAt(event.getY());
        boolean found = false;
        for (int i = 0; i < rows.length; ++i) {
            if (rowY != rows[i]) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        BImage[] icons = new BImage[rows.length];
        String[] text = new String[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            int row = rows[i];
            Node node = (Node)this.treeTableModel.rowToNode(row);
            icons[i] = node.getIcon();
            text[i] = "" + node.getValueAt(0);
        }
        SimpleDragRenderer dragRenderer = new SimpleDragRenderer(icons, text);
        dragRenderer.font = Theme.table().getCellFont();
        String payload = "dragFromLearn:" + this.getManager().hashCode();
        this.startDrag(event, TransferEnvelope.make((String)payload), (DragRenderer)dragRenderer);
    }

    void updateColumns() {
        this.cols = this.learn.getColumns();
        for (int i = 0; i < this.cols.length; ++i) {
            this.dynamicModel.setShowColumn(i, !this.cols[i].isUnseen());
        }
    }

    void resetIcons() {
        Node[] roots = this.treeTableModel.roots;
        for (int i = 0; i < roots.length; ++i) {
            this.resetIcons(roots[i]);
        }
        this.repaint();
    }

    void resetIcons(Node node) {
        node.icon = null;
        if (node.children != null) {
            for (int i = 0; i < node.children.length; ++i) {
                this.resetIcons(node.children[i]);
            }
        }
    }

    static Node[] sort(Node[] roots, int col, boolean ascending) {
        Node[] sorted = (Node[])roots.clone();
        Object[] keys = new Object[sorted.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = sorted[i].getValueAt(col);
        }
        SortUtil.sort((Object[])keys, (Object[])sorted, (boolean)ascending);
        return sorted;
    }

    class Node
    extends TreeTableNode {
        Object discovery;
        Node[] children;
        BImage icon;

        Node(Model model, Object discovery) {
            super((TreeTableModel)model);
            this.discovery = discovery;
        }

        Node(Node parent, Object discovery) {
            super((TreeTableNode)parent);
            this.discovery = discovery;
        }

        public Object getSubject() {
            return this.discovery;
        }

        public boolean isGroup() {
            return BLearnTable.this.learn.isGroup(this.discovery);
        }

        public boolean hasChildren() {
            return BLearnTable.this.learn.hasChildren(this.discovery);
        }

        public int getChildCount() {
            return this.getChildren().length;
        }

        public TreeTableNode getChild(int index) {
            return this.getChildren()[index];
        }

        TreeTableNode[] getChildren() {
            if (this.children == null) {
                Object[] kidDis = BLearnTable.this.learn.getChildren(this.discovery);
                Node[] kidNodes = new Node[kidDis.length];
                for (int i = 0; i < kidNodes.length; ++i) {
                    kidNodes[i] = new Node(this, kidDis[i]);
                }
                this.children = kidNodes;
            }
            return this.children;
        }

        public Object getValueAt(int col) {
            return BLearnTable.this.cols[col].get(this.discovery);
        }

        public BImage getIcon() {
            if (this.icon == null) {
                this.icon = BLearnTable.this.learn.getIcon(this.discovery);
                if (BLearnTable.this.learn.getExisting(this.discovery) != null && this.icon != null) {
                    this.icon = this.icon.getDisabledImage();
                }
            }
            return this.icon;
        }
    }

    class Renderer
    extends TreeTableCellRenderer {
        Renderer() {
        }

        public String getCellText(TableCellRenderer.Cell cell) {
            try {
                Object obj = BLearnTable.this.getObjectAt(cell.row);
                MgrColumn col = BLearnTable.this.columnIndexToMgrColumn(cell.column);
                return col.toDisplayString(obj, cell.value, BLearnTable.this.manager.getCurrentContext());
            }
            catch (Exception e) {
                return "";
            }
        }
    }

    class Model
    extends TreeTableModel {
        Node[] roots = new Node[0];

        Model() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateTreeTable(boolean resize) {
            BWbShell shell = BLearnTable.this.getManager().getWbShell();
            shell.enterBusy();
            try {
                Object[] discovery = BLearnTable.this.learn.getRoots();
                Node[] roots = new Node[discovery.length];
                for (int i = 0; i < roots.length; ++i) {
                    Node root = this.discoveryToRoot(discovery[i]);
                    if (root == null) {
                        root = new Node(this, discovery[i]);
                    }
                    roots[i] = root;
                }
                int sortCol = BLearnTable.this.dynamicModel.toRootColumnIndex(BLearnTable.this.getSortColumn());
                if (sortCol >= 0) {
                    roots = BLearnTable.sort(roots, sortCol, BLearnTable.this.isSortAscending());
                }
                this.roots = roots;
                super.updateTreeTable(resize);
            }
            finally {
                shell.exitBusy();
            }
        }

        public int getRootCount() {
            return this.roots.length;
        }

        public TreeTableNode getRoot(int index) {
            return this.roots[index];
        }

        public boolean isDepthExpandable(int depth) {
            return BLearnTable.this.learn.isDepthExpandable(depth);
        }

        public int getColumnCount() {
            return BLearnTable.this.cols.length;
        }

        public String getColumnName(int col) {
            return BLearnTable.this.cols[col].getDisplayName();
        }

        public boolean isColumnSortable(int col) {
            return true;
        }

        public void sortByColumn(int col, boolean ascending) {
            this.getSelection().deselectAll();
            this.roots = BLearnTable.sort(this.roots, col, ascending);
            super.updateTreeTable(false);
        }

        Node discoveryToRoot(Object discovery) {
            Node[] roots = this.roots;
            for (int i = 0; i < roots.length; ++i) {
                if (roots[i].discovery != discovery) continue;
                return roots[i];
            }
            return null;
        }
    }

    class Controller
    extends TreeTableController {
        Controller() {
        }

        public void cellDoubleClicked(BMouseEvent event, int row, int col) {
            BLearnTable.this.getManager().getController().cellDoubleClicked(BLearnTable.this, event, row, col);
        }

        protected BMenu makePopup(TreeTableSubject subject) {
            BMenu menu = super.makePopup(subject);
            return BLearnTable.this.manager.getController().makePopup(BLearnTable.this, subject, menu);
        }

        public BMenu makeOptionsMenu() {
            BMenu menu = super.makeOptionsMenu();
            return BLearnTable.this.getManager().getController().makeOptionsMenu(BLearnTable.this, menu);
        }
    }

    class Selection
    extends TreeTableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            BLearnTable.this.manager.controller.updateCommands();
        }
    }
}

