/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import com.tridium.workbench.util.WbViewEventWorker;
import javax.baja.job.BJob;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.TagDictionaryService;
import javax.baja.ui.BMenu;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTagDictionary;
import javax.baja.workbench.mgr.MgrTemplate;
import javax.baja.workbench.view.BIExportableTableView;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType
@NiagaraSlots(actions={@NiagaraAction(name="handleLearnSelection"), @NiagaraAction(name="handleTagSelection"), @NiagaraAction(name="handleDbSelection")})
public abstract class BAbstractManager
extends BWbComponentView
implements BIExportableTableView {
    public static final Action handleLearnSelection = BAbstractManager.newAction((int)0, null);
    public static final Action handleTagSelection = BAbstractManager.newAction((int)0, null);
    public static final Action handleDbSelection = BAbstractManager.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BAbstractManager.class);
    Lexicon lex = Lexicon.make(BAbstractManager.class);
    String lexTemplateObjects = this.lex.getText("template.objects");
    String lexDiscoveryObjects = this.lex.getText("discovery.objects");
    String lexDatabaseObjects = this.lex.getText("database.objects");
    boolean initialized;
    MgrModel model;
    MgrController controller;
    MgrLearn learn;
    MgrTagDictionary tagDictionary;
    MgrTemplate template;
    BComponent target;
    BWidget tablePane;
    BWidget learnPane;
    BWidget tagDictionaryPane;
    BWidget templatePane;
    BSplitPane upperPaneSplitter;
    BSplitPane mainSplitter;
    int mgrEditState = 0;
    BEdgePane content;

    public void handleLearnSelection() {
        this.invoke(handleLearnSelection, null, null);
    }

    public void handleTagSelection() {
        this.invoke(handleTagSelection, null, null);
    }

    public void handleDbSelection() {
        this.invoke(handleDbSelection, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BAbstractManager() {
        this.autoRegisterForComponentEvents = false;
    }

    protected void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.model = this.makeModel();
        this.learn = this.makeLearn();
        this.tagDictionary = this.makeTagDictionary();
        this.template = this.makeTemplate();
        this.controller = this.makeController();
        this.model.init();
        if (this.learn != null) {
            this.learn.init();
        }
        if (this.tagDictionary != null) {
            this.tagDictionary.init();
        }
        if (this.template != null) {
            this.template.init();
        }
        this.controller.init();
        this.tablePane = this.model.makePane();
        if (this.learn != null) {
            this.learnPane = this.learn.makePane();
            this.learnPane.setVisible(this.controller.learnMode.isSelected());
        }
        if (this.tagDictionary != null) {
            this.tagDictionaryPane = this.tagDictionary.makePane();
            this.tagDictionaryPane.setVisible(this.controller.tagMode.isSelected());
        }
        if (this.template != null) {
            this.templatePane = this.template.makePane();
            this.templatePane.setVisible(this.controller.templateMode.isSelected());
        }
        BWidget actionBar = this.controller.makeActionBar();
        this.content = new BEdgePane();
        this.updateContent();
        if (actionBar != null && !actionBar.isNull()) {
            this.content.setBottom((BWidget)new BBorderPane(actionBar, 5.0, 5.0, 0.0, 5.0));
        }
        this.setContent((BWidget)this.content);
        if (this.getLearn() != null) {
            this.linkTo((BComponent)this.getLearn().getTable(), (Slot)BTable.selectionModified, (Slot)handleLearnSelection);
        }
        if (this.getMgrTagDictionary() != null) {
            this.linkTo((BComponent)this.getMgrTagDictionary().getTable(), (Slot)BTable.selectionModified, (Slot)handleTagSelection);
        }
        this.linkTo((BComponent)this.getModel().getTable(), (Slot)BTable.selectionModified, (Slot)handleDbSelection);
    }

    public void updateContent() {
        boolean showTemplate;
        boolean hasLearn = this.learnPane != null;
        boolean hasTagDictionary = this.tagDictionaryPane != null;
        boolean hasDevTemplate = this.templatePane != null;
        boolean showLearn = hasLearn && this.controller.learnMode.isSelected();
        boolean showTagDictionary = hasTagDictionary && this.controller.tagMode.isSelected();
        boolean bl = showTemplate = hasDevTemplate && this.controller.templateMode.isSelected();
        if (hasLearn) {
            this.learnPane.setVisible(showLearn);
        }
        if (hasDevTemplate) {
            this.templatePane.setVisible(showTemplate);
        }
        if (hasTagDictionary) {
            this.tagDictionaryPane.setVisible(showTagDictionary);
        }
        int tableLearnSplit = 0;
        if (hasLearn && (hasDevTemplate || hasTagDictionary)) {
            BComplex tpParent;
            boolean tpHasParent;
            if (this.upperPaneSplitter == null) {
                this.upperPaneSplitter = new BSplitPane(BOrientation.horizontal, 50.0);
            }
            if (this.learnPane.getParent() == null) {
                this.upperPaneSplitter.setWidget1(this.learnPane);
            }
            if (showLearn && (showTemplate || showTagDictionary)) {
                this.upperPaneSplitter.setDividerPosition(50.0);
            } else if (showLearn) {
                this.upperPaneSplitter.setDividerPosition(100.0);
            } else {
                this.upperPaneSplitter.setDividerPosition(0.0);
            }
            if (showTemplate) {
                if (this.templatePane.getParent() == null) {
                    this.upperPaneSplitter.setWidget2(this.templatePane);
                }
            } else if (showTagDictionary && this.tagDictionaryPane.getParent() == null) {
                this.upperPaneSplitter.setWidget2(this.tagDictionaryPane);
            }
            tableLearnSplit = showLearn || showTagDictionary || showTemplate ? 50 : 0;
            if (this.mainSplitter == null) {
                this.mainSplitter = new BSplitPane(BOrientation.vertical, (double)tableLearnSplit);
            }
            this.mainSplitter.setDividerPosition((double)tableLearnSplit);
            if (this.upperPaneSplitter.getParent() == null) {
                this.mainSplitter.setWidget1((BWidget)this.upperPaneSplitter);
            }
            boolean bl2 = tpHasParent = (tpParent = this.tablePane.getParent()) != null;
            if (!tpHasParent) {
                this.mainSplitter.setWidget2(this.tablePane);
            }
            if (this.mainSplitter.getParent() == null) {
                this.content.setCenter((BWidget)this.mainSplitter);
            }
            this.mainSplitter.relayout();
            this.upperPaneSplitter.relayout();
            if (this.learnPane != null && this.learnPane.getParentWidget() != null) {
                this.learnPane.getParentWidget().relayout();
            }
            if (this.tagDictionaryPane != null && this.tagDictionaryPane.getParentWidget() != null) {
                this.tagDictionaryPane.getParentWidget().relayout();
            }
            if (this.templatePane != null && this.templatePane.getParentWidget() != null) {
                this.templatePane.getParentWidget().relayout();
            }
        } else if (hasLearn) {
            tableLearnSplit = showLearn ? 50 : 0;
            if (this.mainSplitter == null) {
                this.mainSplitter = new BSplitPane(BOrientation.vertical, (double)tableLearnSplit);
            }
            if (this.learnPane.getParent() == null) {
                this.mainSplitter.setWidget1(this.learnPane);
            }
            if (this.tablePane.getParent() == null) {
                this.mainSplitter.setWidget2(this.tablePane);
            }
            this.content.setCenter((BWidget)this.mainSplitter);
            this.mainSplitter.setDividerPosition((double)tableLearnSplit);
            this.mainSplitter.relayout();
        } else if (hasDevTemplate || hasTagDictionary) {
            tableLearnSplit = showTemplate || showTagDictionary ? 50 : 0;
            if (this.mainSplitter == null) {
                this.mainSplitter = new BSplitPane(BOrientation.vertical, (double)tableLearnSplit);
            }
            this.mainSplitter.setDividerPosition((double)tableLearnSplit);
            if (showTemplate) {
                if (this.templatePane.getParent() == null) {
                    this.mainSplitter.setWidget1(this.templatePane);
                }
            } else if (showTagDictionary && this.tagDictionaryPane.getParent() == null) {
                this.mainSplitter.setWidget1(this.tagDictionaryPane);
            }
            if (this.tablePane.getParent() == null) {
                this.mainSplitter.setWidget2(this.tablePane);
            }
            this.content.setCenter((BWidget)this.mainSplitter);
            this.mainSplitter.relayout();
            if (this.templatePane != null && this.templatePane.getParentWidget() != null) {
                this.templatePane.getParentWidget().relayout();
            }
        } else {
            this.content.setCenter(this.tablePane);
        }
    }

    public final BComponent getTarget() {
        return this.target;
    }

    public final MgrModel getModel() {
        return this.model;
    }

    protected MgrModel makeModel() {
        return new MgrModel(this);
    }

    public final MgrController getController() {
        return this.controller;
    }

    protected MgrController makeController() {
        return new MgrController(this);
    }

    public final boolean isLearnable() {
        return this.learn != null;
    }

    public final MgrLearn getLearn() {
        return this.learn;
    }

    protected MgrLearn makeLearn() {
        return null;
    }

    public final boolean isTaggable() {
        return this.tagDictionary != null;
    }

    public final boolean isTemplatable() {
        return this.template != null;
    }

    public final MgrTemplate getMgrTemplate() {
        return this.template;
    }

    public final MgrTagDictionary getMgrTagDictionary() {
        return this.tagDictionary;
    }

    protected MgrTagDictionary makeTagDictionary() {
        BComponent target = this.getTarget();
        TagDictionaryService service = target.getTagDictionaryService();
        if (service != null) {
            return new MgrTagDictionary(this);
        }
        return null;
    }

    protected MgrTemplate makeTemplate() {
        return null;
    }

    public void setMgrEditState(int state) {
        this.mgrEditState = state;
    }

    public int getMgrEditState() {
        return this.mgrEditState;
    }

    public void doHandleLearnSelection() {
        this.controller.learnSelectionChanged();
    }

    public void doHandleTagSelection() {
        this.controller.tagSelectionChanged();
    }

    public void doHandleDbSelection() {
        this.controller.dbSelectionChanged();
    }

    public BToolBar getViewToolBar() {
        this.init();
        return this.controller.makeToolBar();
    }

    public BMenu[] getViewMenus() {
        this.init();
        return this.controller.makeMenus();
    }

    @Override
    public BTable getExportTable() {
        return this.model.getTable();
    }

    @Override
    public void doLoadValue(BObject obj, Context cx) {
        this.target = (BComponent)obj;
        this.init();
        this.model.load(this.target);
        this.controller.load(this.target);
        if (this.learn != null) {
            this.learn.load(this.target);
        }
        if (this.tagDictionary != null) {
            this.tagDictionary.load(this.target);
        }
        if (this.template != null) {
            this.template.load(this.target);
        }
        try {
            this.restoreState();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deactivated() {
        super.deactivated();
        try {
            this.saveState();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void restoreState() {
        MgrState state = MgrState.getCached(MgrState.toKey(this));
        if (state != null) {
            state.restore(this);
        }
    }

    public void saveState() {
        MgrState state = this.makeState();
        if (state != null) {
            state.save(this);
            MgrState.cache(MgrState.toKey(this), state);
        }
    }

    protected MgrState makeState() {
        return new MgrState();
    }

    @Override
    public void handleComponentEvent(BComponentEvent event) {
        super.handleComponentEvent(event);
        this.controller.updateCommands();
        if (this.learn != null) {
            BJob job;
            if (this.learn.getTable() != null) {
                this.learn.getTable().resetIcons();
            }
            if (this.learn.getJob() == event.getSourceComponent() && (job = (BJob)event.getSourceComponent()).getJobState().isComplete() && !this.learn.jobComplete) {
                this.learn.jobComplete = true;
                WbViewEventWorker.getInstance().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (BAbstractManager.this.isRegisteredForComponentEvents((BComponent)job)) {
                            BAbstractManager.this.registerForComponentEvents((BComponent)job, Integer.MAX_VALUE);
                        }
                        BAbstractManager.this.learn.jobComplete(job);
                    }
                });
            }
        }
    }
}

