/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.bql.table;

import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Tables;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.table.TableModel;
import javax.baja.workbench.bql.table.BBqlTable;
import javax.baja.workbench.bql.table.BqlTableColumn;

public class BqlTableModel
extends TableModel {
    private BObject base;
    private BOrd prefix;
    private BOrd ord;
    private BIRandomAccessTable<BIObject> resultTable;
    private ColumnList resultColumns;
    private String predicate;
    private String extent = "baja:Component";
    private BqlTableColumn[] columns;
    private BqlTableColumn.Status statusColumn;
    private BqlTableColumn.Icon iconColumn;
    private BqlTableColumn.Nav navColumn;
    private Object loadLock = new Object();
    private boolean loading = false;
    private boolean loaded = false;

    public BqlTableModel() {
        this.columns = new BqlTableColumn[0];
    }

    public BqlTableModel(BqlTableColumn[] columns) {
        this.setColumns(columns);
    }

    public BObject getBase() {
        return this.base;
    }

    public void setBase(BObject base) {
        this.setBase(base, (BOrd)null);
    }

    public void setBase(BObject base, BOrd prefix) {
        this.base = base;
        this.prefix = prefix;
    }

    public void setBase(BObject base, String prefix) {
        this.setBase(base, BOrd.make((String)prefix));
    }

    public String getExtent() {
        return this.extent;
    }

    public void setExtent(String extent) {
        this.extent = extent;
    }

    public String getPredicate() {
        return this.predicate;
    }

    public void setPredicate(String predicate) {
        this.predicate = predicate;
    }

    public BOrd getOrd() {
        if (this.ord == null) {
            this.updateOrd();
        }
        return this.ord;
    }

    public BqlTableColumn.Status getStatusColumn() {
        return this.statusColumn;
    }

    public BqlTableColumn.Icon getIconColumn() {
        return this.iconColumn;
    }

    public BqlTableColumn.Nav getNavColumn() {
        return this.navColumn;
    }

    public void setColumns(BqlTableColumn[] columns) {
        this.columns = new BqlTableColumn[columns.length];
        System.arraycopy(columns, 0, this.columns, 0, columns.length);
        this.statusColumn = null;
        this.iconColumn = null;
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] instanceof BqlTableColumn.Status) {
                this.statusColumn = (BqlTableColumn.Status)columns[i];
                continue;
            }
            if (columns[i] instanceof BqlTableColumn.Icon) {
                this.iconColumn = (BqlTableColumn.Icon)columns[i];
                continue;
            }
            if (!(columns[i] instanceof BqlTableColumn.Nav)) continue;
            this.navColumn = (BqlTableColumn.Nav)columns[i];
        }
    }

    public int getBqlColumnCount() {
        return this.columns.length;
    }

    public BqlTableColumn getBqlColumn(int index) {
        return this.columns[index];
    }

    public int getRowCount() {
        if (!this.loaded) {
            return 0;
        }
        return this.resultTable.size();
    }

    public int getColumnCount() {
        if (this.columns == null) {
            return 0;
        }
        return this.columns.length;
    }

    public String getColumnName(int index) {
        return this.resultColumns.get(index).getDisplayName(null);
    }

    public Object getValueAt(int row, int col) {
        return this.columns[col].getValueAt(row);
    }

    public BImage getRowIcon(int row) {
        if (this.iconColumn == null) {
            return null;
        }
        return (BImage)this.iconColumn.getValueAt(row);
    }

    private BOrd updateOrd() {
        StringBuffer s = new StringBuffer(128);
        s.append("bql:select ");
        int count = this.columns.length;
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                s.append(", ");
            }
            s.append(this.columns[i].getProjection());
        }
        if (this.extent != null) {
            s.append(" from ").append(this.extent);
        }
        if (this.predicate != null) {
            s.append(" where ").append(this.predicate);
        }
        this.ord = BOrd.make((BOrd)this.prefix, (String)s.toString());
        return this.ord;
    }

    private void reset() {
        this.resultTable = null;
        this.resultColumns = null;
        this.loaded = false;
        this.updateTable();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        Object object = this.loadLock;
        synchronized (object) {
            if (this.loading) {
                return;
            }
            this.loading = true;
        }
        try {
            BObject o;
            if (this.ord == null) {
                this.ord = this.updateOrd();
            }
            if (!((o = this.ord.resolve(this.base).get()) instanceof BITable)) {
                throw new BajaRuntimeException("Ord does not resolve to a table.");
            }
            this.resultTable = Tables.slurp((BITable)((BITable)o));
            this.resultColumns = this.resultTable.getColumns();
            int count = this.resultColumns.size();
            for (int i = 0; i < count; ++i) {
                this.columns[i].load((BITable<BIObject>)this.resultTable, this.resultColumns.get(i));
            }
            this.updateTable();
            Object object2 = this.loadLock;
            synchronized (object2) {
                this.loaded = true;
                this.loading = false;
            }
            this.notifyTable();
        }
        catch (RuntimeException e) {
            Object object3 = this.loadLock;
            synchronized (object3) {
                this.loaded = true;
                this.loading = false;
            }
            this.notifyTable();
            throw e;
        }
    }

    private void notifyTable() {
        BBqlTable table = (BBqlTable)this.getTable();
        if (table == null) {
            return;
        }
        table.queryComplete();
    }
}

