/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.wizard.step;

import com.tridium.ui.Binder;
import com.tridium.ui.wizard.step.CannotCommitException;
import com.tridium.ui.wizard.step.ICommitLog;
import com.tridium.ui.wizard.step.IWidgetWizardView;
import com.tridium.ui.wizard.step.IWizardView;
import com.tridium.ui.wizard.step.StepArtifact;
import com.tridium.ui.wizard.step.StepModel;
import com.tridium.ui.wizard.step.WizardStep;
import com.tridium.workbench.shell.BErrorPanel;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BAbstractPxView;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.ViewQuery;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.px.BWbPxView;
import javax.baja.workbench.view.BWbView;

public final class WbViewUiHandler
implements WizardStep.IUiHandler {
    private OrdTarget target;
    private static final AgentFilter viewFilter = AgentFilter.or((AgentFilter)AgentFilter.is((Type)BWbView.TYPE), (AgentFilter)AgentFilter.is((Type)BAbstractPxView.TYPE));
    public static final WizardStep.ICommit commit = new WbViewCommit();

    public WbViewUiHandler(OrdTarget target) {
        this.target = target;
    }

    public WbViewUiHandler(BOrd ord, BObject base) {
        this(ord.resolve(base));
    }

    public WbViewUiHandler(BComponent comp) {
        this(comp.getNavOrd().resolve());
    }

    public StepArtifact create(WizardStep step, StepModel model, IWizardView view, Context cx) {
        IWidgetWizardView wizardView = (IWidgetWizardView)view;
        BWbView wbView = null;
        try {
            BComponent comp = this.target.getComponent();
            comp.lease();
            AgentList agentList = comp.getAgents().filter(viewFilter);
            String viewId = null;
            ViewQuery viewQuery = this.target.getViewQuery();
            if (viewQuery != null) {
                viewId = viewQuery.getViewId();
            }
            AgentInfo agent = null;
            agent = viewId == null && agentList.size() > 0 ? agentList.getDefault() : agentList.get(viewId);
            BObject objView = agent.getInstance();
            if (objView instanceof BWbView) {
                wbView = (BWbView)objView;
            } else if (objView instanceof BAbstractPxView) {
                wbView = new BWbPxView((BAbstractPxView)objView);
            } else {
                throw new LocalizableRuntimeException("bajaui", "errorPanel.notWbView");
            }
            wizardView.setWizardContent((BWidget)wbView);
            wbView.fw(401);
            wbView.activated();
            wbView.fw(403);
            wbView.loadValue(this.target.get(), cx);
            if (wbView.getLoadError() != null) {
                throw wbView.getLoadError();
            }
            wbView.prime();
            Binder binder = (Binder)wbView.fw(302);
            if (binder != null) {
                binder.start(this.target, cx);
            }
        }
        catch (Throwable t) {
            BWbShell shell = BWbShell.getWbShell(wizardView.getOwner());
            if (shell != null) {
                String msg = t.getMessage();
                if (msg == null) {
                    msg = BDialog.TITLE_ERROR;
                }
                wizardView.setWizardContent((BWidget)new BErrorPanel(shell, msg, this.target.getOrd(), t));
            }
            System.out.println("Error loading Workbench View in Wizard: " + this.target.getOrd() + "...");
            t.printStackTrace();
        }
        return new WbViewStepArtifact(step, this.target, wbView);
    }

    public void detach(StepArtifact artifact, StepModel model, IWizardView view, Context cx) {
        IWidgetWizardView widgetView = (IWidgetWizardView)view;
        BWidget w = widgetView.getWizardContent();
        if (w instanceof BWbView) {
            BWbView wbView = (BWbView)w;
            if (wbView.fw(302) != null) {
                wbView.fw(402);
            }
            wbView.deactivated();
        }
        widgetView.setWizardContent((BWidget)new BNullWidget());
    }

    public StepArtifact updateStepArtifact(StepArtifact artifact, StepModel model, IWizardView view, Context cx) {
        return artifact;
    }

    public boolean restoreFromNext(StepArtifact artifact, StepModel model, IWizardView view, Context cx) {
        return false;
    }

    public boolean restoreFromBack(StepArtifact artifact, StepModel model, IWizardView view, Context cx) {
        return false;
    }

    public OrdTarget getTarget() {
        return this.target;
    }

    private static final class WbViewCommit
    implements WizardStep.ICommit {
        private WbViewCommit() {
        }

        public void commit(StepArtifact artifact, StepModel model, IWizardView view, ICommitLog commitLog, Context cx) throws CannotCommitException {
            try {
                WbViewStepArtifact wbArt = (WbViewStepArtifact)artifact;
                if (wbArt.getWbView() != null) {
                    wbArt.getWbView().saveValue();
                }
            }
            catch (Exception e) {
                System.out.println("Error in saving WbViewCommit...");
                e.printStackTrace();
                throw new CannotCommitException((Throwable)e);
            }
        }
    }

    public static final class WbViewStepArtifact
    extends StepArtifact {
        private OrdTarget target;
        private BWbView wbView;

        private WbViewStepArtifact(WizardStep step, OrdTarget target, BWbView wbView) {
            super(step);
            this.target = target;
            this.wbView = wbView;
        }

        public BWbView getWbView() {
            return this.wbView;
        }

        public OrdTarget getTarget() {
            return this.target;
        }
    }
}

