/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.web.browser.pdf;

import com.tridium.pdf.BIPdfAsyncWidget;
import com.tridium.pdf.gx.PdfDocument;
import com.tridium.pdf.gx.PdfGraphics;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.web.browser.BWebBrowser;
import com.tridium.workbench.web.browser.BWebWidget;
import com.tridium.workbench.web.browser.pdf.BPdfWebWidget;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.gx.Graphics;
import javax.baja.gx.Insets;
import javax.baja.gx.RectGeom;
import javax.baja.gx.Size;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.pdf.BPdfExporter;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BLayout;
import javax.baja.ui.BWidget;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BIWbViewExporter;
import javax.baja.workbench.view.BWbViewBinding;

@NiagaraType(agent={@AgentOn(types={"web:IJavaScriptToPdf"})})
@NiagaraProperties(value={@NiagaraProperty(name="attemptNativePdfExport", type="boolean", defaultValue="true", facets={@Facet(name="BFacets.TRUE_TEXT", value="BString.make(\"%lexicon(bajaui:dialog.yes)%\")"), @Facet(name="BFacets.FALSE_TEXT", value="BString.make(\"%lexicon(bajaui:dialog.no)%\")")}), @NiagaraProperty(name="delay", type="baja:RelTime", defaultValue="BRelTime.make(BIPdfAsyncWidget.POST_INITIALIZE_DELAY_TIME)", facets={@Facet(name="BFacets.MIN", value="BRelTime.makeSeconds(0)"), @Facet(name="BFacets.MAX", value="BRelTime.makeSeconds(60)")})})
public final class BWebWidgetToPdf
extends BPdfExporter
implements BIWbViewExporter {
    public static final Property attemptNativePdfExport = BWebWidgetToPdf.newProperty((int)0, (boolean)true, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (BIDataValue)BString.make((String)"%lexicon(bajaui:dialog.yes)%")), (BFacets)BFacets.make((String)"falseText", (BIDataValue)BString.make((String)"%lexicon(bajaui:dialog.no)%"))));
    public static final Property delay = BWebWidgetToPdf.newProperty((int)0, (BValue)BRelTime.make((long)BIPdfAsyncWidget.POST_INITIALIZE_DELAY_TIME), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)0)), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeSeconds((int)60))));
    public static final Type TYPE = Sys.loadType(BWebWidgetToPdf.class);
    private static final Logger LOG = Logger.getLogger("webWidgetToPdf");

    public boolean getAttemptNativePdfExport() {
        return this.getBoolean(attemptNativePdfExport);
    }

    public void setAttemptNativePdfExport(boolean v) {
        this.setBoolean(attemptNativePdfExport, v, null);
    }

    public BRelTime getDelay() {
        return (BRelTime)this.get(delay);
    }

    public void setDelay(BRelTime v) {
        this.set(delay, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void export(PdfOp op) throws Exception {
        BWebWidget ww = (BWebWidget)op.get();
        BWebBrowser browser = ww.getBrowser();
        if (this.getAttemptNativePdfExport() && browser.supportsNativePdfExport()) {
            browser.exportToNativePdf(op);
        } else {
            PdfDocument doc = new PdfDocument(op.getOutputStream(), op.getWidth(), op.getHeight());
            BPdfWebWidget pdf = new BPdfWebWidget();
            this.exportPdf(op, pdf, doc, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportPdf(PdfOp op, BIPdfAsyncWidget pdf, PdfDocument doc, boolean runAsyncDelay) throws Exception {
        Size size = doc.getPageSize();
        Insets m = doc.getMargins();
        double x = m.left;
        double y = m.top;
        double w = size.width - (m.left + m.right);
        double h = size.height - (m.top + m.bottom);
        RectGeom pageDimensions = new RectGeom(x, y, w, h);
        BWebWidget ww = (BWebWidget)op.get();
        BWebWidget copyWw = (BWebWidget)ww.newCopy(true);
        copyWw.setLayout(BLayout.makeAbs((double)0.0, (double)0.0, (double)w, (double)h));
        copyWw.setPreferredSize(w, h);
        BWidget parentWidget = ww.getParentWidget();
        if (parentWidget != null && parentWidget instanceof BViewTab) {
            BWbShell shell = ww.getWbShell();
            BWbViewBinding binding = new BWbViewBinding();
            binding.setOrd(shell.getActiveOrd());
            binding.fw(303, shell.getActiveOrdTarget(), null, null, null);
            copyWw.add(null, (BValue)binding);
            BWebWidgetToPdf.fireBindingUpdated(binding);
        } else {
            for (BBinding binding : ww.getBindings()) {
                BBinding copyBinding;
                if (!binding.isBound() || (copyBinding = (BBinding)copyWw.get(binding.getName())) == null) continue;
                copyBinding.fw(303, (Object)binding.getTarget(), null, null, null);
                BWebWidgetToPdf.fireBindingUpdated(copyBinding);
            }
        }
        pdf.fromWidget((BWidget)copyWw, op);
        doc.start();
        doc.addNewPage();
        PdfGraphics g = doc.getGraphics();
        g.translate(x, y);
        try {
            pdf.initializeAsync().get(BIPdfAsyncWidget.ASYNC_WAIT_TIME, TimeUnit.MILLISECONDS);
            if (runAsyncDelay) {
                try {
                    Thread.sleep(BIPdfAsyncWidget.POST_INITIALIZE_DELAY_TIME);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ((BWidget)pdf).paint((Graphics)g);
            doc.end();
        }
        finally {
            pdf.cleanupAsync().get(BIPdfAsyncWidget.ASYNC_WAIT_TIME, TimeUnit.MILLISECONDS);
        }
    }

    private static void fireBindingUpdated(BBinding binding) {
        try {
            binding.targetChanged();
            binding.fireTargetChanged(null);
        }
        catch (Exception err) {
            LOG.log(Level.WARNING, "Firing binding changed callbacks", err);
        }
        try {
            binding.getWidget().bindingsChanged();
        }
        catch (Exception err) {
            LOG.log(Level.WARNING, "Firing widget bindings changed callbacks", err);
        }
    }
}

