/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.web.browser.interop;

import com.tridium.workbench.web.browser.BIWebBrowserImpl;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.WeakHashMap;
import javax.baja.file.types.text.BJavascriptFile;
import javax.baja.naming.BOrd;

public abstract class BroadcastChannel {
    private static BOrd JS_FILE = BOrd.make((String)"module://workbench/com/tridium/workbench/web/browser/interop/BroadcastChannel.js");
    private Collection<BroadcastChannelEventListener> listeners = Collections.newSetFromMap(new WeakHashMap());
    private ForwardingListener forwardingListener = new ForwardingListener();
    private Collection<BIWebBrowserImpl> connectedBrowsers = new HashSet<BIWebBrowserImpl>();

    protected BroadcastChannel() {
        this.listeners.add(this.forwardingListener);
    }

    protected abstract BroadcastChannelEvent toEvent(BIWebBrowserImpl var1, Object var2);

    public void attach(BIWebBrowserImpl impl) {
        if (!this.connectedBrowsers.contains(impl)) {
            this.connectedBrowsers.add(impl);
            impl.registerConsumer("$interop_BroadcastChannel_postMessage", o -> this.interopFromBrowser(impl, o));
        }
    }

    public void injectBroadcastJs(BIWebBrowserImpl impl) throws IOException {
        BJavascriptFile file = (BJavascriptFile)JS_FILE.get();
        String str = new String(file.read());
        impl.executeScript(str);
    }

    public void detach(BIWebBrowserImpl impl) {
        this.connectedBrowsers.remove(impl);
    }

    public void addListener(BroadcastChannelEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(BroadcastChannelEventListener listener) {
        this.listeners.remove(listener);
    }

    private void interopFromBrowser(BIWebBrowserImpl sourceBrowser, Object o) {
        BroadcastChannelEvent event = this.toEvent(sourceBrowser, o);
        this.listeners.forEach(handler -> handler.onEvent(sourceBrowser, event));
    }

    private static String jsonSafe(String dataJSON) {
        return dataJSON.replace("\\", "\\\\").replace("'", "\\'");
    }

    private static boolean shareOrigin(BIWebBrowserImpl impl1, BIWebBrowserImpl impl2) {
        return impl1.getScheme().equals(impl2.getScheme()) && impl1.getHostname().equals(impl2.getHostname()) && impl1.getPort() == impl2.getPort();
    }

    private class ForwardingListener
    implements BroadcastChannelEventListener {
        private ForwardingListener() {
        }

        @Override
        public void onEvent(BIWebBrowserImpl sourceBrowser, BroadcastChannelEvent event) {
            BroadcastChannel.this.connectedBrowsers.stream().filter(browser -> BroadcastChannel.shareOrigin(sourceBrowser, browser)).forEach(browser -> {
                String script = "BroadcastChannel.$interop_onmessage(" + event.getEventJSON() + ");";
                browser.executeScriptAsync(script);
            });
        }
    }

    @FunctionalInterface
    public static interface BroadcastChannelEventListener {
        public void onEvent(BIWebBrowserImpl var1, BroadcastChannelEvent var2);
    }

    public static class BroadcastChannelEvent {
        private String channelName;
        private String channelId;
        private String dataJSON;

        public BroadcastChannelEvent(String channelName, String channelId, String dataJSON) {
            this.channelName = channelName;
            this.channelId = channelId;
            this.dataJSON = dataJSON;
        }

        public String getChannelName() {
            return this.channelName;
        }

        public String getChannelId() {
            return this.channelId;
        }

        public String getDataJSON() {
            return this.dataJSON;
        }

        private String getEventJSON() {
            return "{  channelName: '" + BroadcastChannel.jsonSafe(this.channelName) + "',  channelId: '" + BroadcastChannel.jsonSafe(this.channelId) + "',  event: {     data: JSON.parse('" + BroadcastChannel.jsonSafe(this.dataJSON) + "')  }}";
        }
    }
}

