/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.web.browser.fx.debug;

import com.sun.javafx.scene.web.Debugger;
import java.io.IOException;
import java.security.AccessController;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public class FxWebBrowserDebugServer {
    private int port;
    private Server server;
    private Debugger debugger;
    private ServletContextHandler contextHandler;
    private static final int START_PORT = AccessController.doPrivileged(() -> Integer.getInteger("niagara.wb.debugPort", 9222));
    private static Map<WebView, FxWebBrowserDebugServer> debuggerMap = new WeakHashMap<WebView, FxWebBrowserDebugServer>();
    private static final Logger log = Logger.getLogger("webBrowser");
    private static final String WEB_SOCKET_ATTR_NAME = "org.javafx.devtools.DevToolsWebSocket";

    public static FxWebBrowserDebugServer connect(WebView webView) throws Exception {
        if (webView == null) {
            return null;
        }
        FxWebBrowserDebugServer debugServer = debuggerMap.get(webView);
        if (debugServer == null) {
            int lastPort = debuggerMap.values().stream().map(s -> s.port).reduce(Math::max).orElse(START_PORT - 1);
            debugServer = new FxWebBrowserDebugServer(lastPort + 1);
            debuggerMap.put(webView, debugServer);
            debugServer.start(webView);
        }
        return debugServer;
    }

    public static void disconnect(WebView webView) {
        FxWebBrowserDebugServer debugServer = debuggerMap.get(webView);
        if (debugServer != null) {
            try {
                debugServer.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            debuggerMap.remove(webView);
        }
    }

    private FxWebBrowserDebugServer(int port) {
        this.port = port;
    }

    public String getDebugUrl() {
        return "chrome-devtools://devtools/bundled/inspector.html?ws=localhost:" + this.port + "/devtools/page/1";
    }

    public void start(WebView webView) {
        Platform.runLater(() -> AccessController.doPrivileged(() -> {
            try {
                this.server = new Server(this.port);
                this.debugger = this.getDebugger(webView);
                this.debugger.setEnabled(true);
                this.debugger.sendMessage("{\"id\" : -1, \"method\" : \"Network.enable\"}");
                this.contextHandler = new ServletContextHandler(1);
                this.contextHandler.setContextPath("/");
                ServletHolder devToolsHolder = new ServletHolder((Servlet)new DevToolsWebSocketServlet());
                this.contextHandler.addServlet(devToolsHolder, "/devtools/page/1");
                this.server.setHandler((Handler)this.contextHandler);
                this.server.start();
                this.debugger.setMessageCallback(data -> {
                    DevToolsWebSocket mainSocket = this.getWebSocket(this.contextHandler);
                    if (mainSocket != null) {
                        try {
                            mainSocket.sendMessage((String)data);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    return null;
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }));
    }

    private Debugger getDebugger(WebView webView) throws Exception {
        WebEngine engine = webView.getEngine();
        return engine.impl_getDebugger();
    }

    private void stop() throws Exception {
        Platform.runLater(() -> {
            if (this.debugger != null) {
                this.debugger.setEnabled(false);
                this.debugger = null;
            }
            if (this.server != null) {
                try {
                    this.server.stop();
                    this.server.join();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error stopping debug server", e);
                }
                this.server = null;
            }
        });
    }

    private void sendMessageToBrowser(String data) {
        Platform.runLater(() -> {
            if (this.debugger != null) {
                this.debugger.sendMessage(data);
            }
        });
    }

    private DevToolsWebSocket getWebSocket(ServletContext context) {
        return (DevToolsWebSocket)context.getAttribute(WEB_SOCKET_ATTR_NAME);
    }

    private DevToolsWebSocket getWebSocket(ServletContextHandler contextHandler) {
        return this.getWebSocket((ServletContext)contextHandler.getServletContext());
    }

    public class DevToolsWebSocketServlet
    extends WebSocketServlet {
        public void configure(WebSocketServletFactory factory) {
            factory.setCreator((req, res) -> new DevToolsWebSocket());
        }
    }

    private class DevToolsWebSocket
    implements WebSocketListener {
        private Session session;

        private DevToolsWebSocket() {
        }

        private ServletContext getContext() {
            return FxWebBrowserDebugServer.this.contextHandler.getServletContext();
        }

        public void onWebSocketConnect(Session session) {
            this.session = session;
            if (this.getContext().getAttribute(FxWebBrowserDebugServer.WEB_SOCKET_ATTR_NAME) != null) {
                session.close();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Another client is already connected from " + session.getRemoteAddress() + ". Connection refused.");
                }
            } else {
                this.getContext().setAttribute(FxWebBrowserDebugServer.WEB_SOCKET_ATTR_NAME, (Object)this);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Client connected from " + session.getRemoteAddress());
                }
            }
        }

        public void onWebSocketClose(int closeCode, String message) {
            DevToolsWebSocket mainSocket = FxWebBrowserDebugServer.this.getWebSocket(this.getContext());
            if (mainSocket == this) {
                this.getContext().removeAttribute(FxWebBrowserDebugServer.WEB_SOCKET_ATTR_NAME);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Client disconnected: message " + message + ", closeCode " + closeCode);
                }
            }
        }

        public void sendMessage(String data) throws IOException {
            RemoteEndpoint remote = this.session.getRemote();
            remote.sendString(data);
        }

        public void onWebSocketText(String data) {
            FxWebBrowserDebugServer.this.sendMessageToBrowser(data);
        }

        public void onWebSocketError(Throwable t) {
            log.log(Level.SEVERE, "WebSocket error", t);
        }

        public void onWebSocketBinary(byte[] arg0, int arg1, int arg2) {
        }
    }
}

