/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.web.browser;

import com.tridium.util.Href2Ord;
import com.tridium.web.SnoopHtmlWriter;
import com.tridium.workbench.web.browser.BrowserUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Base64;
import java.util.Optional;
import javax.baja.file.BFileScheme;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.types.image.BIImageFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.util.FileUtil;

public class WebBrowserSnoopWriter
extends SnoopHtmlWriter {
    BOrd ord;

    public WebBrowserSnoopWriter(BOrd ord, Writer out) {
        super(out);
        this.ord = ord;
    }

    public static void pipe(BOrd ord, InputStream in, Writer out) throws IOException {
        InputStreamReader reader = new InputStreamReader(new BufferedInputStream(in));
        WebBrowserSnoopWriter snoop = new WebBrowserSnoopWriter(ord, out);
        snoop.pipe(reader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String hrefToUri(String href, Optional<String> tag) {
        if (href.startsWith("http:")) return href;
        if (href.startsWith("https:")) return href;
        if (href.startsWith("ftp:")) return href;
        if (href.startsWith("mailto:")) {
            return href;
        }
        if (href.startsWith("file:") && tag.isPresent() && tag.get().equalsIgnoreCase("img")) {
            try {
                BIFile file = (BIFile)BOrd.make((String)href).get();
                if (file instanceof BIImageFile) {
                    try (InputStream in = file.getInputStream();){
                        byte[] data = FileUtil.read((InputStream)in, (long)file.getSize());
                        String string = "data:" + file.getMimeType() + ";base64," + Base64.getEncoder().encodeToString(data);
                        return string;
                    }
                }
            }
            catch (Exception file) {
                // empty catch block
            }
        }
        if (href.startsWith("#")) {
            return BrowserUtil.mergeFilePathFragment(this.ord, href).encodeToString();
        }
        Href2Ord href2Ord = new Href2Ord(this.ord);
        try {
            BOrd o = href2Ord.isAlreadyOrd(href) ? BOrd.make((String)href) : href2Ord.hrefToOrd(href);
            OrdQuery[] queries = o.parse();
            int i = 0;
            while (true) {
                if (i >= queries.length) {
                    return BOrd.make((OrdQuery[])queries).relativizeToSession().toString();
                }
                if (queries[i].getScheme().equals(BFileScheme.INSTANCE.getId())) {
                    return BrowserUtil.getOrdFilePathAsHttpObject((FilePath)queries[i]).getUri();
                }
                ++i;
            }
        }
        catch (Exception e) {
            return href;
        }
    }
}

