/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.sys.Nre;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Tables;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.ui.table.TableModel;
import javax.baja.units.BUnit;
import javax.baja.units.BUnitConversion;
import javax.baja.util.IFormat;
import javax.baja.util.Lexicon;

public class CollectionTableModel
extends TableModel {
    private static IFormat defaultFormat = new DefaultFormat();
    private static Lexicon lex = Lexicon.make((String)"workbench");
    private BIRandomAccessTable<? extends BIObject> itable;
    private Context cx;
    private String[] colNames;
    private IFormat[] formats;

    public CollectionTableModel(BITable<? extends BIObject> itable, Context cx) {
        this.itable = Tables.slurp(itable);
        this.cx = cx;
        this.updateColumns();
    }

    public BIRandomAccessTable<? extends BIObject> getBITable() {
        return this.itable;
    }

    public void setCollection(BITable<? extends BIObject> t) {
        this.itable = Tables.slurp(t);
        this.updateColumns();
        this.updateTable();
    }

    private void updateColumns() {
        ColumnList columns = this.itable.getColumns();
        int colCount = columns.size();
        this.colNames = new String[colCount];
        this.formats = new IFormat[colCount];
        for (int i = 0; i < colCount; ++i) {
            BUnit unit;
            Column col = columns.get(i);
            this.formats[i] = this.getFormatter(col);
            this.colNames[i] = col.getDisplayName(this.cx);
            BFacets facets = col.getFacets();
            if (facets == null || facets.isNull() || (unit = (BUnit)facets.get("units")) == null || unit.isNull()) continue;
            int convert = Nre.unitConversion;
            if ((convert = facets.geti("unitConversion", convert)) != 0) {
                unit = BUnitConversion.make((int)convert).getDesiredUnit(unit);
            }
            int n = i;
            this.colNames[n] = this.colNames[n] + " (" + unit.getSymbol() + ")";
        }
    }

    public int getRowCount() {
        return this.itable.size();
    }

    public int getColumnCount() {
        return this.colNames.length;
    }

    public String getColumnName(int col) {
        return this.colNames[col];
    }

    public Object getValueAt(int rowIndex, int colIndex) {
        Column col = this.itable.getColumns().get(colIndex);
        BObject value = (BObject)this.itable.get(rowIndex).cell(col).as(BObject.class);
        return this.formats[colIndex].format((Object)value, col.getFacets());
    }

    public Object getSubject(int row) {
        return this.itable.get(row).rowObject();
    }

    private IFormat getFormatter(Column col) {
        String colName = col.getName();
        if (colName.equals("trendFlags") && col.getType() == BInteger.TYPE) {
            return new TrendFlagsFormat();
        }
        if (col.getType() == BOrdList.TYPE) {
            return new OrdListFormat();
        }
        return defaultFormat;
    }

    public BITable<? extends BIObject> export() {
        return this.itable;
    }

    public BObject export(int row, int col) {
        return (BObject)this.itable.get(row).cell(this.itable.getColumns().get(col)).as(BObject.class);
    }

    public boolean isColumnSortable(int col) {
        if (this.itable.size() <= 0) {
            return false;
        }
        return this.itable instanceof BIRandomAccessTable;
    }

    public void sortByColumn(int col, boolean ascending) {
        if (!(this.itable instanceof BIRandomAccessTable)) {
            throw new UnsupportedOperationException();
        }
        this.itable = this.itable.sort(this.itable.getColumns().get(col), ascending);
    }

    private static class OrdListFormat
    implements IFormat {
        private OrdListFormat() {
        }

        public String format(Object obj, BFacets facets) {
            BOrdList list = (BOrdList)obj;
            try {
                return list.encodeToString().replace('\n', '|');
            }
            catch (Exception exception) {
                return list.toString();
            }
        }
    }

    private static class TrendFlagsFormat
    implements IFormat {
        private String[] tags = new String[]{"TrendFlags.start", "TrendFlags.outOfOrder", "TrendFlags.hidden", "TrendFlags.modified", "TrendFlags.interpolated", "TrendFlags.reserved0", "TrendFlags.reserved1", "TrendFlags.reserved2"};

        public TrendFlagsFormat() {
            Lexicon lex = Lexicon.make((String)"history");
            this.tags[0] = lex.getText(this.tags[0]);
            this.tags[1] = lex.getText(this.tags[1]);
            this.tags[2] = lex.getText(this.tags[2]);
            this.tags[3] = lex.getText(this.tags[3]);
            this.tags[4] = lex.getText(this.tags[4]);
            this.tags[5] = lex.getText(this.tags[5]);
            this.tags[6] = lex.getText(this.tags[6]);
            this.tags[7] = lex.getText(this.tags[7]);
        }

        public String format(Object obj, BFacets facets) {
            int bits = ((BInteger)obj).getInt();
            if (bits == 0) {
                return "{ }";
            }
            StringBuffer s = new StringBuffer();
            s.append('{');
            int mask = 1;
            boolean first = true;
            for (int i = 0; i < 8; ++i) {
                if ((bits & mask) != 0) {
                    if (!first) {
                        s.append(",");
                    }
                    first = false;
                    s.append(this.tags[i]);
                }
                mask <<= 1;
            }
            s.append('}');
            return s.toString();
        }
    }

    private static class DefaultFormat
    implements IFormat {
        private DefaultFormat() {
        }

        public String format(Object obj, BFacets facets) {
            if (obj instanceof BObject) {
                return ((BObject)obj).toString((Context)facets);
            }
            return obj.toString();
        }
    }
}

