/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.util.BSessionInfo;
import javax.baja.agent.BIAgent;
import javax.baja.gx.BImage;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

public class BSessionInfoDialog
extends BDialog
implements BIAgent {
    public static final Action okButtonPressed = BSessionInfoDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType(BSessionInfoDialog.class);
    protected static final BIcon userIcon = BIcon.make((String)"module://icons/x32/user.png");
    private static Lexicon lex = Lexicon.make((String)"workbench");
    protected BButton okButton;
    protected BSessionInfo info;

    public void okButtonPressed(BWidgetEvent event) {
        this.invoke(okButtonPressed, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSessionInfoDialog() {
    }

    public BSessionInfoDialog(BWidget owner) {
        super(owner, "", true, (BWidget)new BNullWidget());
    }

    public void show(BWidget owner, BSessionInfo info) {
        BSessionInfoDialog dialog = new BSessionInfoDialog(owner);
        dialog.show(info);
    }

    public void show(BSessionInfo info) {
        this.info = info;
        this.setTitle(lex.getText("sessionInfoDialog.title", new Object[]{info.getHostname()}));
        this.setModal(true);
        this.setContent(this.buildDialog());
        this.setBoundsCenteredOnOwner();
        this.setResizable(false);
        this.setDefaultButton(this.okButton);
        this.open();
    }

    private BWidget buildDialog() {
        BEdgePane dialogPane = new BEdgePane();
        dialogPane.setCenter(this.buildContent());
        return dialogPane;
    }

    private BWidget buildContent() {
        BGridPane contentPane = new BGridPane(1);
        contentPane.setHalign(BHalign.center);
        contentPane.setColumnAlign(BHalign.center);
        contentPane.add(null, (BValue)this.buildBody());
        contentPane.add(null, (BValue)this.buildButtons());
        return new BBorderPane((BWidget)contentPane, 7.0, 7.0, 7.0, 7.0);
    }

    protected BWidget buildRow(BImage icon, BWidget msg) {
        BGridPane row = new BGridPane(2);
        row.setRowGap(10.0);
        row.setColumnGap(10.0);
        row.setColumnAlign(BHalign.fill);
        row.setHalign(BHalign.fill);
        row.setStretchColumn(1);
        row.add(null, (BValue)new BLabel(icon));
        row.add(null, (BValue)msg);
        return row;
    }

    protected BWidget wordWrappedLabel(String text, BHalign align, double width) {
        BLabel label = new BLabel(text, align);
        label.setWordWrapEnabled(true, width);
        return label;
    }

    protected BWidget buildBody() {
        BGridPane grid = new BGridPane(1);
        grid.setStretchColumn(0);
        grid.setHalign(BHalign.fill);
        grid.setColumnAlign(BHalign.fill);
        String userName = this.info.getUsername();
        if (userName != null) {
            grid.add(null, (BValue)this.buildRow(BImage.make((BIcon)userIcon), this.wordWrappedLabel(this.info.getConnectedAsMessage(userName), BHalign.left, 250.0)));
            grid.add(null, (BValue)new BSeparator());
        }
        grid.add(null, (BValue)this.buildRow(BImage.make((BIcon)this.info.getHostnameIcon()), this.wordWrappedLabel(this.info.getHostnameMessage(), BHalign.left, 250.0)));
        grid.add(null, (BValue)new BSeparator());
        grid.add(null, (BValue)this.buildRow(BImage.make((BIcon)this.info.getIdentityVerifiedIcon()), this.wordWrappedLabel(this.info.getIdentityVerifiedMessage(), BHalign.left, 250.0)));
        grid.add(null, (BValue)new BSeparator());
        grid.add(null, (BValue)this.buildRow(BImage.make((BIcon)this.info.getSessionEncryptedIcon()), this.wordWrappedLabel(this.info.getSessionEncryptedMessage(), BHalign.left, 250.0)));
        grid.add(null, (BValue)new BSeparator());
        if (this.info.isFips()) {
            grid.add(null, (BValue)this.buildRow(BImage.make((BIcon)this.info.getFipsIcon()), this.wordWrappedLabel(this.info.getFipsMessage(), BHalign.left, 250.0)));
            grid.add(null, (BValue)new BSeparator());
        }
        grid.add(null, (BValue)this.buildRow(BImage.make((BIcon)this.info.getLastConnectedIcon()), this.wordWrappedLabel(this.info.getLastConnectedMessage(), BHalign.left, 250.0)));
        grid.add(null, (BValue)new BSeparator());
        return grid;
    }

    private BWidget buildButtons() {
        BGridPane buttonPane = new BGridPane(1);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        buttonPane.add(null, (BValue)this.okButton);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(true);
        return new BBorderPane((BWidget)buttonPane, 7.0, 0.0, 0.0, 0.0);
    }

    public void windowClosing(BWindowEvent event) {
        this.close();
    }

    public void doOkButtonPressed(BWidgetEvent event) throws Exception {
        this.close();
    }
}

