/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.sidebars;

import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.util.ThrowableUtil;
import com.tridium.workbench.bookmark.BookmarkEvents;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.WbMain;
import com.tridium.workbench.sidebars.BHostNavReorderPad;
import java.util.HashMap;
import java.util.Set;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.spy.BSpySpace;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.bookmark.BBookmark;
import javax.baja.ui.bookmark.BBookmarkFolder;
import javax.baja.ui.bookmark.BBookmarkOptions;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.DefaultListModel;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.nav.tree.BNavTree;
import javax.baja.workbench.nav.tree.DefaultNavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeController;
import javax.baja.workbench.nav.tree.NavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeNode;
import javax.baja.workbench.nav.tree.NavTreeSubject;
import javax.baja.workbench.sidebar.BWbSideBar;

public class BNavSideBar
extends BWbSideBar
implements BookmarkEvents.Listener {
    public static final Action updateTree = BNavSideBar.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BNavSideBar.class);
    private boolean init = false;
    private static BImage errorIcon = BImage.make((String)"module://icons/x32/error.png");
    private static BImage newTreeIcon = BImage.make((String)"module://icons/x16/newTree.png");
    private static BImage syncIcon = BImage.make((String)"module://icons/x16/sync.png");
    private static BImage closeIcon = BImage.make((String)"module://icons/x16/close.png");
    private static Lexicon lex = Lexicon.make((String)"workbench");
    private static BImage reorderIcon = BImage.make((String)"module://icons/x16/reorder.png");
    private BEdgePane content;
    private BTreePane treePane;
    private BListDropDown openTrees;
    private Close close;
    private BNavTree tree;
    private BINavNode root;
    private boolean inError = false;
    private HashMap<NavWrapper, NavTreeModel> hash = new HashMap();
    private int navTreeCount = 1;

    public void updateTree() {
        this.invoke(updateTree, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BNavSideBar() {
        this.tree = new BNavTree();
        this.tree.setMultipleSelection(true);
        this.tree.setController(new Controller());
        this.openTrees = new BListDropDown();
        this.openTrees.getList().setModel((ListModel)new NavListModel());
        this.linkTo(null, (BComponent)this.openTrees, (Slot)BListDropDown.listActionPerformed, (Slot)updateTree);
        BButton b1 = new BButton((Command)new ReorderHosts(this), false, true);
        BButton b2 = new BButton((Command)new SyncTree(this), false, true);
        this.close = new Close(this);
        BButton b3 = new BButton((Command)this.close, false, true);
        b1.setButtonStyle(BButtonStyle.toolBar);
        b1.setFocusTraversable(false);
        b2.setButtonStyle(BButtonStyle.toolBar);
        b2.setFocusTraversable(false);
        b3.setButtonStyle(BButtonStyle.toolBar);
        b3.setFocusTraversable(false);
        BGridPane grid = new BGridPane(3);
        grid.setColumnAlign(BHalign.fill);
        grid.setRowAlign(BValign.fill);
        grid.add(null, (BValue)b1);
        grid.add(null, (BValue)b2);
        grid.add(null, (BValue)b3);
        BEdgePane top = new BEdgePane();
        top.setLeft((BWidget)grid);
        top.setCenter((BWidget)new BBorderPane((BWidget)this.openTrees, 0.0, 0.0, 0.0, 5.0));
        BBorderPane topPane = new BBorderPane((BWidget)top, 5.0, 5.0, 5.0, 5.0);
        this.treePane = new BTreePane((BTree)this.tree);
        StyleUtils.addStyleClass((IStylable)this.treePane, (String)"sidebar-scroll-pane");
        this.content = new BEdgePane();
        this.content.setTop((BWidget)topPane);
        this.content.setCenter((BWidget)this.treePane);
        this.setContent((BWidget)this.content);
    }

    public void started() throws Exception {
        super.started();
        if (!this.init) {
            BOrd ord = this.getWbShell().getProfile().getNavRootOrd();
            this.root = (BINavNode)ord.resolve().get();
            this.loadNavTrees();
            this.openTrees.getList().setSelectedIndex(0);
            this.doUpdateTree();
            this.init = true;
        }
        BookmarkEvents.add(this);
    }

    public void stopped() throws Exception {
        super.stopped();
        BookmarkEvents.remove(this);
    }

    @Override
    public void activeViewChanged() {
        if (!this.inError) {
            return;
        }
        this.doUpdateTree();
    }

    public void goInto(BINavNode node) {
        BBookmarkOptions options = this.getOptions();
        BBookmark bookmark = new BBookmark(node.getNavDisplayName(null), node.getNavOrd(), node.getNavIcon());
        this.getGoInto().add(null, (BValue)bookmark);
        options.save();
        this.addTreeToList(bookmark);
        this.openTrees.getList().setSelectedIndex(this.openTrees.getList().getItemCount() - 1);
        this.doUpdateTree();
        BookmarkEvents.fireBookmarkChanged();
    }

    public void syncTree() {
        this.syncTree(false);
    }

    public void syncTree(boolean silence) {
        new SyncCommand((BWidget)this.tree, silence).invoke();
        new RefreshCommand((BWidget)this.tree).invoke();
    }

    @Override
    public void bookmarkChanged() {
        int index = this.openTrees.getList().getSelectedIndex();
        this.loadNavTrees();
        BList list = this.openTrees.getList();
        Set<NavWrapper> keys = this.hash.keySet();
        NavWrapper[] w = keys.toArray(new NavWrapper[keys.size()]);
        block0: for (int j = 0; j < w.length; ++j) {
            for (int i = 0; i < list.getItemCount(); ++i) {
                NavWrapper temp = (NavWrapper)list.getItem(i);
                if ((w[j].bookmark.getName() != null || temp.bookmark.getName() != null) && !w[j].bookmark.getName().equals(temp.bookmark.getName()) || !w[j].bookmark.getBookmarkOrd().equals((Object)temp.bookmark.getBookmarkOrd())) continue;
                this.hash.put(temp, this.hash.remove(w[j]));
                continue block0;
            }
        }
        if (index >= this.openTrees.getList().getItemCount()) {
            index = 0;
        }
        this.openTrees.getList().setSelectedIndex(index);
        this.doUpdateTree();
    }

    public void doUpdateTree() {
        this.inError = false;
        NavWrapper w = (NavWrapper)this.openTrees.getSelectedItem();
        this.close.setEnabled(!w.isRoot);
        try {
            NavTreeModel model = this.hash.get(w);
            if (model == null) {
                BNiagaraWbShell shell = (BNiagaraWbShell)this.getWbShell();
                BOrd ord = w.bookmark.getBookmarkOrd();
                BObject obj = this.openTrees.getSelectedIndex() == 0 ? ord.resolve().get() : shell.resolve(ord, null).get();
                w.bookmark.setIcon(obj.getIcon());
                model = new Model((BINavNode)obj);
                this.hash.put(w, model);
            } else {
                BOrd ord = w.bookmark.getBookmarkOrd();
                try {
                    ord.resolve(null);
                }
                catch (Exception e) {
                    this.hash.remove(w);
                    BNiagaraWbShell shell = (BNiagaraWbShell)this.getWbShell();
                    BObject obj = shell.resolve(ord, null).get();
                    model = new Model((BINavNode)obj);
                    this.hash.put(w, model);
                }
            }
            this.tree.setModel(model);
            this.tree.relayout();
            if (!(this.content.getCenter() instanceof BTreePane)) {
                this.content.setCenter((BWidget)this.treePane);
            }
        }
        catch (Exception e) {
            this.hash.remove(w);
            this.displayError(w.bookmark.getText(), e);
        }
    }

    public BNavTree getTree() {
        return this.tree;
    }

    private void displayError(String name, Exception e) {
        this.inError = true;
        BGridPane a = new BGridPane(1);
        a.setRowGap(1.0);
        a.add(null, (BValue)new BLabel(lex.getText("NavSideBar.couldNotFind"), Theme.widget().getBoldText()));
        a.add(null, (BValue)new BLabel(name));
        BGridPane b = new BGridPane(2);
        b.add(null, (BValue)new BLabel(errorIcon, ""));
        b.add(null, (BValue)a);
        BGridPane c = new BGridPane(1);
        c.setRowGap(5.0);
        c.setColumnAlign(BHalign.center);
        c.add(null, (BValue)b);
        c.add(null, (BValue)new BButton((Command)new Details(this, name, e)));
        this.content.setCenter((BWidget)c);
    }

    public BBookmarkOptions getOptions() {
        return BBookmarkOptions.make();
    }

    public BBookmarkFolder getGoInto() {
        BBookmarkFolder folder = (BBookmarkFolder)this.getOptions().getRootFolder().get("goInto");
        if (folder == null) {
            folder = new BBookmarkFolder(UiLexicon.bajaui().getText("bookmarks.goInto"));
            this.getOptions().getRootFolder().add("goInto", (BValue)folder);
        }
        return folder;
    }

    private void loadNavTrees() {
        this.openTrees.getList().removeAllItems();
        this.openTrees.getList().addItem((Object)new NavWrapper(this.makeRoot(), true));
        BBookmarkFolder folder = this.getGoInto();
        BBookmark[] trees = (BBookmark[])folder.getChildren(BBookmark.class);
        for (int i = 0; i < trees.length; ++i) {
            this.addTreeToList(trees[i]);
        }
    }

    private BBookmark makeRoot() {
        BNavRoot r = this.root == null ? BNavRoot.INSTANCE : this.root;
        return new BBookmark(r.getNavDisplayName(null), r.getNavOrd(), r.getNavIcon());
    }

    private void addTreeToList(BBookmark bookmark) {
        NavWrapper w = new NavWrapper(bookmark);
        this.openTrees.getList().addItem(BImage.make((BIcon)bookmark.getIcon()), (Object)w);
    }

    class Model
    extends DefaultNavTreeModel {
        public Model(BINavNode node) {
            super(node);
        }

        @Override
        protected void added(NavEvent event) {
            super.added(event);
            this.updateAll(event);
        }

        @Override
        protected void removed(NavEvent event) {
            NavWrapper w = (NavWrapper)BNavSideBar.this.openTrees.getSelectedItem();
            BOrd activeOrd = w.bookmark.getBookmarkOrd();
            if (WbMain.isRemoved(event, activeOrd)) {
                BNavSideBar.this.displayError(w.bookmark.getText(), new Exception("Parent node removed"));
                BNavSideBar.this.hash.remove(w);
            } else {
                super.removed(event);
                this.updateAll(event);
            }
        }

        @Override
        protected void reordered(NavEvent event) {
            super.reordered(event);
            this.updateAll(event);
        }

        private void updateAll(NavEvent event) {
            if (this != BNavSideBar.this.hash.get(BNavSideBar.this.openTrees.getSelectedItem())) {
                return;
            }
            for (int i = 0; i < BNavSideBar.this.openTrees.getList().getItemCount(); ++i) {
                NavWrapper w = (NavWrapper)BNavSideBar.this.openTrees.getList().getItem(i);
                NavTreeModel model = (NavTreeModel)((Object)BNavSideBar.this.hash.get(w));
                if (model == null || this == model) continue;
                model.navEvent(event);
            }
        }

        @Override
        public NavTreeNode makeNavTreeNode(NavTreeNode parent, BINavNode navNode) {
            if (navNode instanceof BSpySpace) {
                return null;
            }
            if (navNode.getType().getTypeSpec().toString().equals("template:MemoryFileSpace")) {
                return null;
            }
            if (navNode instanceof BIFile && navNode.getNavName().endsWith(".lock")) {
                return null;
            }
            return super.makeNavTreeNode(parent, navNode);
        }
    }

    class GoIntoCommand
    extends Command {
        BNavSideBar owner;
        NavTreeNode node;

        GoIntoCommand(BNavSideBar owner, NavTreeNode node) {
            super((BWidget)owner, UiLexicon.bajaui().module, "tree.goInto");
            this.owner = owner;
            this.node = node;
        }

        public CommandArtifact doInvoke() throws Exception {
            this.owner.goInto(this.node.getNavNode());
            return null;
        }
    }

    class NewTreeCommand
    extends Command {
        public NewTreeCommand(BWidget owner) {
            super(owner, lex.getText("NavSideBar.newTree"));
        }

        public BImage getIcon() {
            return newTreeIcon;
        }

        public CommandArtifact doInvoke() {
            BBookmarkOptions options = BNavSideBar.this.getOptions();
            BBookmark bookmark = BNavSideBar.this.makeRoot();
            bookmark.setText(bookmark.getText() + " (" + BNavSideBar.this.navTreeCount++ + ")");
            BNavSideBar.this.getGoInto().add(null, (BValue)bookmark);
            options.save();
            BNavSideBar.this.addTreeToList(bookmark);
            BNavSideBar.this.openTrees.getList().setSelectedIndex(BNavSideBar.this.openTrees.getList().getItemCount() - 1);
            BNavSideBar.this.doUpdateTree();
            BookmarkEvents.fireBookmarkChanged();
            return null;
        }
    }

    class ReorderCommand
    extends Command {
        ReorderCommand(BWidget owner) {
            super(owner, UiLexicon.bajaui().module, "tree.reorder");
        }

        public CommandArtifact doInvoke() throws Exception {
            BHostNavReorderPad pad = new BHostNavReorderPad();
            int r = BDialog.open((BWidget)this.getOwner(), (String)UiLexicon.bajaui().get("tree.reorder.label"), (Object)((Object)pad), (int)3);
            if (r == 2) {
                return null;
            }
            this.reorderHosts(pad.newOrder());
            return null;
        }

        private void reorderHosts(BINavNode[] newOrder) {
            BNavRoot.INSTANCE.reorderNavChildren(newOrder);
        }
    }

    class SyncCommand
    extends Command {
        boolean silence;

        SyncCommand(BWidget owner, boolean silence) {
            super(owner, UiLexicon.bajaui().module, "tree.sync");
            this.silence = false;
            this.silence = silence;
        }

        public CommandArtifact doInvoke() {
            block2: {
                try {
                    BObject obj = BNavSideBar.this.getWbShell().getActiveOrdTarget().get();
                    BNavSideBar.this.tree.expandToNavNode((BINavNode)obj);
                }
                catch (Exception e) {
                    if (this.silence) break block2;
                    BGridPane g = new BGridPane(1);
                    g.setHalign(BHalign.left);
                    g.add(null, (BValue)new BLabel(lex.getText("NavSideBar.nodeNotFound")));
                    g.add(null, (BValue)new BLabel(BNavSideBar.this.getWbShell().getActiveOrd().toString()));
                    BDialog.open((BWidget)this.getOwner(), (String)BDialog.TITLE_ERROR, (Object)g, (int)1, (BImage)BDialog.ERROR_ICON, (Throwable)e);
                }
            }
            return null;
        }
    }

    class RefreshCommand
    extends Command {
        RefreshCommand(BWidget owner) {
            super(owner, UiLexicon.bajaui().module, "tree.refresh");
        }

        public CommandArtifact doInvoke() throws Exception {
            if (BNavSideBar.this.tree.getModel() instanceof Model) {
                Model model = (Model)BNavSideBar.this.tree.getModel();
                model.setRootVisible(true);
                NavTreeNode node = (NavTreeNode)model.getRoot(0);
                model.setRootVisible(false);
                node.refresh();
            }
            return null;
        }
    }

    class Controller
    extends NavTreeController {
        Controller() {
        }

        @Override
        protected BMenu makePopup(NavTreeSubject subject) {
            BMenu menu = super.makePopup(subject);
            BNavTree tree = (BNavTree)this.getTree();
            if (tree.getReadonly()) {
                return null;
            }
            if (subject.size() == 0) {
                if (menu == null) {
                    menu = new BMenu();
                }
                menu.add(null, (Command)new NewTreeCommand((BWidget)tree));
                menu.add(null, (Command)new RefreshCommand((BWidget)tree));
                menu.add(null, (Command)new ReorderCommand((BWidget)tree));
                menu.add(null, (Command)new SyncCommand((BWidget)tree, false));
                return menu;
            }
            NavTreeNode active = (NavTreeNode)subject.getActiveNode();
            if (subject.size() == 1 && active != null && !(active.getNavNode() instanceof BSpySpace)) {
                if (menu == null) {
                    menu = new BMenu();
                }
                menu.add(null, (Command)new GoIntoCommand(BNavSideBar.this, active));
            }
            return menu;
        }
    }

    class NavWrapper {
        public BBookmark bookmark;
        public boolean isRoot = false;

        public NavWrapper(BBookmark bookmark) {
            this(bookmark, false);
        }

        public NavWrapper(BBookmark bookmark, boolean isRoot) {
            this.bookmark = bookmark;
            this.isRoot = isRoot;
        }

        public String toString() {
            return this.bookmark.getText();
        }
    }

    class NavListModel
    extends DefaultListModel {
        NavListModel() {
        }

        public BImage getItemIcon(int index) {
            NavWrapper w = (NavWrapper)this.getItem(index);
            return BImage.make((BIcon)w.bookmark.getIcon());
        }
    }

    class Details
    extends Command {
        private String name;
        private Exception e;

        public Details(BWidget owner, String name, Exception e) {
            super(owner, lex.getText("NavSideBar.details"));
            this.name = name;
            this.e = e;
        }

        public CommandArtifact doInvoke() {
            BTextEditor msg = new BTextEditor(ThrowableUtil.dumpToString((Throwable)this.e), false);
            BTextEditorPane pane = new BTextEditorPane(msg, 25, 80);
            BDialog.open((BWidget)this.getOwner(), (String)lex.getText("NavSideBar.details"), (Object)pane, (int)1);
            return null;
        }
    }

    class Close
    extends Command {
        public Close(BWidget owner) {
            super(owner, lex.getText("NavSideBar.closeTree"));
        }

        public BImage getIcon() {
            return closeIcon;
        }

        public CommandArtifact doInvoke() {
            NavWrapper w = (NavWrapper)BNavSideBar.this.openTrees.getList().getSelectedItem();
            w.bookmark.getParent().asComponent().remove((BComplex)w.bookmark);
            BNavSideBar.this.getOptions().save();
            BNavSideBar.this.openTrees.getList().removeItem((Object)w);
            BNavSideBar.this.hash.remove(w);
            BNavSideBar.this.openTrees.getList().setSelectedIndex(0);
            BNavSideBar.this.doUpdateTree();
            BookmarkEvents.fireBookmarkChanged();
            return null;
        }
    }

    class SyncTree
    extends Command {
        SyncTree(BWidget owner) {
            super(owner, UiLexicon.bajaui().module, "tree.sync");
        }

        public BImage getIcon() {
            return syncIcon;
        }

        public CommandArtifact doInvoke() {
            BNavSideBar.this.syncTree(true);
            return null;
        }
    }

    class ReorderHosts
    extends Command {
        public ReorderHosts(BWidget owner) {
            super(owner, UiLexicon.bajaui().module, "tree.reorder");
        }

        public BImage getIcon() {
            return reorderIcon;
        }

        public CommandArtifact doInvoke() {
            new ReorderCommand(this.getOwner()).invoke();
            return null;
        }
    }
}

