/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.util.SpyUtil;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.Path;
import javax.baja.naming.ViewQuery;
import javax.baja.sys.Sys;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

public class WbHistory {
    public static final int MAX_HISTORY = 50;
    private Entry[] list = new Entry[50];
    private int count;
    private int current = -1;
    private ArrayList<Entry> recent = new ArrayList();
    private BNiagaraWbShell shell;

    public WbHistory() {
    }

    public WbHistory(BNiagaraWbShell shell) {
        this.shell = shell;
    }

    public Entry append(BOrd ord) {
        Entry entry = new Entry(ord);
        for (int i = this.current + 1; i < this.count; ++i) {
            this.list[i] = null;
        }
        this.count = this.current + 1;
        if (this.count >= this.list.length) {
            this.count = this.list.length;
            System.arraycopy(this.list, 1, this.list, 0, this.count - 1);
            this.list[this.count - 1] = entry;
        } else {
            this.list[this.count++] = entry;
        }
        this.current = this.count - 1;
        this.recentAdd(entry);
        return entry;
    }

    public BOrd back() {
        if (this.current < 1) {
            return null;
        }
        return this.list[--this.current].ord;
    }

    public BOrd forward() {
        if (this.current >= this.count - 1) {
            return null;
        }
        return this.list[++this.current].ord;
    }

    public boolean isBackEnabled() {
        return this.current >= 1;
    }

    public boolean isForwardEnabled() {
        return this.current < this.count - 1;
    }

    public void dump(String msg) {
        System.out.println("WbHistory " + msg);
        for (int i = 0; i < this.count; ++i) {
            String prefix = this.current == i ? "->" : "  ";
            System.out.println(prefix + i + ": " + this.list[i].ord);
        }
    }

    Entry[] getBackHistory() {
        Entry[] temp = new Entry[this.current >= 0 ? this.current : 0];
        for (int i = 0; i < this.current; ++i) {
            temp[this.current - i - 1] = this.list[i];
        }
        return temp;
    }

    Entry[] getForwardHistory() {
        Entry[] temp = new Entry[this.count - this.current - 1];
        for (int i = 0; i < this.count - this.current - 1; ++i) {
            temp[i] = this.list[this.current + i + 1];
        }
        return temp;
    }

    Entry getCurrent() {
        return this.list[this.current];
    }

    public int recentIndexOf(BOrd ord) {
        for (int i = 0; i < this.recent.size(); ++i) {
            if (!ord.equals((Object)this.recent.get((int)i).ord)) continue;
            return i;
        }
        return -1;
    }

    public void recentAdd(Entry entry) {
        int index = this.recentIndexOf(entry.ord);
        if (index < 0) {
            if (this.recent.size() >= 50) {
                this.recent.remove(this.recent.size() - 1);
            }
        } else {
            this.recent.remove(index);
        }
        this.recent.add(0, entry);
    }

    public void recentTouch(BOrd ord) {
        int index = this.recentIndexOf(ord);
        if (index >= 0) {
            Entry entry = this.recent.get(index);
            this.recent.remove(index);
            this.recent.add(0, entry);
        }
    }

    public Entry[] recentList() {
        return this.recent.toArray(new Entry[this.recent.size()]);
    }

    public void load() {
        AccessController.doPrivileged(new LoadPrivilegedAction());
    }

    public void save() {
        AccessController.doPrivileged(new SavePrivilegedAction());
    }

    public static String toName(BOrd ord) {
        if (ord == null) {
            return "null";
        }
        try {
            OrdQuery[] q = ord.parse();
            int len = q.length;
            int lastIndex = len - 1;
            OrdQuery last = q[lastIndex];
            String view = null;
            if (last instanceof ViewQuery && len >= 2) {
                String viewId = ((ViewQuery)last).getViewId();
                if (viewId != null) {
                    int colon = viewId.indexOf(58);
                    view = colon > 0 ? viewId.substring(colon + 1) : viewId;
                }
                last = q[--lastIndex];
            }
            String name = null;
            if (last.isSession()) {
                name = BOrd.make((OrdQuery[])q, (int)0, (int)(lastIndex + 1)).toString();
            } else if (last instanceof Path) {
                Path path = (Path)last;
                name = path.depth() == 0 ? BOrd.make((OrdQuery[])q, (int)Math.max(0, lastIndex - 2), (int)(lastIndex + 1)).toString() : path.nameAt(path.depth() - 1);
            }
            if (name == null) {
                name = last.toString();
            }
            if (view != null) {
                name = name + " [" + view + "]";
            }
            return name;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ord.toString();
        }
    }

    public static class Entry {
        public String name;
        public BOrd ord;
        public BImage icon;
        public BOrd ordNoView;
        public String viewId;

        public Entry(String name, BOrd ord, BImage icon) {
            ord = SpyUtil.stripAuthorization((BOrd)ord);
            this.name = name;
            this.ord = ord;
            this.icon = icon;
        }

        public Entry(BOrd ord) {
            ord = SpyUtil.stripAuthorization((BOrd)ord);
            this.name = WbHistory.toName(ord);
            this.ord = ord;
        }
    }

    private class SavePrivilegedAction
    implements PrivilegedAction<Void> {
        private SavePrivilegedAction() {
        }

        @Override
        public Void run() {
            try {
                File file = new File(Sys.getNiagaraUserHome(), "etc" + File.separator + "recentOrds.xml");
                XWriter out = new XWriter(file);
                out.prolog();
                out.w((Object)"<recentOrds>\n");
                for (int i = 0; i < WbHistory.this.recent.size(); ++i) {
                    Entry e = (Entry)WbHistory.this.recent.get(i);
                    out.w((Object)"  <entry").attr(" name", e.name).attr(" ord", "" + e.ord);
                    if (e.icon != null) {
                        out.attr(" icon", e.icon.encodeToString());
                    }
                    out.w((Object)"/>\n");
                }
                out.w((Object)"</recentOrds>\n");
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private class LoadPrivilegedAction
    implements PrivilegedAction<Void> {
        private LoadPrivilegedAction() {
        }

        @Override
        public Void run() {
            try {
                File file = new File(Sys.getNiagaraUserHome(), "etc" + File.separator + "recentOrds.xml");
                if (!file.exists()) {
                    return null;
                }
                XElem root = XParser.make((File)file).parse();
                XElem[] xEntries = root.elems("entry");
                for (int i = 0; i < xEntries.length; ++i) {
                    XElem x = xEntries[i];
                    String name = x.get("name");
                    BOrd ord = BOrd.make((String)x.get("ord"));
                    BImage icon = null;
                    String iconStr = x.get("icon", null);
                    if (iconStr != null) {
                        icon = BImage.make((String)iconStr);
                    }
                    WbHistory.this.recent.add(new Entry(name, ord, icon));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

