/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.nre.RunnableWithException;
import com.tridium.nre.security.CryptoProvider;
import com.tridium.nre.security.EncryptionKeySource;
import com.tridium.nre.security.PasswordStrength;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.nre.security.io.BogPasswordObjectEncoder;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.baja.gx.BBrush;
import javax.baja.security.BPassword;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.util.UiLexicon;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;

class WbBogFilePassPhraseUtil {
    private static final UiLexicon LEXICON = UiLexicon.makeUiLexicon(WbBogFilePassPhraseUtil.class);
    private BogFileLockState lockState;
    private final BDialog dialog;
    private final BBogFile bogFile;
    private final BPasswordFE passPhraseFE;
    private final BLabel passPhraseLabel;
    private final BPasswordFE passPhraseConfirmFE;
    private final BLabel passPhraseConfirmLabel;
    private final BEdgePane statusLabelPane;
    private final BLabel headerLabel;
    private final ToggleCommandGroup<TransitionCommand> transitionCommands = new ToggleCommandGroup();
    private final Map<BogFileLockState, Set<ToggleCommand>> enabledTransitionsByState = new HashMap<BogFileLockState, Set<ToggleCommand>>();

    public static void openDialog(BWidget owner, BBogFile bogFile, RunnableWithException<Exception> bogFileDetailsChanged) throws Exception {
        new WbBogFilePassPhraseUtil(owner, bogFile, bogFileDetailsChanged).open();
    }

    private WbBogFilePassPhraseUtil(BWidget owner, BBogFile bogFile, RunnableWithException<Exception> bogFileDetailsChanged) throws Exception {
        BEdgePane outerEdge = new BEdgePane();
        this.headerLabel = new BLabel("", BHalign.left);
        this.passPhraseLabel = this.passPhraseLabel("WbBogFilePassPhraseUtil.passPhrase1.label");
        this.passPhraseFE = new BPasswordFE();
        this.passPhraseConfirmLabel = this.passPhraseLabel("WbBogFilePassPhraseUtil.passPhrase2.label");
        this.passPhraseConfirmFE = new BPasswordFE();
        BGridPane passPhraseGrid = new BGridPane(2);
        passPhraseGrid.setHalign(BHalign.left);
        passPhraseGrid.setValign(BValign.top);
        passPhraseGrid.add(null, (BValue)this.passPhraseLabel);
        passPhraseGrid.add(null, (BValue)this.passPhraseFE);
        passPhraseGrid.add(null, (BValue)this.passPhraseConfirmLabel);
        passPhraseGrid.add(null, (BValue)this.passPhraseConfirmFE);
        this.statusLabelPane = new BEdgePane();
        EnterPassPhraseCommand enterPassPhraseCommand = new EnterPassPhraseCommand(owner);
        this.transitionCommands.add((ToggleCommand)enterPassPhraseCommand);
        AddPassPhraseCommand addPassPhraseCommand = new AddPassPhraseCommand(owner);
        this.transitionCommands.add((ToggleCommand)addPassPhraseCommand);
        ChangePassPhraseCommand changePassPhraseCommand = new ChangePassPhraseCommand(owner);
        this.transitionCommands.add((ToggleCommand)changePassPhraseCommand);
        ForceChangePassPhraseCommand forceChangePassPhraseCommand = new ForceChangePassPhraseCommand(owner);
        this.transitionCommands.add((ToggleCommand)forceChangePassPhraseCommand);
        ForceRemovePassPhraseCommand forceRemovePassPhraseCommand = new ForceRemovePassPhraseCommand(owner);
        this.transitionCommands.add((ToggleCommand)forceRemovePassPhraseCommand);
        this.enabledTransitionsByState.put(BogFileLockState.keyring, new HashSet<ForceRemovePassPhraseCommand>(Collections.singletonList(forceRemovePassPhraseCommand)));
        this.enabledTransitionsByState.put(BogFileLockState.none, new HashSet<AddPassPhraseCommand>(Collections.singletonList(addPassPhraseCommand)));
        this.enabledTransitionsByState.put(BogFileLockState.externalLocked, new HashSet<TransitionCommand>(Arrays.asList(new TransitionCommand[]{enterPassPhraseCommand, forceChangePassPhraseCommand, forceRemovePassPhraseCommand})));
        this.enabledTransitionsByState.put(BogFileLockState.externalUnlocked, new HashSet<TransitionCommand>(Arrays.asList(new TransitionCommand[]{changePassPhraseCommand, forceRemovePassPhraseCommand})));
        BogPasswordObjectEncoder encoder = bogFile.getBogSpace().getBogPasswordObjectEncoder();
        this.lockState = encoder.getKeySource().equals((Object)EncryptionKeySource.keyring) ? BogFileLockState.keyring : (encoder.getKeySource().equals((Object)EncryptionKeySource.none) ? BogFileLockState.none : (bogFile.isReversibleEncryptionPassPhraseAvailable() ? BogFileLockState.externalUnlocked : BogFileLockState.externalLocked));
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setHalign(BHalign.center);
        buttonPane.setUniformColumnWidth(true);
        buttonPane.add(null, (BValue)new BButton((Command)new UpdateCommand(owner, bogFileDetailsChanged)));
        buttonPane.add(null, (BValue)new BButton((Command)new CloseCommand(owner)));
        outerEdge.setBottom((BWidget)buttonPane);
        BGridPane centerGrid = new BGridPane(1);
        centerGrid.setHalign(BHalign.left);
        centerGrid.setValign(BValign.top);
        centerGrid.add(null, (BValue)this.headerLabel);
        centerGrid.add(null, (BValue)this.verticalSpacer());
        centerGrid.add(null, (BValue)new BLabel(LEXICON.getText("WbBogFilePassPhraseUtil.dialogHeader.prompt"), BHalign.left));
        centerGrid.add(null, (BValue)this.verticalSpacer());
        BGridPane radiosAndFieldEditors = new BGridPane(2);
        radiosAndFieldEditors.setHalign(BHalign.left);
        radiosAndFieldEditors.setValign(BValign.top);
        radiosAndFieldEditors.setRowAlign(BValign.top);
        centerGrid.add(null, (BValue)radiosAndFieldEditors);
        BGridPane radios = new BGridPane(1);
        radios.setHalign(BHalign.left);
        radios.setValign(BValign.top);
        radios.setRowAlign(BValign.top);
        radiosAndFieldEditors.add(null, (BValue)radios);
        this.transitionCommands.forEach(command -> radios.add(null, (BValue)new BRadioButton((ToggleCommand)command)));
        BGridPane fieldEditors = new BGridPane(1);
        fieldEditors.setHalign(BHalign.left);
        fieldEditors.setValign(BValign.top);
        fieldEditors.setRowAlign(BValign.top);
        radiosAndFieldEditors.add(null, (BValue)fieldEditors);
        fieldEditors.add(null, (BValue)passPhraseGrid);
        fieldEditors.add(null, (BValue)this.verticalSpacer());
        fieldEditors.add(null, (BValue)this.statusLabelPane);
        centerGrid.add(null, (BValue)new BLabel(LEXICON.getText("WbBogFilePassPhraseUtil.dialogFooter"), BHalign.center));
        centerGrid.add(null, (BValue)this.verticalSpacer());
        outerEdge.setCenter((BWidget)centerGrid);
        BBorderPane borderPane = new BBorderPane((BWidget)outerEdge, 10.0, 10.0, 10.0, 10.0);
        this.dialog = new BDialog(owner, LEXICON.getText("WbBogFilePassPhraseUtil.dlgTitle"), true, (BWidget)borderPane);
        this.bogFile = bogFile;
        this.updateTransitionCommands(true);
        this.dialog.setBoundsCenteredOnOwner();
    }

    private BWidget verticalSpacer() {
        BConstrainedPane spacer = new BConstrainedPane();
        spacer.setMinHeight(5.0);
        return spacer;
    }

    private void open() {
        this.dialog.open();
    }

    private BLabel passPhraseLabel(String lexKey) {
        return this.setLabelEnabled(new BLabel(LEXICON.getText(lexKey)), true);
    }

    private BLabel setLabelEnabled(BLabel label, boolean value) {
        BBrush labelBrush = value ? Theme.label().getTextBrush() : Theme.label().getTextDisabled();
        label.setForeground(labelBrush);
        return label;
    }

    private void updateStatus(String message, boolean isError) {
        if (this.statusLabelPane != null) {
            BLabel statusLabel = new BLabel(message, BHalign.left);
            StyleUtils.addStyleClass((IStylable)statusLabel, (String)(isError ? "error" : "message"));
            this.statusLabelPane.setCenter((BWidget)statusLabel);
            if (this.dialog != null) {
                this.dialog.setScreenSizeToPreferredSize();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTransitionCommands(boolean updateSelection) {
        block5: {
            this.headerLabel.setText(LEXICON.getText("WbBogFilePassPhraseUtil.dialogHeader." + this.lockState.name()));
            Set<ToggleCommand> enabledCommands = this.enabledTransitionsByState.get((Object)this.lockState);
            this.transitionCommands.forEach(command -> command.setEnabled(enabledCommands.contains(command)));
            try {
                if (!updateSelection) break block5;
                for (ToggleCommand command2 : this.transitionCommands) {
                    if (!command2.isEnabled()) continue;
                    command2.setSelected(true);
                    return;
                }
            }
            finally {
                this.headerLabel.relayoutSync();
                this.dialog.setScreenSizeToPreferredSize();
            }
        }
    }

    private BPassword validPassPhrase() {
        try {
            return this.validPassPhrase((BPassword)this.passPhraseFE.saveValue());
        }
        catch (Exception e) {
            this.updateStatus(e.getLocalizedMessage(), true);
            return null;
        }
    }

    private BPassword validPassPhrase(BPassword password) {
        try {
            if (this.passwordIsEmpty(password)) {
                this.updateStatus(LEXICON.getText("WbBogFilePassPhraseUtil.password.missing"), true);
                return null;
            }
            BPasswordStrength.DEFAULT.isPasswordValid(AccessController.doPrivileged(() -> ((BPassword)password).getValue()));
            this.updateStatus("", false);
            return password;
        }
        catch (Exception e) {
            this.updateStatus(e.getLocalizedMessage(), true);
            return null;
        }
    }

    private BPassword validMatchingPassPhrases() {
        try {
            BPassword result = this.validPassPhrase((BPassword)this.passPhraseFE.saveValue());
            if (!this.passwordIsEmpty(result)) {
                BPassword confirm = (BPassword)this.passPhraseConfirmFE.saveValue();
                if (this.passwordIsEmpty(confirm)) {
                    this.updateStatus(LEXICON.getText("WbBogFilePassPhraseUtil.passwordConfirm.missing"), true);
                } else {
                    if (AccessController.doPrivileged(() -> ((BPassword)result).getValue()).equals(AccessController.doPrivileged(() -> ((BPassword)confirm).getValue()))) {
                        this.updateStatus("", false);
                        return result;
                    }
                    this.updateStatus(LEXICON.getText("WbBogFilePassPhraseUtil.passwordConfirm.mismatch"), true);
                }
            }
        }
        catch (Exception e) {
            this.updateStatus(e.getLocalizedMessage(), true);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean passwordIsEmpty(BPassword value) {
        if (value == null) return true;
        if (value.isDefault()) return true;
        if (!AccessController.doPrivileged(() -> ((BPassword)value).getValue()).isEmpty()) return false;
        return true;
    }

    private void resetPassPhraseFieldEditors() {
        this.passPhraseFE.loadValue((BObject)BPassword.DEFAULT);
        this.passPhraseFE.clearModified();
        this.passPhraseConfirmFE.loadValue((BObject)BPassword.DEFAULT);
        this.passPhraseConfirmFE.clearModified();
    }

    private void configurePassPhraseFieldEditors(boolean usePassPhrase, boolean useConfirmPassPhrase) {
        this.passPhraseFE.setVisible(usePassPhrase);
        this.passPhraseLabel.setVisible(usePassPhrase);
        this.passPhraseConfirmFE.setVisible(useConfirmPassPhrase);
        this.passPhraseConfirmLabel.setVisible(useConfirmPassPhrase);
        this.passPhraseFE.requestFocus();
        if (this.passPhraseFE.getParentWidget() != null) {
            this.passPhraseFE.getParentWidget().relayoutSync();
        }
        if (this.dialog != null) {
            this.dialog.setScreenSizeToPreferredSize();
        }
    }

    private static enum BogFileLockState {
        keyring,
        none,
        externalLocked,
        externalUnlocked;

    }

    private class ChangePassPhraseCommand
    extends TransitionCommand {
        public ChangePassPhraseCommand(BWidget owner) {
            super(owner, "WbBogFilePassPhraseUtil.changePassPhrase");
        }

        @Override
        public void transition() throws Exception {
            BPassword passPhrase = WbBogFilePassPhraseUtil.this.validMatchingPassPhrases();
            if (passPhrase != null) {
                WbBogFilePassPhraseUtil.this.bogFile.updateReversibleEncryptionPassPhrase(passPhrase);
                WbBogFilePassPhraseUtil.this.lockState = BogFileLockState.externalUnlocked;
                WbBogFilePassPhraseUtil.this.updateStatus(LEXICON.getText("WbBogFilePassPhraseUtil.changePassPhrase.success"), false);
                super.transition();
            }
        }

        @Override
        public synchronized void setSelected(boolean selected) {
            if (selected) {
                WbBogFilePassPhraseUtil.this.configurePassPhraseFieldEditors(true, true);
            }
            super.setSelected(selected);
        }
    }

    private class EnterPassPhraseCommand
    extends TransitionCommand {
        public EnterPassPhraseCommand(BWidget owner) {
            super(owner, "WbBogFilePassPhraseUtil.enterPassPhrase");
        }

        @Override
        public void transition() throws Exception {
            BPassword passPhrase = (BPassword)WbBogFilePassPhraseUtil.this.passPhraseFE.saveValue();
            try {
                WbBogFilePassPhraseUtil.this.bogFile.setReversibleEncryptionPassPhrase(passPhrase);
                WbBogFilePassPhraseUtil.this.lockState = BogFileLockState.externalUnlocked;
                WbBogFilePassPhraseUtil.this.updateStatus(LEXICON.getText("WbBogFilePassPhraseUtil.enterPassPhrase.success"), false);
                super.transition();
            }
            catch (AssertionError e) {
                if (CryptoProvider.CryptoError.FIPS_PASSWORD_LENGTH == SecurityInitializer.getInstance().getCryptoProvider().parseThrowable((Throwable)((Object)e))) {
                    WbBogFilePassPhraseUtil.this.updateStatus(LEXICON.getText("WbBogFilePassPhraseUtil.password.fipsInvalid", new Object[]{PasswordStrength.MINIMUM_ALLOWED_LENGTH}), true);
                }
                throw e;
            }
            catch (Exception e) {
                WbBogFilePassPhraseUtil.this.updateStatus(LEXICON.getText("WbBogFilePassPhraseUtil.password.incorrect"), true);
            }
        }

        @Override
        public synchronized void setSelected(boolean selected) {
            if (selected) {
                WbBogFilePassPhraseUtil.this.configurePassPhraseFieldEditors(true, false);
            }
            super.setSelected(selected);
        }
    }

    private class ForceRemovePassPhraseCommand
    extends TransitionCommand {
        public ForceRemovePassPhraseCommand(BWidget owner) {
            super(owner, "WbBogFilePassPhraseUtil.forceRemovePassPhrase");
        }

        @Override
        public void transition() throws Exception {
            boolean wasKeyring = WbBogFilePassPhraseUtil.this.lockState.equals((Object)BogFileLockState.keyring);
            WbBogFilePassPhraseUtil.this.bogFile.forceClearReversibleEncryptionPassPhrase();
            WbBogFilePassPhraseUtil.this.lockState = BogFileLockState.none;
            if (wasKeyring) {
                WbBogFilePassPhraseUtil.this.updateStatus(LEXICON.getText("WbBogFilePassPhraseUtil.forceRemovePassPhrase.success.keyring"), false);
            } else {
                WbBogFilePassPhraseUtil.this.updateStatus(LEXICON.getText("WbBogFilePassPhraseUtil.forceRemovePassPhrase.success"), false);
            }
            super.transition();
        }

        @Override
        public synchronized void setSelected(boolean selected) {
            if (selected) {
                WbBogFilePassPhraseUtil.this.configurePassPhraseFieldEditors(false, false);
            }
            super.setSelected(selected);
        }
    }

    private class ForceChangePassPhraseCommand
    extends TransitionCommand {
        public ForceChangePassPhraseCommand(BWidget owner) {
            super(owner, "WbBogFilePassPhraseUtil.forceChangePassPhrase");
        }

        @Override
        public void transition() throws Exception {
            BPassword newPassPhrase = WbBogFilePassPhraseUtil.this.validMatchingPassPhrases();
            if (newPassPhrase != null) {
                WbBogFilePassPhraseUtil.this.bogFile.forceChangeReversibleEncryptionPassPhrase(newPassPhrase);
                WbBogFilePassPhraseUtil.this.lockState = BogFileLockState.externalUnlocked;
                WbBogFilePassPhraseUtil.this.updateStatus(LEXICON.getText("WbBogFilePassPhraseUtil.forceChangePassPhrase.success"), false);
                super.transition();
            }
        }

        @Override
        public synchronized void setSelected(boolean selected) {
            if (selected) {
                WbBogFilePassPhraseUtil.this.configurePassPhraseFieldEditors(true, true);
            }
            super.setSelected(selected);
        }
    }

    private class AddPassPhraseCommand
    extends TransitionCommand {
        public AddPassPhraseCommand(BWidget owner) {
            super(owner, "WbBogFilePassPhraseUtil.addPassPhrase");
        }

        @Override
        public void transition() throws Exception {
            BPassword passPhrase = WbBogFilePassPhraseUtil.this.validMatchingPassPhrases();
            if (passPhrase != null) {
                WbBogFilePassPhraseUtil.this.bogFile.updateReversibleEncryptionPassPhrase(passPhrase);
                WbBogFilePassPhraseUtil.this.lockState = BogFileLockState.externalUnlocked;
                WbBogFilePassPhraseUtil.this.updateStatus(LEXICON.getText("WbBogFilePassPhraseUtil.addPassPhrase.success"), false);
                super.transition();
            }
        }

        @Override
        public synchronized void setSelected(boolean selected) {
            if (selected) {
                WbBogFilePassPhraseUtil.this.configurePassPhraseFieldEditors(true, true);
            }
            super.setSelected(selected);
        }
    }

    private abstract class TransitionCommand
    extends ToggleCommand {
        protected TransitionCommand(BWidget owner, String keyBase) {
            super(owner, (Lexicon)LEXICON, keyBase);
        }

        public void transition() throws Exception {
            WbBogFilePassPhraseUtil.this.updateTransitionCommands(true);
        }

        public CommandArtifact doInvoke() throws Exception {
            WbBogFilePassPhraseUtil.this.updateStatus("", false);
            return super.doInvoke();
        }

        public synchronized void setSelected(boolean selected) {
            if (selected && !this.isSelected()) {
                WbBogFilePassPhraseUtil.this.resetPassPhraseFieldEditors();
            }
            super.setSelected(selected);
        }

        public int hashCode() {
            return this.getKeyBase().hashCode();
        }
    }

    private class CloseCommand
    extends Command {
        public CloseCommand(BWidget owner) {
            super(owner, LEXICON.getText("WbBogFilePassPhraseUtil.close"));
        }

        public CommandArtifact doInvoke() throws Exception {
            WbBogFilePassPhraseUtil.this.dialog.close();
            return null;
        }
    }

    private class UpdateCommand
    extends Command {
        private final RunnableWithException<Exception> update;

        public UpdateCommand(BWidget owner, RunnableWithException<Exception> bogFileDetailsChanged) {
            super(owner, LEXICON.getText("WbBogFilePassPhraseUtil.update"));
            this.update = bogFileDetailsChanged;
        }

        public CommandArtifact doInvoke() {
            try {
                ((TransitionCommand)WbBogFilePassPhraseUtil.this.transitionCommands.getSelected()).transition();
                this.update.run();
            }
            catch (CannotSaveException cse) {
                cse.printStackTrace();
                WbBogFilePassPhraseUtil.this.updateStatus(cse.toString(null), true);
            }
            catch (Exception e) {
                e.printStackTrace();
                WbBogFilePassPhraseUtil.this.updateStatus(e.getLocalizedMessage(), true);
            }
            return null;
        }
    }
}

