/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import java.applet.Applet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import netscape.javascript.JSObject;

public abstract class RemoteShellContainer {
    public abstract boolean isActive();

    public abstract URL getCodeBase();

    public abstract URL getDocumentBase();

    public abstract String getParameter(String var1);

    public abstract void showStatus(String var1);

    public abstract void showDocument(URL var1);

    public abstract void showDocument(URL var1, String var2);

    public abstract Applet getApplet();

    public abstract void executeJs(String var1);

    public static RemoteShellContainer makeForApplet(Applet applet) {
        return new AppletWrapper(applet);
    }

    public static RemoteShellContainer makeForWebStart(Object panel) throws Exception {
        return new WebStartReflectionWrapper(panel);
    }

    private static class WebStartReflectionWrapper
    extends RemoteShellContainer {
        private Method isActive;
        private Method getCodeBase;
        private Method getDocumentBase;
        private Method getParameter;
        private Method showStatus;
        private Method showDocumentU;
        private Method showDocumentUS;
        private Method executeJs;
        private Object container;

        WebStartReflectionWrapper(Object container) throws Exception {
            this.container = container;
            Class<?> cls = container.getClass();
            this.isActive = cls.getMethod("isActive", new Class[0]);
            this.getCodeBase = cls.getMethod("getCodeBase", new Class[0]);
            this.getDocumentBase = cls.getMethod("getDocumentBase", new Class[0]);
            this.getParameter = cls.getMethod("getParameter", String.class);
            this.showStatus = cls.getMethod("showStatus", String.class);
            this.showDocumentU = cls.getMethod("showDocument", URL.class);
            this.showDocumentUS = cls.getMethod("showDocument", URL.class, String.class);
            this.executeJs = cls.getMethod("executeJs", String.class);
        }

        @Override
        public boolean isActive() {
            try {
                return (Boolean)this.isActive.invoke(this.container, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.err(e);
                return false;
            }
        }

        @Override
        public URL getCodeBase() {
            try {
                return (URL)this.getCodeBase.invoke(this.container, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.err(e);
                return null;
            }
        }

        @Override
        public URL getDocumentBase() {
            try {
                return (URL)this.getDocumentBase.invoke(this.container, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.err(e);
                return null;
            }
        }

        @Override
        public String getParameter(String name) {
            try {
                return (String)this.getParameter.invoke(this.container, name);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.err(e);
                return null;
            }
        }

        @Override
        public void showStatus(String msg) {
            try {
                this.showStatus.invoke(this.container, msg);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.err(e);
            }
        }

        @Override
        public void showDocument(URL url) {
            try {
                this.showDocumentU.invoke(this.container, url);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.err(e);
            }
        }

        @Override
        public void showDocument(URL url, String target) {
            try {
                this.showDocumentUS.invoke(this.container, url, target);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.err(e);
            }
        }

        @Override
        public Applet getApplet() {
            return null;
        }

        @Override
        public void executeJs(String js) {
            try {
                this.executeJs.invoke(this.container, js);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.err(e);
            }
        }

        private void err(Exception e) {
            e.printStackTrace();
        }
    }

    private static class AppletWrapper
    extends RemoteShellContainer {
        private Applet applet;

        AppletWrapper(Applet applet) {
            this.applet = applet;
        }

        @Override
        public boolean isActive() {
            return this.applet.isActive();
        }

        @Override
        public URL getCodeBase() {
            return this.applet.getCodeBase();
        }

        @Override
        public URL getDocumentBase() {
            return this.applet.getDocumentBase();
        }

        @Override
        public String getParameter(String name) {
            return this.applet.getParameter(name);
        }

        @Override
        public void showStatus(String msg) {
            this.applet.getAppletContext().showStatus(msg);
        }

        @Override
        public void showDocument(URL url) {
            this.applet.getAppletContext().showDocument(url);
        }

        @Override
        public void showDocument(URL url, String target) {
            this.applet.getAppletContext().showDocument(url);
        }

        @Override
        public Applet getApplet() {
            return this.applet;
        }

        @Override
        public void executeJs(String js) {
            try {
                Method getWindow = JSObject.class.getMethod("getWindow", Applet.class);
                JSObject window = (JSObject)getWindow.invoke(null, this.applet);
                window.eval(js);
            }
            catch (Exception e) {
                System.err.println("ERROR: could not run JS");
                e.printStackTrace();
            }
        }
    }
}

