/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.ui.fx.BFxContentPane;
import com.tridium.ui.theme.JavaFxTheme;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.workbench.console.BConsole;
import com.tridium.workbench.shell.BNiagaraWbLocatorBar;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BScrollingToolbarPane;
import com.tridium.workbench.shell.BSideBarPane;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.shell.BViewTabbedPane;
import javax.baja.gx.BBrush;
import javax.baja.gx.BInsets;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BBorder;
import javax.baja.ui.BMenuBar;
import javax.baja.ui.BMenuItem;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.menu.BIMenuBar;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.toolbar.BIToolBar;
import javax.baja.workbench.BWbLocatorBar;
import javax.baja.workbench.BWbProfile;
import javax.baja.workbench.BWbStatusBar;
import javax.baja.workbench.sidebar.BIWbSideBar;
import javax.baja.workbench.view.BWbView;

public class BWbPane
extends BEdgePane {
    public static final Type TYPE = Sys.loadType(BWbPane.class);
    private static final String[] noMenus = new String[0];
    final BNiagaraWbShell shell;
    final BWbProfile profile;
    private BIMenuBar menuBar;
    private String[] mergedMenus = noMenus;
    private BIToolBar toolBar;
    private BScrollingToolbarPane toolBarPane;
    private Property mergedToolBar;
    private BWbLocatorBar locatorBar;
    BViewTabbedPane views;
    BSideBarPane sideBar;
    BBorderPane sideBarBp;
    BConsole console;
    private BSplitPane hSplitPane;
    private BSplitPane vSplitPane;
    private BBorderPane hSplitPaneBp;
    private BFxContentPane content;
    private BWbStatusBar statusBar;

    public Type getType() {
        return TYPE;
    }

    public BWbPane() {
        throw new IllegalStateException();
    }

    public BWbPane(BNiagaraWbShell shell) {
        this.shell = shell;
        this.profile = shell.profile;
        this.setTop((BWidget)new BEdgePane());
        this.buildMenuBar();
        this.buildToolBar();
        this.buildLocatorBar();
        this.buildContent();
        this.buildStatusBar();
    }

    public String getStyleId() {
        return "main-background-pane";
    }

    public void update(BViewTab tab) {
        try {
            this.updateMenuBar(tab);
            this.updateQuickSearch(tab);
            this.updateToolBar(tab);
            this.updateLocatorBar(tab);
            this.updateSideBars(tab);
            this.updateStatusBar(tab);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean hasMenu(String menuPath) {
        if (this.menuBar == null) {
            return false;
        }
        String[] names = TextUtil.split((String)menuPath, (char)'|');
        BWidget p = this.menuBar.asWidget();
        for (String name : names) {
            BComponent c = (BComponent)p.get(name);
            if (c instanceof BSubMenuItem) {
                c = ((BSubMenuItem)c).getMenu();
            }
            if (c == null) {
                return false;
            }
            p = c;
        }
        return true;
    }

    BWidget getMenuBar() {
        return this.menuBar.asWidget();
    }

    private void buildMenuBar() {
        BIMenu[] menus;
        this.menuBar = this.profile.makeMenuBar();
        if (this.menuBar == null) {
            return;
        }
        for (BIMenu menu : menus = this.menuBar.getMenus()) {
            menu.removeConsecutiveSeparators();
        }
        BEdgePane pane = new BEdgePane();
        pane.setCenter(this.menuBar.asWidget());
        BEdgePane top = (BEdgePane)this.getTop();
        top.setTop((BWidget)pane);
    }

    private void updateMenuBar(BViewTab tab) {
        if (this.menuBar == null) {
            return;
        }
        for (String menuName : this.mergedMenus) {
            BWbPane.unregisterFromCommands(this.menuBar.removeMenu(menuName).asWidget());
        }
        this.mergedMenus = noMenus;
        BIMenu[] menus = null;
        try {
            if (tab.view != null) {
                menus = tab.view.getViewMenus();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (menus == null) {
            this.mergedMenus = noMenus;
        } else {
            BIMenu help = this.menuBar.removeMenu("help");
            this.mergedMenus = new String[menus.length];
            for (int i = 0; i < menus.length; ++i) {
                String menuName;
                this.mergedMenus[i] = menuName = "merge" + i;
                this.menuBar.addMenu(this.mergedMenus[i], menus[i]);
            }
            if (help != null) {
                this.menuBar.addMenu("help", help);
            }
        }
    }

    private void updateQuickSearch(BViewTab tab) {
        if (this.shell.isAppletOrWebStart() || this.menuBar == null) {
            return;
        }
        BWidget quickSearch = null;
        BWbView view = tab.view;
        try {
            if (tab.view != null) {
                quickSearch = this.profile.getQuickSearch(view);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (quickSearch == null) {
            try {
                this.menuBar.removeQuickSearch();
            }
            catch (UnsupportedOperationException e) {
                quickSearch = new BNullWidget();
                this.updateQuickSearchInPane(quickSearch);
            }
        } else {
            try {
                this.menuBar.addQuickSearch(quickSearch);
            }
            catch (UnsupportedOperationException e) {
                this.updateQuickSearchInPane(quickSearch);
            }
        }
    }

    private void updateQuickSearchInPane(BWidget quickSearch) {
        BEdgePane top = (BEdgePane)((BEdgePane)this.getTop()).getTop();
        BWidget right = top.getRight();
        if (!(quickSearch == right || right.isNull() && quickSearch.isNull())) {
            top.setRight(quickSearch);
        }
    }

    private void buildToolBar() {
        this.toolBar = this.profile.makeToolBar();
        if (this.toolBar == null) {
            return;
        }
        this.toolBar.removeConsecutiveSeparators();
        BEdgePane pane = new BEdgePane();
        if (this.toolBar instanceof BToolBar) {
            this.toolBarPane = new BScrollingToolbarPane(10, this.toolBar);
            StyleUtils.addStyleClass((IStylable)pane, (String)"toolbar-container");
            if (this.menuBar instanceof BMenuBar) {
                BSeparator sep = new BSeparator(BOrientation.horizontal);
                sep.setStyleClasses("below-menu-bar");
                pane.setTop((BWidget)sep);
            }
            pane.setCenter((BWidget)this.toolBarPane);
        } else {
            pane.setCenter(this.toolBar.asWidget());
        }
        BEdgePane top = (BEdgePane)this.getTop();
        top.setCenter((BWidget)pane);
    }

    private void updateToolBar(BViewTab tab) {
        if (this.toolBar == null) {
            return;
        }
        BIToolBar viewToolBar = BWbPane.getViewToolBar(tab);
        if (this.mergedToolBar != null) {
            if (this.toolBarPane != null) {
                BWbPane.unregisterFromCommands((BWidget)this.toolBarPane.get(this.mergedToolBar));
                this.toolBarPane.removeMergedToolbar(this.mergedToolBar);
            } else {
                this.toolBar.asWidget().remove(this.mergedToolBar);
            }
            this.mergedToolBar = null;
        }
        if (viewToolBar != null) {
            if (this.toolBarPane != null) {
                this.mergedToolBar = this.toolBarPane.addMergedToolbar(viewToolBar);
                this.toolBarPane.relayout();
            } else {
                this.mergedToolBar = this.toolBar.asWidget().add("merged", (BValue)viewToolBar.asWidget());
            }
        }
        this.shell.commands.export.updateEnabled();
    }

    private static BIToolBar getViewToolBar(BViewTab tab) {
        try {
            if (tab.view != null) {
                return tab.view.getViewToolBar();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void buildLocatorBar() {
        this.locatorBar = this.profile.makeLocatorBar();
        if (this.locatorBar == null) {
            return;
        }
        BBorderPane locatorPane = new BBorderPane((BWidget)this.locatorBar, 3.0, 0.0, 1.0, 0.0);
        locatorPane.setBorder(BBorder.none);
        BEdgePane top = (BEdgePane)this.getTop();
        top.setBottom((BWidget)locatorPane);
    }

    private void updateLocatorBar(BViewTab tab) {
        try {
            if (this.locatorBar == null) {
                return;
            }
            if (this.locatorBar instanceof BNiagaraWbLocatorBar) {
                ((BNiagaraWbLocatorBar)this.locatorBar).update(tab);
            } else {
                this.locatorBar.activeViewChanged();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public double getSplitPosition() {
        return this.hSplitPane.getDividerPosition();
    }

    public void setSplitPosition(double pos) {
        if (this.sideBar != null) {
            this.hSplitPane.setDividerPosition(pos);
        }
    }

    public void setSideBarVisible(boolean visible) {
        if (this.sideBar != null) {
            this.sideBarBp.setVisible(visible);
            JavaFxTheme theme = Theme.javaFx();
            if (theme.isEnabled() && this.hSplitPaneBp != null) {
                double borderRadius = theme.getBorderRadius((IStylable)this);
                this.hSplitPaneBp.setPadding(visible ? BInsets.make((double)0.0, (double)borderRadius, (double)0.0, (double)0.0) : BInsets.make((double)0.0, (double)borderRadius, (double)0.0, (double)borderRadius));
            }
            this.hSplitPane.relayout();
        }
    }

    void setConsoleVisible(boolean visible) {
        if (this.console != null) {
            this.console.setVisible(visible);
            JavaFxTheme theme = Theme.javaFx();
            if (theme.isEnabled() && this.content != null) {
                this.content.setPadding(visible ? BInsets.make((double)0.0, (double)0.0, (double)theme.getBorderRadius((IStylable)this), (double)0.0) : BInsets.DEFAULT);
            }
            this.vSplitPane.relayout();
        }
    }

    private void updateSideBars(BViewTab tab) {
        if (this.sideBar != null) {
            for (BIWbSideBar bar : this.sideBar.list()) {
                try {
                    bar.activeViewChanged();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void buildContent() {
        BSplitPane bSplitPane;
        BFxContentPane widget2;
        JavaFxTheme fxTheme = Theme.javaFx();
        boolean javaFxEnabled = fxTheme.isEnabled();
        double borderRadius = fxTheme.getBorderRadius((IStylable)this);
        this.views = new BViewTabbedPane(this.shell, this);
        this.hSplitPane = new BSplitPane(BOrientation.horizontal, 30.0);
        this.hSplitPane.setDividerWidth(Theme.splitPane().getDividerWidth((IStylable)this.hSplitPane));
        if (this.profile.hasSideBar()) {
            this.sideBar = this.shell.makeSideBar();
            this.sideBar.shell = this.shell;
            this.sideBarBp = new BBorderPane((BWidget)this.sideBar, BInsets.make((double)0.0, (double)0.0, (double)(javaFxEnabled ? borderRadius : 0.0), (double)0.0));
            this.sideBarBp.setVisible(false);
            this.hSplitPane.setWidget1((BWidget)this.sideBarBp);
        } else {
            this.hSplitPane.getWidget1().setVisible(false);
        }
        if (javaFxEnabled) {
            widget2 = new BFxContentPane((BWidget)this.views, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)borderRadius), "view-profile");
        } else {
            BBorderPane borderPane = new BBorderPane((BWidget)this.views, BInsets.DEFAULT);
            borderPane.setStyleId("main-content-view");
            borderPane.setBorder(BBorder.make((BBorder)BBorder.solid, (BBrush)Theme.borderPane().getControlForeground((IStylable)borderPane)));
            borderPane.setFill(Theme.borderPane().getControlBackground((IStylable)borderPane));
            widget2 = borderPane;
        }
        this.hSplitPane.setWidget2((BWidget)widget2);
        this.hSplitPaneBp = new BBorderPane((BWidget)this.hSplitPane, BInsets.make((double)0.0, (double)borderRadius, (double)0.0, (double)borderRadius));
        this.console = new BConsole(this.shell);
        this.console.setVisible(false);
        this.vSplitPane = new BSplitPane(BOrientation.vertical, 85.0);
        StyleUtils.addStyleClass((IStylable)this.vSplitPane, (String)"console-top");
        this.vSplitPane.setDividerWidth(Theme.splitPane().getDividerWidth((IStylable)this.vSplitPane));
        this.vSplitPane.setWidget1((BWidget)this.hSplitPaneBp);
        this.vSplitPane.setWidget2((BWidget)this.console);
        if (javaFxEnabled) {
            this.content = new BFxContentPane((BWidget)this.vSplitPane, "content-profile");
            bSplitPane = this.content;
        } else {
            bSplitPane = this.vSplitPane;
        }
        BSplitPane centerWidget = bSplitPane;
        boolean paddingRequired = this.locatorBar == null;
        centerWidget = paddingRequired ? new BBorderPane((BWidget)centerWidget, BInsets.make((double)borderRadius, (double)0.0, (double)borderRadius, (double)0.0)) : centerWidget;
        this.setCenter((BWidget)centerWidget);
    }

    public void showStatus(String msg) {
        if (this.statusBar == null) {
            return;
        }
        this.statusBar.showStatus(msg);
        this.statusBar.repaint();
    }

    private void buildStatusBar() {
        this.statusBar = this.profile.makeStatusBar();
        if (this.statusBar == null) {
            return;
        }
        this.setBottom((BWidget)this.statusBar);
    }

    private void updateStatusBar(BViewTab tab) {
        if (this.statusBar == null) {
            return;
        }
        BWidget statusBarSupplement = null;
        if (tab.view != null) {
            statusBarSupplement = tab.view.getViewStatusBarSupplement();
        }
        if (statusBarSupplement == null) {
            statusBarSupplement = new BNullWidget();
        }
        this.statusBar.setSupplement(statusBarSupplement);
    }

    static void unregisterFromCommands(BWidget w) {
        if (w instanceof BAbstractButton) {
            ((BAbstractButton)w).setCommand(null, false, false);
        } else if (w instanceof BMenuItem) {
            ((BMenuItem)w).setCommand(null);
        }
        for (BWidget kid : w.getChildWidgets()) {
            BWbPane.unregisterFromCommands(kid);
        }
    }

    public BSideBarPane getSideBar() {
        return this.sideBar;
    }
}

