/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.fox.session.MulticastServer;
import com.tridium.fox.sys.BLearnStation;
import com.tridium.fox.sys.Learn;
import com.tridium.ui.BOptionDialog;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.SortUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BProgressBar;
import javax.baja.ui.BRadioButtonMenuItem;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

public class BStationFinder
extends BEdgePane
implements Runnable,
MulticastServer.RollcallCallback {
    public static final Type TYPE = Sys.loadType(BStationFinder.class);
    static BImage findIcon = BImage.make((String)"module://icons/x32/magnifyingGlass.png");
    static BImage foxIcon = BImage.make((String)"module://icons/x16/fox.png");
    static BImage foxsIcon = BImage.make((BIcon)BIcon.make((BIcon)BIcon.std((String)"fox.png"), (BIcon)BIcon.std((String)"badges/lock.png")));
    static boolean lastUseHostName = true;
    static TypeInfo niagaraStationTypeInfo;
    static TypeInfo niagaraEdgeLiteTypeInfo;
    static Lexicon lex;
    static Lexicon bajaLex;
    BProgressBar progressBar;
    BTable table;
    Column[] cols;
    Row[] rows = new Row[0];
    BOrd result;
    boolean firstPaint = true;
    BButton ok;
    ToggleCommand useHostName = new ToggleCommand((BWidget)this, "Use Host Name");
    ToggleCommand useHostAddress = new ToggleCommand((BWidget)this, "Use Host Address");

    public Type getType() {
        return TYPE;
    }

    public BStationFinder() {
        Property[] props = new BLearnStation().getPropertiesArray();
        this.cols = new Column[props.length];
        for (int i = 0; i < this.cols.length; ++i) {
            this.cols[i] = new Column(props[i]);
        }
        DynamicTableModel model = new DynamicTableModel((TableModel)new Model());
        this.table = new BTable((TableModel)model, (TableController)new Controller());
        this.table.setSelection((TableSelection)new Selection());
        this.table.setMultipleSelection(false);
        for (int i = 0; i < this.cols.length; ++i) {
            model.setShowColumn(i, (this.cols[i].prop.getDefaultFlags() & 8) != 0);
        }
        BLabel label = new BLabel(findIcon, lex.getText("findStations.learning"));
        label.setFont(Theme.widget().getBoldText());
        this.progressBar = new BProgressBar();
        BGridPane p = new BGridPane(1);
        p.add(null, (BValue)label);
        p.add(null, (BValue)this.progressBar);
        this.setCenter((BWidget)new BBorderPane((BWidget)p, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        boolean lastUseHostName = BStationFinder.lastUseHostName;
        HostToggle toggleGroup = new HostToggle();
        toggleGroup.add(this.useHostName);
        toggleGroup.add(this.useHostAddress);
        if (lastUseHostName) {
            this.useHostName.setSelected(true);
        } else {
            this.useHostAddress.setSelected(true);
        }
    }

    public void paint(Graphics g) {
        if (this.firstPaint) {
            BOptionDialog dialog = (BOptionDialog)this.getShell();
            this.ok = dialog.getOkButton();
            this.ok.setEnabled(false);
            this.firstPaint = false;
            this.learn();
        }
        super.paint(g);
    }

    public void learn() {
        new Thread((Runnable)this, "Ui:FindStations").start();
    }

    public void completed(int percent) {
        if (this.progressBar != null) {
            this.progressBar.setValue((double)percent);
        }
    }

    @Override
    public void run() {
        try {
            BLearnStation[] stations = Learn.learn((long)5000L, (MulticastServer.RollcallCallback)this);
            this.rows = new Row[stations.length];
            for (int i = 0; i < this.rows.length; ++i) {
                this.rows[i] = new Row(stations[i]);
            }
            this.updateRows();
            this.setCenter((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
            this.table.sortByColumn(0, true);
            this.relayout();
        }
        catch (LocalizableRuntimeException ex) {
            BDialog.error((BWidget)this.getShell(), (String)BDialog.TITLE_ERROR, (Object)BDialog.TITLE_ERROR, (Throwable)ex);
            BOptionDialog dialog = (BOptionDialog)this.getShell();
            dialog.close(2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hyperlink(Row row) {
        this.result = row.toOrd();
        BDialog dialog = (BDialog)this.getShell();
        dialog.close();
    }

    public BOrd result() {
        if (this.result != null) {
            return this.result;
        }
        int row = this.table.getSelection().getRow();
        if (row >= 0) {
            return this.rows[row].toOrd();
        }
        return null;
    }

    public void computePreferredSize() {
        this.setPreferredSize(500.0, 400.0);
    }

    void updateRows() {
        Row[] rows = this.rows;
        boolean useHostName = this.useHostName.isSelected();
        for (int i = 0; i < rows.length; ++i) {
            rows[i].station.invariant(useHostName);
        }
        this.table.getModel().updateTable();
    }

    static {
        lex = UiLexicon.bajaui();
        bajaLex = Lexicon.make((String)"baja");
    }

    class Row {
        BLearnStation station;

        Row(BLearnStation station) {
            this.station = station;
        }

        public Object valueAt(int col) {
            return BStationFinder.this.cols[col].getColumnValue(this.station);
        }

        public BOrd toOrd() {
            String host = BStationFinder.this.useHostName.isSelected() ? this.station.getHostName() : this.station.getHostAddress();
            return BOrd.make((String)("ip:" + host + "|" + this.station.getScheme() + ":" + this.station.getFoxPort()));
        }

        public BImage getIcon() {
            if (this.station.getScheme().equalsIgnoreCase("foxs")) {
                return foxsIcon;
            }
            return foxIcon;
        }
    }

    class Column {
        String name;
        Property prop;

        Column(Property prop) {
            this.name = prop.equals(BLearnStation.niagaraPlatformType) ? UiLexicon.bajaui().getText("type") : prop.getDefaultDisplayName(null);
            this.prop = prop;
        }

        Object getColumnValue(BLearnStation learnStation) {
            if (this.prop.equals(BLearnStation.niagaraPlatformType)) {
                try {
                    if (learnStation.getNiagaraPlatformType().isEmpty()) {
                        if (niagaraStationTypeInfo == null) {
                            niagaraStationTypeInfo = BTypeSpec.make((String)"niagaraDriver", (String)"NiagaraStation").getTypeInfo();
                        }
                        return niagaraStationTypeInfo.getDisplayName(null);
                    }
                    if (niagaraEdgeLiteTypeInfo == null) {
                        niagaraEdgeLiteTypeInfo = BTypeSpec.make((String)"niagaraDriver", (String)"NiagaraEdgeLiteStation").getTypeInfo();
                    }
                    return niagaraEdgeLiteTypeInfo.getDisplayName(null);
                }
                catch (Exception ignore) {
                    return bajaLex.getText("unknown");
                }
            }
            return learnStation.get(this.prop);
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getRowCount() {
            return BStationFinder.this.rows.length;
        }

        public int getColumnCount() {
            return BStationFinder.this.cols.length;
        }

        public String getColumnName(int c) {
            return BStationFinder.this.cols[c].name;
        }

        public Object getValueAt(int r, int c) {
            return BStationFinder.this.rows[r].valueAt(c);
        }

        public Object getSubject(int r) {
            return BStationFinder.this.rows[r];
        }

        public BImage getRowIcon(int r) {
            return BStationFinder.this.rows[r].getIcon();
        }

        public boolean isColumnSortable(int c) {
            return true;
        }

        public void sortByColumn(int c, boolean ascending) {
            Object[] keys = new Object[BStationFinder.this.rows.length];
            for (int r = 0; r < BStationFinder.this.rows.length; ++r) {
                keys[r] = BStationFinder.this.rows[r].valueAt(c);
            }
            SortUtil.sort((Object[])keys, (Object[])BStationFinder.this.rows, (boolean)ascending);
        }
    }

    class HostToggle
    extends ToggleCommandGroup<ToggleCommand> {
        HostToggle() {
        }

        protected void selected(ToggleCommand command) {
            lastUseHostName = command == BStationFinder.this.useHostName;
            BStationFinder.this.updateRows();
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        public void handleEnter(BKeyEvent event) {
            super.handleEnter(event);
            int row = this.getSelection().getRow();
            if (row >= 0) {
                BStationFinder.this.hyperlink(BStationFinder.this.rows[row]);
            }
        }

        public void cellDoubleClicked(BMouseEvent event, int row, int col) {
            BStationFinder.this.hyperlink(BStationFinder.this.rows[row]);
        }

        public BMenu makeOptionsMenu() {
            BMenu menu = super.makeOptionsMenu();
            menu.add(null, (BValue)new BSeparator());
            menu.add(null, (BValue)new BRadioButtonMenuItem(BStationFinder.this.useHostName));
            menu.add(null, (BValue)new BRadioButtonMenuItem(BStationFinder.this.useHostAddress));
            return menu;
        }
    }

    class Selection
    extends TableSelection {
        Selection() {
        }

        public void updateTable() {
            BStationFinder.this.ok.setEnabled(this.getRow() >= 0);
            super.updateTable();
        }
    }
}

