/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.shell.WbHistory;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.UiLexicon;

public class BRecentList
extends BEdgePane {
    public static final Action fullOrdChanged = BRecentList.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BRecentList.class);
    static BBrush altRowColor = BColor.make((int)220, (int)220, (int)220).toBrush();
    static boolean lastFullOrd = false;
    BCheckBox fullOrd;
    BTable table;
    Row[] rows;
    HyperlinkInfo result;

    public void fullOrdChanged() {
        this.invoke(fullOrdChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BRecentList() {
        String lexFullOrd = UiLexicon.bajaui().getText("commands.recentOrds.showFullOrds");
        this.fullOrd = new BCheckBox(lexFullOrd, lastFullOrd);
        this.linkTo((BComponent)this.fullOrd, (Slot)BCheckBox.actionPerformed, (Slot)fullOrdChanged);
        this.table = new BTable((TableModel)new Model(), (TableController)new Controller());
        this.table.setHgridVisible(false);
        this.table.setCellRenderer((TableCellRenderer)new Renderer());
        this.table.setMultipleSelection(false);
        this.table.setHeaderVisible(false);
        this.setCenter((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        this.setBottom((BWidget)new BBorderPane((BWidget)this.fullOrd, 10.0, 10.0, 0.0, 10.0));
    }

    public void load(WbHistory.Entry[] recent) {
        this.rows = new Row[recent.length];
        for (int i = 0; i < this.rows.length; ++i) {
            this.rows[i] = new Row(recent[i].icon, recent[i].name, recent[i].ord);
        }
    }

    public void hyperlink(BInputEvent event, Row row) {
        this.result = event != null ? new HyperlinkInfo(row.ord, event) : new HyperlinkInfo(row.ord);
        BDialog dialog = (BDialog)this.getShell();
        dialog.close();
    }

    public HyperlinkInfo result() {
        if (this.result != null) {
            return this.result;
        }
        int row = this.table.getSelection().getRow();
        if (row >= 0) {
            return new HyperlinkInfo(this.rows[row].ord);
        }
        return null;
    }

    public void computePreferredSize() {
        super.computePreferredSize();
        double pw = this.getPreferredWidth();
        double ph = this.getPreferredHeight();
        if (pw < 300.0) {
            pw = 300.0;
        }
        if (ph < 150.0) {
            ph = 150.0;
        }
        if (ph > 260.0) {
            ph = 260.0;
        }
        this.setPreferredSize(pw, ph);
    }

    public void doFullOrdChanged() {
        this.table.sizeColumnsToFit();
        lastFullOrd = this.fullOrd.isSelected();
    }

    public String getStyleSelector() {
        return "recent-ords";
    }

    static class Row {
        BImage icon;
        String name;
        BOrd ord;

        Row(BImage icon, String name, BOrd ord) {
            this.icon = icon;
            this.name = name;
            this.ord = ord;
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getRowCount() {
            return BRecentList.this.rows.length;
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int col) {
            return "?";
        }

        public Object getValueAt(int r, int c) {
            if (BRecentList.this.fullOrd.isSelected()) {
                return BRecentList.this.rows[r].ord;
            }
            return BRecentList.this.rows[r].name;
        }

        public Object getSubject(int r) {
            return BRecentList.this.rows[r];
        }

        public BImage getIcon(int r) {
            return BRecentList.this.rows[r].icon;
        }
    }

    class Renderer
    extends TableCellRenderer {
        Renderer() {
        }

        private BBrush getAltRowColor() {
            return Theme.table().getBandBrush((IStylable)this.getTable());
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            if (cell.row % 2 == 0) {
                return this.getAltRowColor();
            }
            return super.getBackground(cell);
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            return super.getPreferredCellWidth(cell) + 50.0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            Row row = BRecentList.this.rows[cell.row];
            this.paintCellBackground(g, cell);
            BFont font = Theme.table().getCellFont();
            g.setFont(font);
            BImage icon = row.icon;
            if (icon != null) {
                g.drawImage(icon, 4.0, (cell.height - 16.0) / 2.0);
            }
            String text = this.getCellText(cell);
            g.push();
            try {
                g.clip(0.0, 0.0, cell.width - 30.0, cell.height);
                g.drawString(text, 24.0, font.getAscent() + 2.0);
            }
            finally {
                g.pop();
            }
            if (cell.row < 26) {
                if (!cell.selected) {
                    g.setBrush(Theme.menuItem().getAcceleratorBrush((IStylable)BRecentList.this));
                }
                g.setFont(Theme.menuItem().getAcceleratorFont());
                String acc = String.valueOf((char)(65 + cell.row));
                g.drawString(acc, cell.width - 24.0, font.getAscent() + 2.0);
            }
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        public void keyPressed(BKeyEvent event) {
            int keyCode = event.getKeyCode();
            if (65 <= keyCode && keyCode < 65 + BRecentList.this.rows.length) {
                event.consume();
                BRecentList.this.hyperlink((BInputEvent)event, BRecentList.this.rows[keyCode - 65]);
            } else if (keyCode == 10) {
                int row = this.getSelection().getRow();
                if (row >= 0) {
                    event.consume();
                    BRecentList.this.hyperlink((BInputEvent)event, BRecentList.this.rows[row]);
                }
            } else {
                super.keyPressed(event);
            }
        }

        public void cellDoubleClicked(BMouseEvent event, int row, int col) {
            BRecentList.this.hyperlink((BInputEvent)event, BRecentList.this.rows[row]);
        }
    }
}

