/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.authn.AuthenticationClient;
import com.tridium.fox.session.Fox;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.FatalAuthenticationException;
import com.tridium.ui.ShellPeer;
import com.tridium.ui.awt.PanelPeer;
import com.tridium.ui.theme.Theme;
import com.tridium.util.CustomThemeModuleManager;
import com.tridium.util.ThrowableUtil;
import com.tridium.web.WebUtil;
import com.tridium.workbench.auth.BWbLoginPane;
import com.tridium.workbench.auth.WbAuthenticationClient;
import com.tridium.workbench.job.JobMonitor;
import com.tridium.workbench.shell.BDefaultWbWebProfile;
import com.tridium.workbench.shell.BGeneralOptions;
import com.tridium.workbench.shell.BNiagaraWbAppletLoginPane;
import com.tridium.workbench.shell.BNiagaraWbDialog;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BSideBarPane;
import com.tridium.workbench.shell.RemoteShellContainer;
import com.tridium.workbench.shell.WbMain;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.AccessController;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.ViewQuery;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BHttpFoxCredentials;
import javax.baja.security.BICredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.BUsernameCredential;
import javax.baja.security.CancelledAuthenticationException;
import javax.baja.security.kerberos.BKerberosCredentials;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.authn.BCredInputPane;
import javax.baja.workbench.authn.BWbDialogHandler;
import javax.net.ssl.SSLHandshakeException;

public abstract class BNiagaraWbWebShell
extends BNiagaraWbShell {
    public static final Type TYPE = Sys.loadType(BNiagaraWbWebShell.class);
    protected static BFoxSession lastFoxSession = null;
    protected BFoxSession foxSession;
    protected RemoteShellContainer shellContainer;
    protected boolean initSideBar;
    protected static Logger log = Logger.getLogger("com.tridium.workbench.shell");
    private KeepaliveThread keepaliveThread;
    private static final String KEEPALIVE_URL = "/wb/keepalive";
    protected volatile boolean popstate;
    private static final String HTTP_FOX_SCHEME_MISMATCH_TITLE = "Invalid WebService/FoxService scheme configuration detected";
    private static final String HTTP_FOX_SCHEME_MISMATCH_MSG = "An invalid combination of WebService and FoxService schemes was detected.\nPlease ensure that the station WebService and FoxService are using compatible scheme settings\n(either HTTP/FOX or HTTPS/FOXS) and the scheme properties are appropriately enabled";
    public static final String QUERY_LOGIN_FAILED = "loginFailed";
    public static final int LOGIN_STATE_HTTP_FOX_SSL_MISMATCH = 6;
    private static final boolean HTTP_RELOAD = "true".equals(AccessController.doPrivileged(() -> System.getProperty("niagara.applet.httpReload", "true")));
    private String csrfToken = null;
    private static final String USER_HOME = AccessController.doPrivileged(() -> System.getProperty("user.home"));

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BNiagaraWbWebShell() {
        super(null);
        throw new IllegalStateException();
    }

    protected BNiagaraWbWebShell(RemoteShellContainer shellContainer, Type profileType) {
        super(profileType);
        this.shellContainer = shellContainer;
        WbMain.initApplet();
    }

    public ShellPeer newShellPeer() {
        return new PanelPeer();
    }

    public RemoteShellContainer getShellContainer() {
        return this.shellContainer;
    }

    public URL ordToUrl(BOrd ord) {
        try {
            String ordStr = ord.toString();
            if (ordStr.startsWith("http://") || ordStr.startsWith("https://")) {
                return new URL(ordStr);
            }
            BOrd activeOrd = this.getActiveOrd();
            ord = activeOrd != null && !activeOrd.isNull() ? BOrd.make((BOrd)activeOrd, (BOrd)ord).normalize() : ord;
            OrdTarget target = this.getActiveOrdTarget();
            URL base = this.shellContainer.getDocumentBase();
            String servletPath = this.shellContainer.getParameter("servletPath");
            URL url = servletPath == null || servletPath.length() == 0 || servletPath.equals("/") ? new URL(base, WebUtil.toUri((OrdTarget)target, (String)"/ord/", (BOrd)ord)) : new URL(base, WebUtil.toUri((OrdTarget)target, (String)(servletPath + "/ord/"), (BOrd)ord));
            return url;
        }
        catch (Exception e) {
            throw new SyntaxException("" + ord, (Throwable)e);
        }
    }

    public BSimple getParameter(String param, BSimple def) {
        if (this.shellContainer == null) {
            return def;
        }
        String val = this.shellContainer.getParameter(param);
        if (val == null) {
            return def;
        }
        try {
            return (BSimple)def.decodeFromString(val);
        }
        catch (IOException e) {
            return def;
        }
    }

    public boolean getParameter(String param, boolean def) {
        return ((BBoolean)this.getParameter(param, (BSimple)BBoolean.make((boolean)def))).getBoolean();
    }

    @Override
    void doShowStatus(String msg) {
        this.pane.showStatus(msg);
        this.shellContainer.showStatus(msg);
    }

    public BWidget getMenuBar() {
        return this.pane.getMenuBar();
    }

    @Override
    public void hyperlink(HyperlinkInfo hyperlinkInfo) {
        boolean reload;
        boolean bl = reload = this.foxSession == null || !this.foxSession.isConnected();
        if (!reload) {
            int i;
            String hostname = this.foxSession.getHost().getHostname();
            String foxSessionBody = null;
            OrdQuery[] queries = this.foxSession.getOrdInHost().normalize().parse();
            for (i = 0; i < queries.length; ++i) {
                if (!queries[i].getScheme().equalsIgnoreCase("fox") && !queries[i].getScheme().equalsIgnoreCase("foxs")) continue;
                foxSessionBody = queries[i].getBody();
                break;
            }
            queries = hyperlinkInfo.getOrd().parse();
            for (i = 0; i < queries.length; ++i) {
                ViewQuery vq;
                if (queries[i].getScheme().indexOf("http") > -1) {
                    reload = HTTP_RELOAD;
                    break;
                }
                if (queries[i].getScheme().equalsIgnoreCase("ip") && !queries[i].getBody().equalsIgnoreCase(hostname)) {
                    reload = true;
                    break;
                }
                if ((queries[i].getScheme().equalsIgnoreCase("fox") || queries[i].getScheme().equalsIgnoreCase("foxs")) && !queries[i].getBody().equalsIgnoreCase(foxSessionBody)) {
                    reload = true;
                    break;
                }
                if (!(queries[i] instanceof ViewQuery) || !(vq = (ViewQuery)queries[i]).getParameter("appletReload", "").equalsIgnoreCase("true") && !vq.getParameter("browser", "").equalsIgnoreCase("true")) continue;
                reload = true;
                break;
            }
        }
        if (reload) {
            this.reloadHyperlink(hyperlinkInfo);
        } else {
            this.pushState(hyperlinkInfo);
            super.hyperlink(hyperlinkInfo);
        }
    }

    public void reloadHyperlink(HyperlinkInfo hyperlinkInfo) {
        URL url = this.ordToUrl(hyperlinkInfo.getOrd());
        String target = hyperlinkInfo.getMode() == BHyperlinkMode.newShell ? "_blank" : (hyperlinkInfo.getMode() == BHyperlinkMode.newTab ? "_blank" : "_self");
        this.shellContainer.showDocument(url, target);
    }

    public void appletStart() {
        String ordParam;
        String currentUser;
        BFoxClientConnection conn;
        System.out.println("*** Starting applet");
        BNiagaraWbWebShell.app().applet = this.isApplet();
        BNiagaraWbWebShell.app().webstart = this.isWebStart();
        this.initShell();
        Properties props = null;
        BHost host = null;
        int port = -1;
        boolean useFoxs = false;
        URL pingUrl = null;
        try {
            this.downloadFacetKeys();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            URL docBase = this.shellContainer.getDocumentBase();
            URL url = new URL(docBase, "/wb/logon");
            pingUrl = new URL(docBase, KEEPALIVE_URL);
            InputStream in = url.openStream();
            props = new Properties();
            props.load(in);
            in.close();
            String hostname = docBase.getHost();
            host = (BHost)BOrd.make((String)("ip:" + hostname)).get();
            port = Integer.parseInt(props.getProperty("foxPort"));
            useFoxs = Boolean.valueOf(props.getProperty("useFoxs"));
            if (useFoxs) {
                System.setProperty("sha1FingerPrint", props.getProperty("sha1FingerPrint"));
            }
            if (port == -1) {
                BDialog.error((BWidget)this, (String)HTTP_FOX_SCHEME_MISMATCH_TITLE, (Object)HTTP_FOX_SCHEME_MISMATCH_MSG);
                throw new Exception(HTTP_FOX_SCHEME_MISMATCH_MSG);
            }
            this.foxSession = BFoxSession.make((BHost)host, (int)port, (boolean)useFoxs);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error(this.tab(), BOrd.NULL, "Cannot logon using fox", e, true);
            return;
        }
        String user = this.shellContainer.getParameter("user");
        if (user != null && this.foxSession.isConnected() && (conn = this.foxSession.getConnection()) != null && !user.equals(currentUser = conn.getCredentials().getUsername())) {
            System.out.println("NiagaraWbApplet.relogin: " + user + " != " + currentUser);
            this.logoff();
            this.foxSession = BFoxSession.make((BHost)host, (int)port, (boolean)useFoxs);
        }
        if (!this.foxSession.isConnected()) {
            try {
                this.logon(props);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    String query = "";
                    if (e instanceof ConnectException || e instanceof SSLHandshakeException) {
                        query = "?loginFailed=6";
                    }
                    URL docBase = this.shellContainer.getDocumentBase();
                    URL url = new URL(docBase, "/logout" + query);
                    this.shellContainer.showDocument(url, "_top");
                }
                catch (Exception ex) {
                    this.error(this.tab(), BOrd.NULL, "Cannot logon using fox", e, true);
                }
                return;
            }
        }
        if ((ordParam = this.shellContainer.getParameter("ord")) == null) {
            this.error(this.tab(), BOrd.NULL, "Missing 'ord' parameter", null, true);
            return;
        }
        this.loadSideBar();
        JobMonitor.get();
        BOrd ord = BOrd.make((BOrd)this.foxSession.getNavOrd(), (String)ordParam);
        this.hyperlink(new HyperlinkInfo(ord));
        this.startPopState(ord);
        this.startKeepalive(pingUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFacetKeys() throws Exception {
        String userHome = USER_HOME;
        if (System.getenv("LOCALAPPDATA") != null) {
            userHome = System.getenv("LOCALAPPDATA");
        }
        userHome = File.separatorChar == '/' ? "/tmp" : userHome;
        File bajaHome = new File(userHome + File.separator + "niagara" + File.separator + "wbapplet" + File.separator + BNiagaraWbWebShell.calcHostNameKey(this.shellContainer));
        File workbench = new File(bajaHome, "workbench");
        workbench.mkdirs();
        File dest = new File(workbench, "facetKeys.properties");
        if (!dest.exists()) {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
            URL base = this.shellContainer.getDocumentBase();
            URL target = new URL(base, "/wb/facetkeys");
            try (InputStream in = target.openStream();){
                int n;
                int len = 4096;
                byte[] buf = new byte[len];
                while ((n = in.read(buf, 0, len)) >= 0) {
                    ((OutputStream)out).write(buf, 0, n);
                }
                ((OutputStream)out).close();
            }
        }
    }

    public void appletStop() {
        this.stopPopState();
        BNiagaraWbWebShell.shutdownShell(this);
        this.saveSideBar();
        this.stopKeepalive();
    }

    public static void shutdownShell(BNiagaraWbShell shell) {
        BNiagaraWbDialog[] niagaraDialogs = BNiagaraWbDialog.getDialogsForOwner(shell);
        for (int i = 0; i < niagaraDialogs.length; ++i) {
            BNiagaraWbWebShell.shutdownShell(niagaraDialogs[i]);
        }
        if (shell instanceof BNiagaraWbDialog) {
            ((BNiagaraWbDialog)shell).close();
        } else {
            shell.shutdownShell();
        }
    }

    LastSideBarInfo getLastSideBarInfo() {
        if (lastFoxSession != null && BNiagaraWbWebShell.lastFoxSession.uiCache instanceof LastSideBarInfo) {
            return (LastSideBarInfo)BNiagaraWbWebShell.lastFoxSession.uiCache;
        }
        return null;
    }

    @Override
    BSideBarPane makeSideBar() {
        BSideBarPane sideBar = null;
        LastSideBarInfo info = this.getLastSideBarInfo();
        if (info != null) {
            sideBar = info.lastSideBar;
            info.lastSideBar = null;
        }
        if (sideBar != null) {
            this.initSideBar = false;
        } else {
            this.initSideBar = true;
            sideBar = new BSideBarPane();
        }
        return sideBar;
    }

    void loadSideBar() {
        boolean lastSideBarVisible = true;
        double lastSideBarPosition = 30.0;
        LastSideBarInfo info = this.getLastSideBarInfo();
        if (info != null) {
            lastSideBarVisible = info.lastSideBarVisible;
            lastSideBarPosition = info.lastSideBarPosition;
        }
        if (lastFoxSession != this.foxSession) {
            boolean bl = this.initSideBar = this.pane.sideBar != null;
            if (this.initSideBar) {
                this.pane.sideBar.closeAll();
            }
        }
        if (this.initSideBar && lastSideBarVisible) {
            this.pane.sideBar.initFromProfile(this.getProfile());
        }
        this.commands.showSideBar.setSelected(lastSideBarVisible);
        this.pane.setSplitPosition(lastSideBarPosition);
    }

    void saveSideBar() {
        lastFoxSession = this.foxSession;
        BSideBarPane sideBar = this.pane.sideBar;
        if (sideBar == null) {
            return;
        }
        sideBar.getParent().set(sideBar.getPropertyInParent(), (BValue)new BNullWidget());
        if (this.foxSession != null && this.foxSession.isConnected()) {
            LastSideBarInfo info = this.getLastSideBarInfo();
            if (info == null) {
                info = new LastSideBarInfo();
            }
            info.lastSideBar = sideBar;
            info.lastSideBarVisible = this.commands.showSideBar.isSelected();
            info.lastSideBarPosition = this.pane.getSplitPosition();
            this.foxSession.uiCache = info;
        }
    }

    void logon(Properties props) throws Exception {
        WbMain.licenseAdmin = BNiagaraWbWebShell.get(props, "admin", false);
        BGeneralOptions opt = BGeneralOptions.make();
        opt.initFromUserFacets(BNiagaraWbWebShell.get(props, "userFacets", BFacets.DEFAULT));
        String sessionId = props.getProperty("httpSuperSession");
        String username = this.shellContainer.getParameter("user");
        BHttpFoxCredentials cred = new BHttpFoxCredentials(username, sessionId);
        this.foxSession.setCredentials((BICredentials)cred);
        this.csrfToken = props.getProperty("csrfToken");
        Fox.appName = "WbApplet";
        Fox.appVersion = "" + Sys.getBajaVersion();
        this.foxSession.getConnection().setCheckBrandCompatibility(false);
        this.connect();
    }

    private void connect() throws Exception {
        WbAppletAuthenticationClient authenticationClient = new WbAppletAuthenticationClient();
        while (true) {
            String username = null;
            BICredentials credentials = this.foxSession.getCredentials();
            this.foxSession.getConnection().setAuthenticationClient((AuthenticationClient)authenticationClient);
            if (credentials != null && credentials instanceof BIUserCredentials) {
                username = ((BIUserCredentials)credentials).getUsername();
            }
            try {
                this.foxSession = BFoxSession.connect((BFoxSession)this.foxSession);
                return;
            }
            catch (IOException e) {
                throw e;
            }
            catch (FatalAuthenticationException e) {
                throw e;
            }
            catch (CancelledAuthenticationException e) {
                throw e;
            }
            catch (Exception e) {
                this.relayoutSync();
                e.printStackTrace();
                authenticationClient.setException(e);
                this.foxSession.setCredentials((BICredentials)new BUsernameAndPassword());
                continue;
            }
            break;
        }
    }

    private boolean challenge(String username) {
        BICredentials credentials;
        Lexicon lex = Lexicon.make((String)"workbench");
        String error = lex.getText("wbapplet.login.failed");
        BNiagaraWbAppletLoginPane loginPane = new BNiagaraWbAppletLoginPane((AuthenticationRealm)this.foxSession, true, lex.getText("wbapplet.login.failed"));
        int result = BDialog.open((BWidget)this, (String)"Enter credentials", (Object)((Object)loginPane), (int)3);
        if (result == 2) {
            loginPane.getCredInputPane().cleanCredentials();
            return false;
        }
        try {
            credentials = loginPane.getCredInputPane().extractCredentials();
        }
        catch (Exception e) {
            BDialog.error((BWidget)this, (String)UiLexicon.bajaui().getText("dialog.error"), (Object)e.getMessage(), (Throwable)e);
            return false;
        }
        this.foxSession.setCredentials(credentials);
        return true;
    }

    void logoff() {
        if (this.foxSession == null) {
            return;
        }
        try {
            this.foxSession.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.foxSession = null;
    }

    @Override
    void autoLogoff() {
        try {
            URL docBase = this.shellContainer.getDocumentBase();
            String query = "";
            if (this.csrfToken != null) {
                query = "?csrfToken=" + URLEncoder.encode(this.csrfToken, "UTF-8");
            }
            URL url = new URL(docBase, "/logout" + query);
            this.shellContainer.showDocument(url, "_top");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static boolean get(Properties props, String key, boolean def) {
        String val = props.getProperty(key, null);
        if (val == null) {
            return def;
        }
        return val.equals("true");
    }

    static BRelTime get(Properties props, String key, long def) throws Exception {
        String val = props.getProperty(key, null);
        if (val == null) {
            return BRelTime.make((long)def);
        }
        return BRelTime.make((String)val);
    }

    static BFacets get(Properties props, String key, BFacets def) throws Exception {
        String val = props.getProperty(key, null);
        if (val == null) {
            return def;
        }
        return BFacets.make((String)val);
    }

    public BFoxSession getFoxSession() {
        return this.foxSession;
    }

    protected static Type getProfileTypeFromParams(RemoteShellContainer hostApp) {
        Type profileType = null;
        try {
            String param = hostApp.getParameter("profile");
            if (param != null) {
                profileType = Sys.getType((String)param);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (profileType == null) {
            profileType = BDefaultWbWebProfile.TYPE;
        }
        return profileType;
    }

    protected static void configureThemeFromParams(RemoteShellContainer hostApp) {
        String themeParam = hostApp.getParameter("selectedWorkbenchTheme");
        if (themeParam != null) {
            try {
                BDynamicEnum themeEnum = (BDynamicEnum)BDynamicEnum.DEFAULT.decodeFromString(themeParam);
                Theme.installFromEnum((BDynamicEnum)themeEnum);
            }
            catch (Exception e) {
                e.printStackTrace();
                Theme.installDefaultTheme();
            }
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Applet parameter 'selectedWorkbenchTheme' not found (Workbench Theme not selected on user profile). Using default theme.");
            }
            BDynamicEnum defaultTheme = CustomThemeModuleManager.getDefaultThemeEnum();
            Theme.installFromEnum((BDynamicEnum)defaultTheme);
        }
    }

    @Override
    public void debug() {
        ThreadGroup g = Thread.currentThread().getThreadGroup();
        while (g.getParent() != null) {
            g = g.getParent();
        }
        System.out.println("---- Threads ---");
        BNiagaraWbWebShell.dumpThreads(g, "");
    }

    static void dumpThreads(ThreadGroup g, String indent) {
        System.out.println(indent + g.getName() + " : " + g.getClass().getName());
        System.out.println(indent + "{");
        ThreadGroup[] subs = new ThreadGroup[g.activeGroupCount()];
        g.enumerate(subs, false);
        for (int i = 0; i < subs.length; ++i) {
            ThreadGroup s = subs[i];
            if (s == null) continue;
            if (s.getParent() != g) {
                System.out.print("ERR>");
            }
            BNiagaraWbWebShell.dumpThreads(subs[i], indent + "  ");
        }
        Thread[] threads = new Thread[g.activeCount()];
        g.enumerate(threads, false);
        for (int i = 0; i < threads.length; ++i) {
            Thread t = threads[i];
            if (t == null) continue;
            if (t.getThreadGroup() != g) {
                System.out.print("ERR>");
            }
            System.out.println(indent + "  " + t.getName() + " [" + t.getPriority() + "]" + (t.isDaemon() ? " daemon" : "") + " : " + t.getClass().getName());
        }
        System.out.println(indent + "}");
    }

    private static final String calcHostNameKey(RemoteShellContainer app) {
        String host = app.getCodeBase().getHost();
        if (app.getCodeBase().getPort() != -1) {
            host = host + "_" + app.getCodeBase().getPort();
        }
        return host.replaceAll("[^A-Za-z0-9._-]+", "_");
    }

    private void startKeepalive(URL pingUrl) {
        if (this.keepaliveThread != null && this.keepaliveThread.alive) {
            return;
        }
        try {
            this.keepaliveThread = new KeepaliveThread(pingUrl);
            this.keepaliveThread.start();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error starting keepalive. You may experience timeouts.", e);
        }
    }

    private void stopKeepalive() {
        if (this.keepaliveThread != null) {
            this.keepaliveThread.kill();
            this.keepaliveThread = null;
        }
    }

    protected abstract void pushState(HyperlinkInfo var1);

    protected abstract void startPopState(BOrd var1);

    protected abstract void stopPopState();

    private class WbAppletAuthenticationClient
    implements AuthenticationClient {
        private Exception exception = null;
        private boolean triedKerb = false;

        private WbAppletAuthenticationClient() {
        }

        public BIUserCredentials requestUsername(AuthenticationRealm realm) {
            String schemeName = realm.getAuthenticationScheme();
            if (schemeName.equals("Fox (n4Kerberos)") && !this.triedKerb && this.exception != null) {
                this.triedKerb = true;
                String username = BNiagaraWbWebShell.this.shellContainer.getParameter("user");
                BKerberosCredentials creds = WbAuthenticationClient.getCurrentKerberosCredentials();
                if (creds.getUsername().equals(username)) {
                    return creds;
                }
            }
            return new BUsernameCredential(BNiagaraWbWebShell.this.shellContainer.getParameter("user"));
        }

        public BICredentials requestInformation(AuthenticationRealm realm, String schemeName, int step, BIObject seedInfo) {
            BAuthenticationScheme scheme = BAuthenticationScheme.getSchemeFromName((String)schemeName);
            BWbDialogHandler dialogHandler = (BWbDialogHandler)scheme.getAgentOn(BWbDialogHandler.class);
            BCredInputPane pane = null;
            pane = dialogHandler.getPaneForStep(realm, "", step, seedInfo);
            BICredentials credentials = this.acquireUserCredentials(realm, pane);
            if (credentials == null) {
                return null;
            }
            return credentials;
        }

        private BICredentials acquireUserCredentials(AuthenticationRealm realm, BCredInputPane pane) {
            String message;
            boolean showError;
            BWbLoginPane loginPane;
            UiLexicon lex = UiLexicon.bajaui();
            String lexTitle = lex.getText("auth.title");
            int result = BDialog.open((BWidget)BNiagaraWbWebShell.this, (String)lexTitle, (Object)((Object)(loginPane = new BWbLoginPane(realm, pane, showError = this.exception != null, message = showError ? this.exception.getMessage() : null))), (int)3);
            if (result == 2) {
                loginPane.getCredInputPane().cleanCredentials();
                return null;
            }
            try {
                BICredentials credentials = pane.extractCredentials();
                return credentials;
            }
            catch (Exception e) {
                Throwable cause = ThrowableUtil.getCause((Throwable)e);
                if (cause != null) {
                    cause.printStackTrace();
                }
                BDialog.error((BWidget)BNiagaraWbWebShell.this, (String)UiLexicon.bajaui().getText("dialog.error"), (Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }

        public void setException(Exception e) {
            this.exception = e;
        }
    }

    private final class KeepaliveThread
    extends Thread {
        private boolean alive;
        private static final long PING_INTERVAL = 30000L;
        private URL url;

        KeepaliveThread(URL url) {
            super("BWbNiagaraWbWebShell#KeepaliveThread");
            this.alive = true;
            this.url = url;
        }

        public void kill() {
            this.alive = false;
            this.interrupt();
        }

        @Override
        public void run() {
            try {
                while (this.alive) {
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!this.alive) continue;
                    if (!BNiagaraWbWebShell.this.getShellContainer().isActive()) {
                        this.alive = false;
                        continue;
                    }
                    this.connect();
                }
            }
            catch (IOException e) {
                this.alive = false;
            }
        }

        private void connect() throws IOException {
            try (InputStream in = null;){
                if (this.url == null) {
                    return;
                }
                HttpURLConnection conn = (HttpURLConnection)this.url.openConnection();
                in = conn.getInputStream();
                while (in.read() != -1) {
                }
            }
        }
    }

    class LastSideBarInfo {
        BSideBarPane lastSideBar = null;
        boolean lastSideBarVisible = true;
        double lastSideBarPosition = 30.0;

        LastSideBarInfo() {
        }
    }
}

