/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.gx.awt.AwtEnv;
import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.ui.ShellManager;
import com.tridium.ui.ShellPeer;
import com.tridium.ui.awt.AwtFramePeer;
import com.tridium.ui.awt.AwtUiEnv;
import com.tridium.workbench.shell.BNiagaraWbDialog;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.WbMain;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.lang.reflect.Field;
import java.security.AccessController;
import javax.baja.gx.BImage;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.workbench.BWbProfile;

public class BNiagaraWbFrame
extends BNiagaraWbShell {
    public static final Type TYPE = Sys.loadType(BNiagaraWbFrame.class);
    WbFramePeer frame;
    Rectangle closeBounds;
    boolean maximized = false;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BNiagaraWbFrame() {
        super(null);
        throw new IllegalStateException();
    }

    public BNiagaraWbFrame(Type profileType) {
        super(profileType);
        this.frame.updateFromProfile(this.getProfile());
        this.setContent((BWidget)this.pane);
    }

    @Override
    void doShowStatus(String msg) {
        this.pane.showStatus(msg);
    }

    public ShellPeer newShellPeer() {
        this.frame = new WbFramePeer();
        return this.frame;
    }

    public void open() {
        this.frame.setVisible(true);
        this.initShell();
    }

    public void close() {
        BNiagaraWbDialog[] dlgs = BNiagaraWbDialog.getDialogsForOwner(this);
        for (int i = 0; i < dlgs.length; ++i) {
            dlgs[i].close();
        }
        this.maximized = ((AwtUiEnv)AwtUiEnv.get()).isMaximized((Frame)((Object)this.frame));
        this.closeBounds = this.frame.getBounds();
        this.frame.setVisible(false);
        this.frame.dispose();
        this.frame = null;
        this.shutdownShell();
    }

    public boolean getMaximized() {
        return this.maximized;
    }

    public Rectangle getFrameBounds() {
        if (this.closeBounds != null) {
            return this.closeBounds;
        }
        return this.frame.getBounds();
    }

    class WbFramePeer
    extends AwtFramePeer {
        WbFramePeer() {
            super("???");
            this.enableEvents(64L);
        }

        void updateFromProfile(BWbProfile profile) {
            String title = profile.getFrameTitle();
            this.setTitle(title);
            if (OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.linux)) {
                AccessController.doPrivileged(() -> {
                    try {
                        Toolkit toolkit = Toolkit.getDefaultToolkit();
                        Field awtAppClassNameField = toolkit.getClass().getDeclaredField("awtAppClassName");
                        awtAppClassNameField.setAccessible(true);
                        awtAppClassNameField.set(toolkit, title);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                });
            }
            try {
                Image awtImage = AwtEnv.peer((BImage)profile.getFrameIcon().sync()).image();
                this.setIconImage(awtImage);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void installShellManager(ShellManager shellManager) {
            super.installShellManager(shellManager);
            this.setLayout(new BorderLayout());
            this.add("Center", (Component)shellManager);
        }

        public void processWindowEvent(WindowEvent event) {
            if (event.getID() == 201 && !WbMain.isKiosk()) {
                BNiagaraWbFrame.this.commands.close.invoke();
            }
        }
    }
}

