/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.nre.util.SystemPropertiesUtil;
import com.tridium.sys.Nre;
import com.tridium.ui.theme.custom.nss.NSSUtils;
import com.tridium.util.CustomThemeModuleManager;
import com.tridium.util.TimeFormat;
import com.tridium.workbench.shell.BFontSize;
import java.io.File;
import java.io.FileInputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.Properties;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.options.BUserOptions;
import javax.baja.units.BUnitConversion;

public class BGeneralOptions
extends BUserOptions {
    public static final Property timeFormat = BGeneralOptions.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (String)"workbench:TimeFormatFE"));
    public static final Property unitConversion = BGeneralOptions.newProperty((int)0, (BValue)BUnitConversion.none, null);
    public static final Property autoLogoffEnabled = BGeneralOptions.newProperty((int)0, (boolean)false, null);
    public static final Property autoLogoffPeriod = BGeneralOptions.newProperty((int)0, (BValue)BRelTime.make((long)900000L), null);
    public static final Property promptForNameOnInsert = BGeneralOptions.newProperty((int)0, (boolean)true, null);
    public static final Property useAntiAlias = BGeneralOptions.newProperty((int)4, (boolean)true, null);
    public static final Property fontSize = BGeneralOptions.newProperty((int)0, (BValue)BFontSize.normal, null);
    public static final Property activeTheme = BGeneralOptions.newProperty((int)0, (BValue)BDynamicEnum.DEFAULT, null);
    public static final Property allowUserCredentialCaching = BGeneralOptions.newProperty((int)0, (boolean)true, null);
    public static final Property locale = BGeneralOptions.newProperty((int)2, (String)Locale.getDefault().toString(), (BFacets)BFacets.make((String[])new String[]{"min", "fieldWidth"}, (BIDataValue[])new BInteger[]{BInteger.make((int)2), BInteger.make((int)8)}));
    public static final Property isDefaultConnectionTypeSsl = BGeneralOptions.newProperty((int)4, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BGeneralOptions.class);
    private static BGeneralOptions options;
    private static String brandThemeDefault;
    private static boolean brandThemeLocked;

    public String getTimeFormat() {
        return this.getString(timeFormat);
    }

    public void setTimeFormat(String v) {
        this.setString(timeFormat, v, null);
    }

    public BUnitConversion getUnitConversion() {
        return (BUnitConversion)this.get(unitConversion);
    }

    public void setUnitConversion(BUnitConversion v) {
        this.set(unitConversion, (BValue)v, null);
    }

    public boolean getAutoLogoffEnabled() {
        return this.getBoolean(autoLogoffEnabled);
    }

    public void setAutoLogoffEnabled(boolean v) {
        this.setBoolean(autoLogoffEnabled, v, null);
    }

    public BRelTime getAutoLogoffPeriod() {
        return (BRelTime)this.get(autoLogoffPeriod);
    }

    public void setAutoLogoffPeriod(BRelTime v) {
        this.set(autoLogoffPeriod, (BValue)v, null);
    }

    public boolean getPromptForNameOnInsert() {
        return this.getBoolean(promptForNameOnInsert);
    }

    public void setPromptForNameOnInsert(boolean v) {
        this.setBoolean(promptForNameOnInsert, v, null);
    }

    public boolean getUseAntiAlias() {
        return this.getBoolean(useAntiAlias);
    }

    public void setUseAntiAlias(boolean v) {
        this.setBoolean(useAntiAlias, v, null);
    }

    public BFontSize getFontSize() {
        return (BFontSize)this.get(fontSize);
    }

    public void setFontSize(BFontSize v) {
        this.set(fontSize, (BValue)v, null);
    }

    public BDynamicEnum getActiveTheme() {
        return (BDynamicEnum)this.get(activeTheme);
    }

    public void setActiveTheme(BDynamicEnum v) {
        this.set(activeTheme, (BValue)v, null);
    }

    public boolean getAllowUserCredentialCaching() {
        return this.getBoolean(allowUserCredentialCaching);
    }

    public void setAllowUserCredentialCaching(boolean v) {
        this.setBoolean(allowUserCredentialCaching, v, null);
    }

    public String getLocale() {
        return this.getString(locale);
    }

    public void setLocale(String v) {
        this.setString(locale, v, null);
    }

    public boolean getIsDefaultConnectionTypeSsl() {
        return this.getBoolean(isDefaultConnectionTypeSsl);
    }

    public void setIsDefaultConnectionTypeSsl(boolean v) {
        this.setBoolean(isDefaultConnectionTypeSsl, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BGeneralOptions make() {
        if (options == null) {
            BGeneralOptions.loadBrand();
            options = (BGeneralOptions)BGeneralOptions.load((Type)TYPE);
            NSSUtils.setIncreaseFontSize((options.getFontSize() == BFontSize.large ? 1 : 0) != 0);
            BDynamicEnum activeTheme = options.getActiveTheme();
            String tag = activeTheme.getTag();
            Slot slot = options.getSlot("activeTheme");
            int flags = options.getFlags(slot);
            if (brandThemeLocked) {
                options.setFlags(slot, flags | 4);
                if (brandThemeDefault != null) {
                    tag = brandThemeDefault;
                }
            } else {
                boolean noneSelected;
                options.setFlags(slot, flags & 0xFFFFFFFB);
                boolean bl = noneSelected = tag == null || tag.equals("0") && activeTheme.getRange().isNull();
                if (brandThemeDefault != null && noneSelected) {
                    tag = brandThemeDefault;
                }
            }
            options.setActiveTheme(CustomThemeModuleManager.getModuleEnumForTag((String)tag));
        }
        return options;
    }

    private static void loadBrand() {
        final File f = new File(Sys.getNiagaraHome(), "etc" + File.separator + "brand.properties");
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Properties props = new Properties();
                    FileInputStream in = new FileInputStream(f);
                    props.load(in);
                    in.close();
                    brandThemeDefault = props.getProperty("workbench.theme.default", "Zebra");
                    brandThemeLocked = "true".equals(props.getProperty("workbench.theme.locked"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        this.apply();
    }

    public void initFromUserFacets(BFacets facets) {
        int unitConv;
        String timeFormat = facets.gets("timeFormat", null);
        if (timeFormat != null) {
            this.setTimeFormat(timeFormat);
        }
        if ((unitConv = facets.geti("unitConversion", -1)) != -1) {
            this.setUnitConversion(BUnitConversion.make((int)unitConv));
        }
    }

    public void apply() {
        TimeFormat.setDefaultPattern((String)this.getTimeFormat());
        Nre.unitConversion = this.getUnitConversion().getOrdinal();
        if (!this.getLocale().equalsIgnoreCase(Locale.getDefault().toString())) {
            AccessController.doPrivileged(() -> SystemPropertiesUtil.setSystemProperty((String)"niagara.lang", (String)this.getLocale()));
        }
    }

    static {
        brandThemeLocked = false;
    }
}

