/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.service;

import com.tridium.workbench.service.BWbServiceManager;
import java.util.logging.Level;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.gx.BImage;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.workbench.tool.BWbNavNodeTool;
import javax.baja.workbench.tool.BWbService;

public class BWbServiceSpec
extends BComponent {
    public static final Property serviceType = BWbServiceSpec.newProperty((int)0, (BValue)BTypeSpec.NULL, null);
    public static final Property installed = BWbServiceSpec.newProperty((int)2, (boolean)false, null);
    public static final Property autoStart = BWbServiceSpec.newProperty((int)0, (boolean)false, null);
    public static final Property running = BWbServiceSpec.newProperty((int)2, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BWbServiceSpec.class);
    static final BImage defaultIcon = BImage.make((String)"module://icons/x16/gears.png");
    TypeInfo typeInfo;
    BImage icon;

    public BTypeSpec getServiceType() {
        return (BTypeSpec)this.get(serviceType);
    }

    public void setServiceType(BTypeSpec v) {
        this.set(serviceType, (BValue)v, null);
    }

    public boolean getInstalled() {
        return this.getBoolean(installed);
    }

    public void setInstalled(boolean v) {
        this.setBoolean(installed, v, null);
    }

    public boolean getAutoStart() {
        return this.getBoolean(autoStart);
    }

    public void setAutoStart(boolean v) {
        this.setBoolean(autoStart, v, null);
    }

    public boolean getRunning() {
        return this.getBoolean(running);
    }

    public void setRunning(boolean v) {
        this.setBoolean(running, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BWbServiceSpec make(TypeInfo serviceTypeInfo) {
        if (!serviceTypeInfo.is(BWbService.TYPE.getTypeInfo())) {
            throw new IllegalArgumentException("TypeInfo not instance of workbench:WbService");
        }
        AgentFilter filter = AgentFilter.is((TypeInfo)TYPE.getTypeInfo());
        AgentList list = Sys.getRegistry().getAgents(serviceTypeInfo).filter(filter);
        if (list.size() > 0) {
            TypeInfo agent = list.getDefault().getAgentType();
            return (BWbServiceSpec)agent.getInstance();
        }
        return new BWbServiceSpec();
    }

    public BWbService getService() {
        return (BWbService)BWbNavNodeTool.make(this.getServiceType().toString());
    }

    public void startService() {
        if (this.getRunning()) {
            return;
        }
        try {
            this.getService().serviceStarted();
            BWbServiceManager.log.info("Started service " + this.getServiceType());
        }
        catch (Exception e) {
            BWbServiceManager.log.log(Level.SEVERE, "Cannot start service " + this.getServiceType(), e);
        }
        this.setRunning(true);
    }

    public void stopService() {
        if (!this.getRunning()) {
            return;
        }
        try {
            this.getService().serviceStopped();
            BWbServiceManager.log.info("Stopped service " + this.getServiceType());
        }
        catch (Exception e) {
            BWbServiceManager.log.log(Level.SEVERE, "Cannot stop service " + this.getServiceType(), e);
        }
        this.setRunning(false);
    }

    public void updateAutoStart(boolean autoStart) {
        this.setAutoStart(autoStart);
        BWbServiceManager.make().save();
        if (autoStart) {
            this.startService();
        }
    }

    public BImage getServiceIcon() {
        if (this.icon == null) {
            BIcon typeIcon;
            if (this.typeInfo != null && (typeIcon = this.typeInfo.getIcon(null)) != null) {
                this.icon = BImage.make((BIcon)typeIcon);
            }
            if (this.icon == null) {
                this.icon = defaultIcon;
            }
        }
        return this.icon;
    }

    public String toString(Context cx) {
        StringBuffer s = new StringBuffer();
        s.append(this.getServiceType()).append("; ").append(this.getInstalled() ? "installed" : "uninstalled").append("; ").append(this.getAutoStart() ? "autoStart" : "manualStart").append("; ").append(this.getRunning() ? "running" : "stopped");
        return s.toString();
    }
}

