/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.service;

import com.tridium.workbench.service.BWbServiceSpec;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.baja.naming.SlotPath;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BValue;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.options.BOptions;
import javax.baja.workbench.tool.BWbService;
import javax.baja.workbench.tool.WbServiceManager;

public class BWbServiceManager
extends BOptions
implements WbServiceManager {
    public static final Type TYPE = Sys.loadType(BWbServiceManager.class);
    private static BWbServiceManager options;
    public static final Logger log;

    public Type getType() {
        return TYPE;
    }

    public static BWbServiceManager make() {
        if (options == null) {
            options = (BWbServiceManager)BOptions.load((Type)TYPE);
        }
        return options;
    }

    public void boot() {
        log.fine("Booting...");
        this.syncWithInstalledServices();
        this.autoStart();
        log.fine("Booted!");
    }

    private void syncWithInstalledServices() {
        BWbServiceSpec[] specs = this.getSpecs();
        for (int i = 0; i < specs.length; ++i) {
            specs[i].setInstalled(false);
        }
        TypeInfo[] installed = BWbService.getInstalled();
        for (int i = 0; i < installed.length; ++i) {
            BWbServiceSpec spec = this.getSpec(installed[i]);
            spec.setInstalled(true);
            spec.typeInfo = installed[i];
        }
    }

    public void autoStart() {
        BWbServiceSpec[] specs = this.getSpecs();
        for (int i = 0; i < specs.length; ++i) {
            if (!specs[i].getAutoStart()) continue;
            specs[i].startService();
        }
    }

    public void shutdown() {
        BWbServiceSpec[] specs = this.getSpecs();
        for (int i = 0; i < specs.length; ++i) {
            specs[i].stopService();
        }
    }

    @Override
    public void start(TypeInfo serviceType) {
        this.getSpec(serviceType).startService();
    }

    @Override
    public void start(BWbService service) {
        this.getSpec(service).startService();
    }

    @Override
    public void stop(TypeInfo serviceType) {
        this.getSpec(serviceType).stopService();
    }

    @Override
    public void stop(BWbService service) {
        this.getSpec(service).stopService();
    }

    @Override
    public boolean isRunning(TypeInfo serviceType) {
        return this.getSpec(serviceType).getRunning();
    }

    @Override
    public boolean isAutoStart(TypeInfo serviceType) {
        return this.getSpec(serviceType).getAutoStart();
    }

    @Override
    public void setAutoStart(TypeInfo serviceType, boolean autoStart) {
        this.getSpec(serviceType).updateAutoStart(autoStart);
    }

    public BWbServiceSpec[] getSpecs() {
        ArrayList<BWbServiceSpec> v = new ArrayList<BWbServiceSpec>();
        SlotCursor c = this.getProperties();
        while (c.next()) {
            if (!(c.get() instanceof BWbServiceSpec)) continue;
            v.add((BWbServiceSpec)c.get());
        }
        return v.toArray(new BWbServiceSpec[v.size()]);
    }

    public BWbServiceSpec getSpec(TypeInfo serviceTypeInfo) {
        String name = SlotPath.escape((String)serviceTypeInfo.toString());
        BWbServiceSpec spec = (BWbServiceSpec)this.get(name);
        if (spec == null) {
            if (!serviceTypeInfo.is(BWbService.TYPE.getTypeInfo())) {
                throw new IllegalArgumentException("TypeInfo not instance of workbench:WbService");
            }
            spec = BWbServiceSpec.make(serviceTypeInfo);
            spec.setServiceType(serviceTypeInfo.getTypeSpec());
            this.add(name, (BValue)spec);
        }
        return spec;
    }

    public BWbServiceSpec getSpec(BWbService service) {
        return this.getSpec(service.getType().getTypeInfo());
    }

    static {
        log = Logger.getLogger("wb.service");
    }
}

