/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.security;

import com.tridium.nre.platform.PlatformUtil;
import com.tridium.ui.BOptionDialog;
import com.tridium.workbench.fieldeditors.BChangePasswordFE;
import java.security.AccessController;
import java.util.ArrayList;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Localizable;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="okButtonPressed"), @NiagaraAction(name="skipButtonPressed"), @NiagaraAction(name="modified")})
public class BChangeSystemPassphraseDialog
extends BDialog {
    public static final Action okButtonPressed = BChangeSystemPassphraseDialog.newAction((int)0, null);
    public static final Action skipButtonPressed = BChangeSystemPassphraseDialog.newAction((int)0, null);
    public static final Action modified = BChangeSystemPassphraseDialog.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BChangeSystemPassphraseDialog.class);
    private static Lexicon lex = Lexicon.make((String)"workbench");
    private static double labelWidth = 0.0;
    private BChangePasswordFE changePasswordFE = new BChangePasswordFE(BPasswordStrength.FIPS_1, lex.getText("changePassphrase.passwordTextValue"));
    private BButton okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
    private BButton skipButton = new BButton(UiLexicon.bajaui().getText("dialog.skip"));

    public void okButtonPressed() {
        this.invoke(okButtonPressed, null, null);
    }

    public void skipButtonPressed() {
        this.invoke(skipButtonPressed, null, null);
    }

    public void modified() {
        this.invoke(modified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    private BChangeSystemPassphraseDialog() {
        this.setContent(this.buildDialog());
        this.linkTo((BComponent)this.changePasswordFE, (Slot)BChangePasswordFE.modified, (Slot)modified);
    }

    public static void prompt(BWidget owner) {
        BChangeSystemPassphraseDialog dialog = new BChangeSystemPassphraseDialog();
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        BDialog.open((BWidget)owner, (String)lex.getText("changePassphrase.title"), (Object)((Object)dialog), (int)0);
    }

    private BWidget buildDialog() {
        BEdgePane dialogPane = new BEdgePane();
        dialogPane.setTop(BChangeSystemPassphraseDialog.buildHeader());
        dialogPane.setCenter(this.buildContent());
        return dialogPane;
    }

    private static BWidget buildHeader() {
        return new BWizardHeader(null, lex.getText("changePassphrase.header.title"), lex.getText("changePassphrase.header.description"));
    }

    private BWidget buildContent() {
        BGridPane contentPane = new BGridPane(1);
        contentPane.setHalign(BHalign.left);
        contentPane.setColumnAlign(BHalign.fill);
        contentPane.add(null, (BValue)this.buildBody());
        contentPane.add(null, (BValue)this.buildButtons());
        return new BBorderPane((BWidget)contentPane, 7.0, 7.0, 7.0, 7.0);
    }

    private BWidget buildBody() {
        BGridPane mainPane = new BGridPane(1);
        mainPane.add(null, (BValue)BChangeSystemPassphraseDialog.buildLabel(lex.getText("changePassphrase.details", new Object[]{BChangeSystemPassphraseDialog.buildPasswordStrengthRequirements()})));
        mainPane.add(null, (BValue)this.changePasswordFE);
        mainPane.add(null, (BValue)BChangeSystemPassphraseDialog.buildLabel(lex.getText("changePassphrase.note.rememberOld")));
        return mainPane;
    }

    private BWidget buildButtons() {
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        buttonPane.add(null, (BValue)this.okButton);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(false);
        this.skipButton = new BButton(UiLexicon.bajaui().getText("dialog.skip"));
        buttonPane.add(null, (BValue)this.skipButton);
        this.linkTo("linkB", (BComponent)this.skipButton, (Slot)BButton.actionPerformed, (Slot)skipButtonPressed);
        this.skipButton.setEnabled(true);
        return new BBorderPane((BWidget)buttonPane, 7.0, 0.0, 0.0, 0.0);
    }

    private static String buildPasswordStrengthRequirements() {
        ArrayList<Localizable> requirements = new ArrayList<Localizable>();
        requirements.add(LexiconText.toLocalizable((String)"workbench", (String)"changePassphrase.requirements", (Object[])new Object[0]));
        requirements.addAll(BPasswordStrength.FIPS_1.getLocalizableRequirements());
        return Localizable.concatenate((String)"\n- ", requirements).toString(null);
    }

    private static BLabel buildLabel(String labelText) {
        BLabel label = new BLabel(labelText);
        label.setSize(BChangeSystemPassphraseDialog.getLabelWidth(), 0.0);
        label.setWordWrapEnabled(true);
        label.setHalign(BHalign.left);
        return label;
    }

    private static double getLabelWidth() {
        if (labelWidth == 0.0) {
            BWidget header = BChangeSystemPassphraseDialog.buildHeader();
            header.computePreferredSize();
            labelWidth = header.getPreferredWidth();
        }
        return labelWidth;
    }

    public void doOkButtonPressed() {
        BPassword enteredCurrentPassphrase = this.changePasswordFE.getCurrentPassword();
        try {
            BPassword enteredNewPassphrase = (BPassword)this.changePasswordFE.saveValue();
            boolean set = PlatformUtil.getPlatformProvider().setSystemPassword(AccessController.doPrivileged(() -> ((BPassword)enteredCurrentPassphrase).getValue()), AccessController.doPrivileged(() -> ((BPassword)enteredNewPassphrase).getValue()));
            if (set) {
                this.close();
            } else {
                BDialog.error((BWidget)this.getOwner(), (String)lex.getText("changePassphrase.ok.updateFailed.title"), (Object)lex.getText("changePassphrase.ok.updateFailed.cause"));
            }
        }
        catch (Exception e) {
            BDialog.error((BWidget)this.getOwner(), (String)lex.getText("changePassphrase.ok.updateFailed.title"), (Object)e.getLocalizedMessage());
        }
    }

    public void doSkipButtonPressed() {
        BOptionDialog skipWarningDialog = new BOptionDialog(this.getOwner(), lex.getText("changePassphrase.skip.title"), (BWidget)BChangeSystemPassphraseDialog.buildLabel(lex.getText("changePassphrase.skip.body")), 3, BDialog.WARNING_ICON, null);
        skipWarningDialog.setBoundsCenteredOnOwner();
        skipWarningDialog.open();
        if (skipWarningDialog.getResult() == 1) {
            this.close();
        }
    }

    public void doModified() {
        if (this.changePasswordFE.isNewPasswordValid(null)) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }
}

