/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.px;

import com.tridium.nre.ConsumerWithException;
import com.tridium.workbench.px.BOnMediaMigrationError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.types.text.BPxFile;
import javax.baja.naming.BOrd;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.util.LexiconModule;

public abstract class PxFileMigrator<T extends PxFileMigrator<T>> {
    protected boolean preserveIdentities;
    protected boolean dryRun;
    protected BOnMediaMigrationError onValidationError = BOnMediaMigrationError.abort;
    protected static final LexiconModule LEX = LexiconModule.make((String)"workbench");
    protected static final Logger LOG = Logger.getLogger(PxFileMigrator.class.getName());

    protected PxFileMigrator() {
    }

    public abstract boolean readyToPersist(BOrd var1, InputStream var2, Context var3) throws Exception;

    public abstract void persist(OutputStream var1, Context var2) throws Exception;

    public static CompletableFuture<Void> processAllAsync(PxFileMigrator<?> migrator, BOrd rootFilePath, String regex, Context cx) {
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        Runnable r = () -> {
            try {
                PxFileMigrator.processAll(migrator, rootFilePath, regex, cx);
                promise.complete(null);
            }
            catch (Exception e) {
                promise.completeExceptionally(e);
            }
        };
        new Thread(r, migrator.getClass().getSimpleName() + ".processAllAsync").start();
        return promise;
    }

    protected static void processAll(PxFileMigrator<?> migrator, BOrd rootFilePath, String regex, Context cx) throws Exception {
        LOG.info("Beginning Px file migration.");
        LOG.info(migrator.dryRun ? "Dry run mode: no changes will be saved." : "Px files will be overwritten.");
        LOG.info(migrator.preserveIdentities ? "Px widget identities will be preserved." : "Px widget identities will not be preserved.");
        Pattern pattern = Pattern.compile(regex);
        Predicate<BIFile> filter = file -> pattern.matcher(file.getFilePath().getBody()).find();
        BOrd rootOrd = BOrd.make((String)("local:|" + rootFilePath));
        BObject obj = PxFileMigrator.resolveFile(rootOrd);
        if (obj instanceof BIDirectory) {
            super.walkFiles((BIDirectory)obj, filter, (ConsumerWithException<BIFile, Exception>)((ConsumerWithException)file -> {
                if (file instanceof BPxFile) {
                    PxFileMigrator.doProcess(migrator, (BPxFile)file, cx);
                }
            }));
        } else if (obj instanceof BPxFile) {
            PxFileMigrator.doProcess(migrator, (BPxFile)obj, cx);
        }
        LOG.log(Level.INFO, migrator.dryRun ? "Px file migration dry run complete." : "Px file migration complete.");
    }

    private static void doProcess(PxFileMigrator<?> migrator, BPxFile pxFile, Context cx) throws Exception {
        migrator.migratePxFile(pxFile, cx);
    }

    private void walkFiles(BIDirectory dir, Predicate<BIFile> filter, ConsumerWithException<BIFile, ? extends Exception> onFile) throws Exception {
        for (BIFile file : dir.listFiles()) {
            if (file instanceof BIDirectory) {
                this.walkFiles((BIDirectory)file, filter, onFile);
                continue;
            }
            if (!filter.test(file)) continue;
            try {
                onFile.accept((Object)file);
            }
            catch (Exception e) {
                if (this.onValidationError != BOnMediaMigrationError.abort) continue;
                throw e;
            }
        }
    }

    private static BObject resolveFile(BOrd filePath) {
        BObject obj = filePath.get();
        if (!(obj instanceof BIDirectory) && !(obj instanceof BIFile)) {
            throw new IllegalArgumentException(filePath + " did not resolve to a directory or file");
        }
        return obj;
    }

    public void migratePxFile(BPxFile pxFile, Context cx) throws Exception {
        try (InputStream in = pxFile.getInputStream();){
            if (this.readyToPersist(pxFile.getAbsoluteOrd(), in, cx)) {
                this.overwrite(pxFile, cx);
            }
        }
    }

    public void migratePxData(InputStream in, OutputStream out, Context cx) throws Exception {
        if (this.readyToPersist(BOrd.DEFAULT, in, cx)) {
            this.persist(out, cx);
        }
    }

    private void overwrite(BPxFile pxFile, Context cx) throws Exception {
        try (OutputStream out = this.getOutputStream(pxFile);){
            this.persist(out, cx);
        }
    }

    private OutputStream getOutputStream(BPxFile pxFile) throws IOException {
        if (this.dryRun) {
            return new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            };
        }
        return pxFile.getOutputStream();
    }

    public T inDryRunMode(boolean dryRun) {
        this.dryRun = dryRun;
        return (T)this;
    }

    public T preservingIdentities(boolean preserveIdentities) {
        this.preserveIdentities = preserveIdentities;
        return (T)this;
    }

    public T onValidationError(String onValidationError) {
        return this.onValidationError(BOnMediaMigrationError.make(onValidationError));
    }

    public T onValidationError(BOnMediaMigrationError onValidationError) {
        this.onValidationError = onValidationError;
        return (T)this;
    }

    protected void logInfo(Object pxFile, String msg) {
        this.log(pxFile, Level.INFO, msg);
    }

    protected void logFine(Object pxFile, String msg) {
        this.log(pxFile, Level.FINE, msg);
    }

    protected void log(Object pxFile, Level level, String msg) {
        LOG.log(level, (pxFile == null ? "" : pxFile + ": ") + msg);
    }
}

