/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.propsheet;

import com.tridium.ui.theme.PropertySheetTreeTheme;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.propsheet.BComplexEntry;
import com.tridium.workbench.propsheet.BFieldEditorSheet;
import javax.baja.gx.Graphics;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.style.IStylable;

public class BRootEntry
extends BComplexEntry {
    public static final Type TYPE = Sys.loadType(BRootEntry.class);
    String summary;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BRootEntry() {
    }

    public BRootEntry(BFieldEditorSheet sheet, BObject value) {
        super(sheet, null, null, value);
        String type = this.target.getTypeDisplayName(null);
        this.summary = "";
        if (this.displayName.equals("")) {
            this.displayName = type;
        } else if (type.length() > 0) {
            this.summary = "(" + type + ")";
        }
        this.expand();
    }

    public void computePreferredSize() {
        this.computeLabelSize();
        this.label.y = 2.0;
        this.content.x = this.label.x + this.label.width + 8.0;
        this.layoutEntries(0);
    }

    public void doLayout(BWidget[] kids) {
        this.layoutEntries(0);
    }

    @Override
    boolean isExpandable() {
        return false;
    }

    @Override
    boolean isHyperlinkSupported() {
        return false;
    }

    @Override
    void paintExpander(Graphics g) {
    }

    @Override
    void paintContent(Graphics g) {
        this.paintSummary(g);
        this.paintChildren(g);
    }

    void paintSummary(Graphics g) {
        PropertySheetTreeTheme theme = Theme.propertySheetTree();
        boolean isRoot = this.isRoot();
        g.setFont(font);
        g.setBrush(isRoot ? theme.getHeaderColor((IStylable)this) : theme.getTextBrush((IStylable)this));
        g.drawString(this.summary, this.content.x, 2.0 + textBaseline);
    }

    @Override
    void paintDivider(Graphics g) {
        g.setBrush(Theme.propertySheetTree().getDividerColor((IStylable)this));
        double divY = this.computeHeight() + 3.0;
        g.strokeLine(0.0, divY, this.getWidth(), divY);
    }
}

