/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.propsheet;

import com.tridium.space.BGateway;
import com.tridium.space.BIGatewaySpace;
import com.tridium.workbench.propsheet.BAtomicEntry;
import com.tridium.workbench.propsheet.BComplexEntry;
import com.tridium.workbench.propsheet.BPropertyEntry;
import com.tridium.workbench.propsheet.BRootEntry;
import com.tridium.workbench.util.WbViewEventWorker;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.naming.SlotPath;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BSpace;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.view.BWbComponentView;

public class BFieldEditorSheet
extends BWbEditor {
    public static final Type TYPE = Sys.loadType(BFieldEditorSheet.class);
    static BBrush fill = BColor.make((int)0xCCCCCC).toBrush();
    BRootEntry root;
    SlotPath targetSlotPath;
    int subscribeDepth;
    boolean unsubscribeOnCollapse;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BFieldEditorSheet() {
        this(1);
    }

    public BFieldEditorSheet(int subscribeDepth) {
        this.subscribeDepth = subscribeDepth;
        this.unsubscribeOnCollapse = false;
        BScrollPane pane = new BScrollPane();
        pane.getHscrollBar().setUnitIncrement(15);
        pane.getHscrollBar().setBlockIncrement(150);
        pane.getVscrollBar().setUnitIncrement(15);
        pane.getVscrollBar().setBlockIncrement(150);
        this.setContent((BWidget)pane);
    }

    @Override
    public void doSetReadonly(boolean readonly) {
    }

    @Override
    public void doLoadValue(BObject value, Context cx) {
        BScrollPane pane = (BScrollPane)this.getContent();
        this.targetSlotPath = null;
        if (value.isComponent()) {
            this.targetSlotPath = value.asComponent().getSlotPath();
        }
        this.root = new BRootEntry(this, value);
        pane.setContent((BWidget)this.root);
        this.root.init();
    }

    @Override
    public BObject doSaveValue(BObject value, Context cx) throws Exception {
        if (cx != null) {
            throw new IllegalStateException("Don't know if this is supposed to happen?");
        }
        BComponent comp = null;
        if (value.isComplex()) {
            comp = value.asComplex().getParentComponent();
        }
        if (comp != null && comp.isMounted()) {
            Context tx = Transaction.start((BComponent)comp, (Context)cx);
            try {
                this.root.save(tx);
                Transaction.end((BComponent)comp, (Context)tx);
            }
            catch (Exception e) {
                BPropertyEntry[] kids = this.root.getChildEntries();
                for (int i = 0; i < kids.length; ++i) {
                    if (!kids[i].dirty || !kids[i].getType().is(BAtomicEntry.TYPE)) continue;
                    ((BAtomicEntry)kids[i]).getEditor().setModified();
                }
                this.setModified();
                throw e;
            }
            this.root.clearDirty();
        } else {
            try {
                this.root.save(cx);
            }
            catch (Exception e) {
                BPropertyEntry[] kids = this.root.getChildEntries();
                for (int i = 0; i < kids.length; ++i) {
                    if (!kids[i].dirty || !kids[i].getType().is(BAtomicEntry.TYPE)) continue;
                    ((BAtomicEntry)kids[i]).getEditor().setModified();
                }
                this.setModified();
                throw e;
            }
            this.root.clearDirty();
        }
        this.repaint();
        return value;
    }

    public BWbComponentView getParentWbComponentView() {
        for (BComplex p = this.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof BWbComponentView)) continue;
            return (BWbComponentView)p;
        }
        return null;
    }

    public void registerForComponentEvents(BComponent component) {
        this.registerForComponentEvents(component, this.subscribeDepth);
    }

    public void registerForComponentEvents(BComponent component, int depth) {
        BWbComponentView view = this.getParentWbComponentView();
        if (view != null) {
            view.registerForComponentEvents(component, depth);
        }
    }

    public void unregisterForComponentEvents(BComponent component) {
        BWbComponentView view = this.getParentWbComponentView();
        if (view != null) {
            view.unregisterForComponentEvents(component);
        }
    }

    public void handleComponentEvent(BComponentEvent event) {
        BPropertyEntry base = this.componentToEntry(event.getSourceComponent());
        if (base == null) {
            return;
        }
        int id = event.getId();
        if (id == 0) {
            BPropertyEntry entry = (BPropertyEntry)base.get("e_" + event.getSlotName());
            if (entry != null) {
                entry.update((BObject)event.getValue());
            }
            this.repaint();
        } else if (id == 1) {
            BValue value = null;
            if (base instanceof BComplexEntry && ((BComplexEntry)base).isBuiltExpansion()) {
                BWbComponentView parentView;
                BIPropertyContainer baseTarget;
                if (base.target instanceof BIPropertyContainer) {
                    BGateway gateway;
                    BSpace space;
                    baseTarget = (BIPropertyContainer)base.target;
                    if (baseTarget instanceof BGateway && (space = (gateway = (BGateway)baseTarget).getGatewaySpace()) instanceof BComponentSpace) {
                        baseTarget = ((BComponentSpace)space).getRootComponent();
                    }
                    value = baseTarget.get(event.getSlotName());
                    Property prop = baseTarget.getProperty(event.getSlotName());
                    if (prop != null) {
                        ((BComplexEntry)base).add(baseTarget, prop, (BObject)value);
                    }
                } else {
                    baseTarget = (BComplex)base.target;
                    value = baseTarget.get(event.getSlotName());
                    Property prop = baseTarget.getProperty(event.getSlotName());
                    if (prop != null) {
                        ((BComplexEntry)base).add((BComplex)baseTarget, prop, (BObject)value);
                    }
                }
                if (value != null && value.isComponent() && (parentView = this.getParentWbComponentView()) != null) {
                    WbViewEventWorker.getInstance().registerForComponentEventsLater(parentView, value.asComponent(), Math.max(0, this.subscribeDepth - 1));
                }
                this.relayout();
            }
        } else if (id == 2) {
            Property prop = base.getProperty("e_" + event.getSlotName());
            if (prop != null) {
                base.remove(prop);
            }
            this.relayout();
        } else if (id == 3) {
            String oldName = event.getValue().toString();
            String newName = event.getSlotName();
            Property prop = base.getProperty("e_" + oldName);
            BPropertyEntry entry = (BPropertyEntry)base.get(prop);
            base.rename(prop, "e_" + newName);
            entry.displayName = SlotPath.unescape((String)newName);
            this.repaint();
        } else if (id == 4) {
            if (base instanceof BComplexEntry) {
                ((BComplexEntry)base).reorder();
                this.relayout();
            } else {
                System.out.println("Error! Received reorder for non-Complex");
            }
        }
    }

    private BPropertyEntry componentToEntry(BComponent comp) {
        BPropertyEntry base = this.root;
        if (comp.getSpace() instanceof BIGatewaySpace && this.root.target.asComponent().getSpace() != comp.getSpace()) {
            BGateway gateway = ((BIGatewaySpace)comp.getSpace()).getGateway();
            base = this.componentToEntry(base, (BComponent)gateway, this.targetSlotPath);
            base = this.componentToEntry(base, comp, comp.getComponentSpace().getRootComponent().getSlotPath());
        } else {
            base = this.componentToEntry(base, comp, this.targetSlotPath);
        }
        return base;
    }

    private BPropertyEntry componentToEntry(BPropertyEntry base, BComponent comp, SlotPath targetSlotPath) {
        SlotPath eventSlotPath = comp.getSlotPath();
        if (targetSlotPath == null || eventSlotPath == null) {
            return null;
        }
        for (int i = targetSlotPath.depth(); i < eventSlotPath.depth(); ++i) {
            if (base == null) {
                return null;
            }
            base = (BPropertyEntry)base.get("e_" + eventSlotPath.nameAt(i));
        }
        return base;
    }
}

