/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.ord;

import com.tridium.util.ArrayUtil;
import com.tridium.workbench.ord.RefFilter;
import com.tridium.workbench.ord.RefNode;
import javax.baja.file.BITemplate;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.workbench.ord.BIOrdChooser;

public class BComponentChooser
extends BEdgePane
implements BIOrdChooser {
    public static final Topic pathModified = BComponentChooser.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BComponentChooser.class);
    static Lexicon lex = Lexicon.make((String)"workbench");
    private int result = 2;
    private BTree tree;
    private Model model;
    private RefFilter displayFilter = RefFilter.objects;
    private RefFilter selectFilter = RefFilter.objects;
    private BButton okButton;
    private Slot slot;
    private Handle handle;
    private boolean handleSelected = false;
    private boolean selectCloses = false;
    private OkCommand okCommand = new OkCommand();
    private CancelCommand cancelCommand = new CancelCommand();

    public void firePathModified(BWidgetEvent event) {
        this.fire(pathModified, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    @Override
    public BOrd openChooser(BWidget owner, BObject base, BOrd ord, Context cx) {
        BWidget root = owner;
        if (base instanceof BITemplate) {
            root = ((BITemplate)base).getBaseComponent();
        } else if (base instanceof BComponent) {
            root = ((BComponent)base).getComponentSpace().getRootComponent();
        } else {
            BISession session = BOrd.toSession((BObject)base);
            if (session != null) {
                BOrd station = BOrd.make((BOrd)session.getNavOrd(), (String)"station:|slot:/");
                root = (BComponent)station.resolve().get();
            }
        }
        SlotPath path = null;
        if (!ord.isNull()) {
            try {
                OrdTarget target = ord.resolve(base);
                BObject obj = target.get();
                if (obj instanceof BVirtualComponent) {
                    BVirtualComponent virtual = (BVirtualComponent)obj;
                    path = virtual.getVirtualGateway().getSlotPath();
                    path = new SlotPath(path.getScheme(), (String[])ArrayUtil.add((Object[])path.getNames(), (Object[])virtual.getSlotPath().getNames()));
                } else if (obj instanceof BComponent) {
                    path = ((BComponent)obj).getSlotPath();
                } else {
                    BComponent parent = target.getComponent();
                    if (parent instanceof BVirtualComponent) {
                        path = ((BVirtualComponent)parent).getVirtualGateway().getSlotPath();
                        path = new SlotPath(path.getScheme(), (String[])ArrayUtil.add((Object[])path.getNames(), (Object[])parent.getSlotPath().getNames()));
                    } else {
                        path = parent.getSlotPath();
                    }
                    javax.baja.sys.Slot slot = target.getSlotInComponent();
                    if (slot.isProperty()) {
                        Property[] props = target.getPropertyPathInComponent();
                        String s = props[0].getName();
                        for (int i = 1; i < props.length; ++i) {
                            s = s + "/" + props[i].getName();
                        }
                        path = path.merge(new SlotPath(s));
                    } else {
                        path = path.merge(new SlotPath(slot.getName()));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BComponentChooser browser = this.getComponentChooser((BComponent)root, path, base);
        browser.selectCloses = true;
        if (ord.toString().indexOf("h:") != -1) {
            browser.handle.setSelected(true);
        }
        BDialog dialog = new BDialog(owner, lex.getText("componentChooser.title"), true, (BWidget)new BBorderPane((BWidget)browser, 4.0, 6.0, 4.0, 6.0));
        dialog.setDefaultButton(browser.okButton);
        dialog.setBoundsCenteredOnOwner();
        dialog.open();
        if (browser.result == 2) {
            return null;
        }
        return browser.getPathOrd();
    }

    public BComponentChooser getComponentChooser(BComponent root, SlotPath path, BObject base) {
        return new BComponentChooser(root, path, RefFilter.all, RefFilter.all);
    }

    public static BOrd prompt(BWidget owner, String title, BComponent root, SlotPath initialPath, RefFilter displayFilter, RefFilter selectFilter) {
        BComponentChooser browser = new BComponentChooser(root, initialPath, displayFilter, selectFilter);
        browser.selectCloses = true;
        BDialog dialog = new BDialog(owner, title, true, (BWidget)new BBorderPane((BWidget)browser, 4.0, 6.0, 4.0, 6.0));
        dialog.setDefaultButton(browser.okButton);
        dialog.setBoundsCenteredOnOwner();
        dialog.open();
        if (browser.result == 2) {
            return null;
        }
        return browser.getPathOrd();
    }

    public static BOrd prompt(BWidget owner, String title, BComponent root, SlotPath initialPath) {
        return BComponentChooser.prompt(owner, title, root, initialPath, RefFilter.all, RefFilter.all);
    }

    public BComponentChooser() {
    }

    public BComponentChooser(BComponent root, SlotPath initialPath, RefFilter displayFilter, RefFilter selectFilter) {
        this.tree = new BTree();
        this.model = new Model(root);
        this.tree.setModel((TreeModel)this.model);
        this.tree.setController((TreeController)new Controller());
        this.tree.setSelection((TreeSelection)new Selection());
        ToggleCommandGroup group = new ToggleCommandGroup();
        this.slot = new Slot((BWidget)this);
        group.add((ToggleCommand)this.slot);
        this.handle = new Handle((BWidget)this);
        group.add((ToggleCommand)this.handle);
        this.slot.setSelected(true);
        BGridPane x = new BGridPane(1);
        x.add(null, (BValue)new BRadioButton((ToggleCommand)this.slot));
        x.add(null, (BValue)new BRadioButton((ToggleCommand)this.handle));
        BEdgePane pane = new BEdgePane();
        pane.setCenter((BWidget)new BBorderPane((BWidget)new BScrollPane((BWidget)this.tree), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        pane.setBottom((BWidget)new BBorderPane((BWidget)x, lex.getText("componentChooser.type")));
        this.setCenter((BWidget)pane);
        BGridPane buttons = new BGridPane(2);
        buttons.setUniformColumnWidth(true);
        buttons.setColumnAlign(BHalign.fill);
        this.okButton = (BButton)BAbstractButton.make((Command)this.okCommand, (boolean)true, (boolean)false);
        buttons.add("close", (BValue)this.okButton);
        buttons.add("cancel", (BValue)BAbstractButton.make((Command)this.cancelCommand, (boolean)true, (boolean)false));
        this.setBottom((BWidget)new BBorderPane((BWidget)buttons, 10.0, 0.0, 10.0, 0.0));
        this.setDisplayFilter(displayFilter);
        this.setSelectFilter(selectFilter);
        if (initialPath != null) {
            Node temp;
            String[] names = initialPath.getNames();
            Node node = (Node)this.model.getRoot(0);
            for (int i = 0; i < names.length && (temp = (Node)node.getChild(names[i])) != null; ++i) {
                node = temp;
            }
            TreeNode[] path = node.getPathFromRoot();
            this.tree.scrollPathToVisible(path);
            TreeNode n = path[path.length - 1];
            this.tree.getSelection().select(n);
            this.tree.getController().setFocus(this.tree.getSelection().getNode());
            n.setExpanded(true);
        } else {
            this.model.getRoot(0).setExpanded(true);
        }
    }

    public BTree getTree() {
        return this.tree;
    }

    public BOrd getPathOrd() {
        Node node = (Node)this.tree.getSelection().getNode();
        if (node == null) {
            return null;
        }
        BObject obj = node.ref.object;
        if (this.handle.isSelected() && obj instanceof BComponent) {
            return ((BComponent)obj).getOrdInSpace();
        }
        if (obj instanceof BComponent) {
            return ((BComponent)obj).getNavOrd();
        }
        String path = node.ref.name;
        node = (Node)node.getParent();
        obj = node.ref.object;
        while (!(obj instanceof BComponent)) {
            path = node.ref.name + "/" + path;
            node = (Node)node.getParent();
            obj = node.ref.object;
        }
        return BOrd.make((BOrd)((BComponent)obj).getNavOrd(), (BOrd)BOrd.make((OrdQuery)new SlotPath(path)));
    }

    public RefFilter getDisplayFilter() {
        return this.displayFilter;
    }

    public void setDisplayFilter(RefFilter filter) {
        this.displayFilter = filter;
    }

    public RefFilter getSelectFilter() {
        return this.selectFilter;
    }

    public void setSelectFilter(RefFilter filter) {
        this.selectFilter = filter;
    }

    public void computePreferredSize() {
        this.setPreferredSize(300.0, 400.0);
    }

    class CancelCommand
    extends Command {
        public CancelCommand() {
            super((BWidget)BComponentChooser.this, UiLexicon.bajaui().getText("dialog.cancel"), null, null, null);
        }

        public CommandArtifact doInvoke() {
            BWidget parent = BComponentChooser.this.getParentWidget();
            while (!(parent instanceof BDialog)) {
                parent = parent.getParentWidget();
            }
            ((BDialog)parent).close();
            BComponentChooser.this.result = 2;
            return null;
        }
    }

    class OkCommand
    extends Command {
        public OkCommand() {
            super((BWidget)BComponentChooser.this, UiLexicon.bajaui().getText("dialog.ok"), null, null, null);
            this.setEnabled(false);
        }

        public void checkEnabled() {
            Node node = (Node)BComponentChooser.this.tree.getSelection().getNode();
            if (node == BComponentChooser.this.tree.getModel().getRoot(0)) {
                this.setEnabled(true);
            } else if (node != null && node.ref.parent != null && node.ref.slot != null && BComponentChooser.this.selectFilter.accept(node.ref.parent, node.ref.slot)) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public CommandArtifact doInvoke() {
            BWidget parent = BComponentChooser.this.getParentWidget();
            while (!(parent instanceof BDialog)) {
                parent = parent.getParentWidget();
            }
            ((BDialog)parent).close();
            BComponentChooser.this.result = 1;
            return null;
        }
    }

    class Node
    extends TreeNode {
        RefNode ref;
        Node[] kids;

        public Node(TreeModel model, RefNode ref) {
            super(model);
            this.ref = ref;
        }

        public Node(TreeNode parent, RefNode ref) {
            super(parent);
            this.ref = ref;
        }

        public Object getSubject() {
            return this.ref;
        }

        public String getText() {
            return this.ref.text;
        }

        public BImage getIcon() {
            return this.ref.icon;
        }

        public boolean hasChildren() {
            if (this.kids == null) {
                return true;
            }
            return this.kids.length > 0;
        }

        public int getChildCount() {
            if (this.kids == null) {
                this.getChild(-1);
            }
            return this.kids.length;
        }

        public TreeNode getChild(int index) {
            if (this.kids == null) {
                this.load();
            }
            return index == -1 ? null : this.kids[index];
        }

        public TreeNode getChild(String name) {
            if (this.kids == null) {
                this.load();
            }
            for (int i = 0; i < this.kids.length; ++i) {
                if (!this.kids[i].ref.name.equals(name)) continue;
                return this.kids[i];
            }
            return null;
        }

        private void load() {
            if (this.kids == null) {
                RefNode[] refs = this.ref.getChildren(BComponentChooser.this.displayFilter);
                this.kids = new Node[refs.length];
                for (int i = 0; i < refs.length; ++i) {
                    this.kids[i] = new Node(this, refs[i]);
                }
            }
        }
    }

    class Model
    extends TreeModel {
        Node root;

        public Model(BComponent rootNode) {
            this.root = new Node(this, new RefNode((BComplex)rootNode));
        }

        public int getRootCount() {
            return 1;
        }

        public TreeNode getRoot(int index) {
            return this.root;
        }
    }

    class Selection
    extends TreeSelection {
        Selection() {
        }

        public void updateTree() {
            super.updateTree();
            BComponentChooser.this.okCommand.checkEnabled();
        }
    }

    class Controller
    extends TreeController {
        Controller() {
        }

        public void setFocus(TreeNode node) {
            if (node != null) {
                BObject obj = ((Node)node).ref.object;
                if (obj instanceof BComponent) {
                    if (!BComponentChooser.this.handle.isEnabled()) {
                        BComponentChooser.this.handle.setEnabled(true);
                        if (BComponentChooser.this.handleSelected) {
                            BComponentChooser.this.handle.setSelected(true);
                        } else {
                            BComponentChooser.this.slot.setSelected(true);
                        }
                    } else {
                        BComponentChooser.this.handleSelected = BComponentChooser.this.handle.isSelected();
                    }
                } else if (BComponentChooser.this.handle.isEnabled()) {
                    BComponentChooser.this.handleSelected = BComponentChooser.this.handle.isSelected();
                    BComponentChooser.this.slot.setSelected(true);
                    BComponentChooser.this.handle.setEnabled(false);
                }
            }
            super.setFocus(node);
        }

        protected void doSelectAction(TreeNode target, double x, double y) {
            BComponentChooser.this.firePathModified(new BWidgetEvent(1, (BWidget)BComponentChooser.this));
            if (BComponentChooser.this.selectCloses && BComponentChooser.this.okCommand.isEnabled()) {
                BComponentChooser.this.okCommand.invoke();
            }
        }
    }

    public class Handle
    extends ToggleCommand {
        Handle(BWidget owner) {
            super(owner, lex.getText("componentChooser.handle"));
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    class Slot
    extends ToggleCommand {
        Slot(BWidget owner) {
            super(owner, lex.getText("componentChooser.slot"));
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }
}

