/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.nav.editor;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.nav.editor.BNavFileEditor;
import com.tridium.workbench.util.WbUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.SimpleDragRenderer;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.util.Lexicon;

public class BSourceTable
extends BTable {
    public static final Type TYPE = Sys.loadType(BSourceTable.class);
    static Lexicon lex = Lexicon.make((String)"workbench");
    static String lexName = lex.getText("navFileEditor.source.name");
    static String lexType = lex.getText("navFileEditor.source.type");
    static String lexPath = lex.getText("navFileEditor.source.path");
    BNavFileEditor editor;
    Model model;

    public Type getType() {
        return TYPE;
    }

    public BSourceTable() {
        throw new IllegalStateException();
    }

    public BSourceTable(BNavFileEditor editor) {
        this.editor = editor;
        this.model = new Model();
        this.setModel(this.model);
    }

    public void showComponents(boolean show) {
        if (show) {
            this.discoverComponents("baja:PxView");
            if (WbUtil.isRemoteModuleAvailable("exportTags", this.editor.getCurrentValueSession())) {
                this.discoverComponents("exportTags:SubstitutePxView");
            }
            this.model.updateTable(true);
        } else {
            for (int i = 0; i < this.model.kids.size(); ++i) {
                if (!(this.model.child(i) instanceof BComponent)) continue;
                this.model.kids.remove(this.model.child(i--));
            }
            this.model.updateTable();
        }
    }

    private void discoverComponents(String strCompType) {
        String queryStr = "station:|slot:/|bql:select parent.toPathString from " + strCompType;
        BOrd query = BOrd.make((String)queryStr);
        BITable table = (BITable)query.resolve(this.editor.getCurrentValue()).get();
        Column col = table.getColumns().get(0);
        BObject base = this.editor.getCurrentValue();
        BOrd baseOrd = ((BINavNode)base).getNavOrd();
        try (TableCursor cursor = table.cursor();){
            while (cursor.next()) {
                BString temp = (BString)cursor.cell(col).as(BString.class);
                String ord = "station:|slot:" + temp.getString();
                BINavNode nav = (BINavNode)BOrd.make((BOrd)baseOrd, (String)ord).resolve(base).get();
                this.model.kids.add(nav);
            }
        }
    }

    public void showFiles(boolean show) {
        if (show) {
            BIFile root = (BIFile)BOrd.make((String)"file:^").resolve(this.editor.getCurrentValue()).get();
            this.findFiles(root);
            this.model.updateTable(true);
        } else {
            for (int i = 0; i < this.model.kids.size(); ++i) {
                if (!(this.model.child(i) instanceof BIFile)) continue;
                this.model.kids.remove(this.model.child(i--));
            }
            this.model.updateTable();
        }
    }

    private void findFiles(BIFile file) {
        if (file instanceof BIDirectory) {
            BIFile[] kids = ((BIDirectory)file).listFiles();
            for (int i = 0; i < kids.length; ++i) {
                this.findFiles(kids[i]);
            }
        } else if (file.getExtension().equals("px")) {
            this.model.kids.add((BINavNode)file);
        }
    }

    public void mouseDragStarted(BMouseEvent event) {
        int[] rows = this.getSelection().getRows();
        if (rows.length == 0) {
            return;
        }
        BImage[] icons = new BImage[rows.length];
        String[] names = new String[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            BINavNode nav = this.model.child(rows[i]);
            icons[i] = BImage.make((BIcon)nav.getNavIcon());
            names[i] = nav.getNavDisplayName(this.editor.getCurrentContext());
        }
        SimpleDragRenderer dr = new SimpleDragRenderer(icons, names);
        dr.font = Theme.table().getCellFont();
        dr.xCursorOffset = 0.0;
        dr.yCursorOffset = 0.0;
        this.startDrag(event, this.getTransferData(), (DragRenderer)dr);
    }

    public TransferEnvelope getTransferData() {
        int[] rows = this.getSelection().getRows();
        if (rows.length == 0) {
            return null;
        }
        BObject[] values = new BObject[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            values[i] = (BObject)this.model.child(rows[i]);
        }
        return TransferEnvelope.make((Mark)new Mark(values));
    }

    class Compare
    implements Comparator<BINavNode> {
        int col = 0;
        boolean ascending = true;

        public Compare(int col, boolean ascending) {
            this.col = col;
            this.ascending = ascending;
        }

        @Override
        public int compare(BINavNode oa, BINavNode ob) {
            BINavNode a = oa;
            BINavNode b = ob;
            String sa = "";
            String sb = "";
            switch (this.col) {
                case 0: {
                    sa = a.getNavDisplayName(BSourceTable.this.editor.getCurrentContext());
                    sb = b.getNavDisplayName(BSourceTable.this.editor.getCurrentContext());
                    break;
                }
                case 1: {
                    sa = a.getType().toString();
                    sb = b.getType().toString();
                    break;
                }
                case 2: {
                    sa = a.getNavOrd().relativizeToSession().toString();
                    sb = b.getNavOrd().relativizeToSession().toString();
                }
            }
            int result = sa.compareTo(sb);
            return this.ascending ? result : -result;
        }
    }

    class Model
    extends TableModel {
        ArrayList<BINavNode> kids = new ArrayList();

        Model() {
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return lexName;
                }
                case 1: {
                    return lexType;
                }
                case 2: {
                    return lexPath;
                }
            }
            return null;
        }

        public int getRowCount() {
            return this.kids.size();
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.child(row).getNavDisplayName(BSourceTable.this.editor.getCurrentContext());
                }
                case 1: {
                    return this.child(row).getType();
                }
                case 2: {
                    return this.child(row).getNavOrd().relativizeToSession();
                }
            }
            return null;
        }

        public Object getSubject(int row) {
            return this.child(row);
        }

        public BImage getRowIcon(int row) {
            return BImage.make((BIcon)this.child(row).getNavIcon());
        }

        public boolean isColumnSortable(int col) {
            return true;
        }

        public void sortByColumn(int col, boolean ascending) {
            Collections.sort(this.kids, new Compare(col, ascending));
        }

        BINavNode child(int index) {
            return this.kids.get(index);
        }
    }
}

