/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.nav;

import javax.baja.gx.BImage;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.Subject;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSubject;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.nav.menu.NavMenuUtil;
import javax.baja.workbench.view.BIExportableTableView;
import javax.baja.workbench.view.BWbView;

public class BNavContainerView
extends BWbView
implements BIExportableTableView {
    public static final Type TYPE = Sys.loadType(BNavContainerView.class);
    static final int COL_NAME = 0;
    static final int COL_DESCRIPTION = 1;
    final UiLexicon lex = UiLexicon.bajaui();
    final String LEX_NAME = this.lex.getText("nav.name");
    final String LEX_DESCRIPTION = this.lex.getText("nav.description");
    BTable table;
    protected Row[] rows = new Row[0];

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public BTable getExportTable() {
        return this.table;
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) throws Exception {
        BINavNode container = (BINavNode)value;
        String title = container.getNavDisplayName(cx);
        this.table = this.makeNavTable(container);
        this.setContent((BWidget)BTitlePane.makePane((String)title, (BTable)this.table));
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) {
        throw new IllegalStateException();
    }

    protected BTable makeNavTable(BINavNode container) {
        BINavNode[] kids = container.getNavChildren();
        this.rows = new Row[kids.length];
        for (int i = 0; i < kids.length; ++i) {
            this.rows[i] = new Row(kids[i]);
        }
        return new BTable((TableModel)new Model(), (TableController)new Controller());
    }

    protected static class Row {
        BINavNode node;
        String name;
        String description;
        BImage icon;

        public Row(BINavNode node) {
            this.node = node;
            this.name = node.getNavDisplayName(null);
            this.description = node.getNavDescription(null);
            if (this.description == null) {
                this.description = "";
            }
            this.icon = BImage.make((BIcon)node.getNavIcon());
        }

        public Object getValueAt(int col) {
            switch (col) {
                case 0: {
                    return this.name;
                }
                case 1: {
                    return this.description;
                }
            }
            return "?";
        }

        public Object getSortKey(int col) {
            return this.getValueAt(col);
        }
    }

    protected class Model
    extends TableModel {
        public int getRowCount() {
            return BNavContainerView.this.rows.length;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return BNavContainerView.this.LEX_NAME;
                }
                case 1: {
                    return BNavContainerView.this.LEX_DESCRIPTION;
                }
            }
            return "?";
        }

        public Object getSubject(int row) {
            return BNavContainerView.this.rows[row].node;
        }

        public Object getValueAt(int row, int col) {
            return BNavContainerView.this.rows[row].getValueAt(col);
        }

        public boolean isColumnSortable(int col) {
            return true;
        }

        public void sortByColumn(int col, boolean ascending) {
            Object[] keys = new Object[BNavContainerView.this.rows.length];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = BNavContainerView.this.rows[i].getSortKey(col);
            }
            SortUtil.sort((Object[])keys, (Object[])BNavContainerView.this.rows, (boolean)ascending);
        }

        public BImage getRowIcon(int row) {
            return BNavContainerView.this.rows[row].icon;
        }
    }

    protected class Controller
    extends TableController {
        public void cellDoubleClicked(BMouseEvent event, int row, int col) {
            BNavContainerView.this.getWbShell().hyperlink(new HyperlinkInfo(BNavContainerView.this.rows[row].node.getNavOrd(), (BInputEvent)event));
        }

        protected BMenu makePopup(TableSubject subject) {
            return NavMenuUtil.makeMenu((BWidget)this.getTable(), (Subject)subject);
        }
    }
}

