/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.nav;

import com.tridium.util.ArrayUtil;
import com.tridium.workbench.auth.BCnxHandler;
import com.tridium.workbench.nav.BSessionMenuAgent;
import javax.baja.naming.BHost;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.nav.menu.BNavMenuAgent;
import javax.baja.workbench.nav.tree.BNavTree;

public class BHostMenuAgent
extends BNavMenuAgent {
    public static final BHostMenuAgent INSTANCE = new BHostMenuAgent();
    public static final Type TYPE = Sys.loadType(BHostMenuAgent.class);
    public static final BModule module = TYPE.getModule();
    public static final UiLexicon lex = UiLexicon.makeUiLexicon((BModule)module);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected BMenu doMakeMenu(BWidget owner, BObject target, Context cx) {
        return this.getDefaultHostMenu(owner, (BHost)target, cx);
    }

    BMenu getDefaultHostMenu(BWidget owner, BHost host, Context cx) {
        BMenu menu = new BMenu();
        menu.add(null, (Command)new Disconnect(owner, host));
        menu.add(null, (Command)new Close(owner, host));
        menu.add(null, (BValue)new BSeparator());
        Command[] sessionOpens = BCnxHandler.getCnxCommands(owner, host);
        for (int i = 0; i < sessionOpens.length; ++i) {
            menu.add(null, sessionOpens[i]);
        }
        menu.add(null, (Command)new HostSetDisplayNameCommand(owner));
        return menu;
    }

    public static class Close
    extends Command {
        BHost[] hosts;

        public Close(BWidget owner, BHost host) {
            this(owner, new BHost[]{host});
        }

        public Close(BWidget owner, BHost[] hosts) {
            super(owner, module, "close");
            this.hosts = hosts;
        }

        public CommandArtifact doInvoke() throws Exception {
            if (BSessionMenuAgent.confirmDisconnect(this.getOwner(), this.getLabel(), "confirm.host", "confirm.close", (BINavNode[])this.hosts)) {
                for (int i = 0; i < this.hosts.length; ++i) {
                    this.hosts[i].close();
                }
                this.getOwner().repaint();
            }
            return null;
        }

        public Command doMerge(Command c) {
            return new Close(this.getOwner(), (BHost[])ArrayUtil.add((Object[])this.hosts, (Object[])((Close)c).hosts));
        }
    }

    public static class Disconnect
    extends Command {
        BHost[] hosts;

        public Disconnect(BWidget owner, BHost host) {
            this(owner, new BHost[]{host});
        }

        public Disconnect(BWidget owner, BHost[] hosts) {
            super(owner, module, "disconnect");
            this.hosts = hosts;
            boolean enabled = false;
            for (int i = 0; i < hosts.length; ++i) {
                enabled |= hosts[i].isConnected();
            }
            this.setEnabled(enabled);
        }

        public CommandArtifact doInvoke() throws Exception {
            if (BSessionMenuAgent.confirmDisconnect(this.getOwner(), this.getLabel(), "confirm.host", "confirm.disconnect", (BINavNode[])this.hosts)) {
                for (int i = 0; i < this.hosts.length; ++i) {
                    this.hosts[i].disconnect();
                }
                this.getOwner().repaint();
            }
            return null;
        }

        public Command doMerge(Command c) {
            return new Disconnect(this.getOwner(), (BHost[])ArrayUtil.add((Object[])this.hosts, (Object[])((Disconnect)c).hosts));
        }
    }

    public class HostDisplayNameArtifact
    implements CommandArtifact {
        BWidget owner;
        BObject navObj;
        String oldValue;
        String newValue;

        public HostDisplayNameArtifact(BWidget owner, BObject navObj, String oldName, String newName) {
            this.owner = owner;
            this.navObj = navObj;
            this.oldValue = oldName;
            this.newValue = newName;
        }

        public void redo() throws Exception {
            ((BHost)this.navObj).setNavDisplayName(this.newValue);
            this.owner.repaint();
        }

        public void undo() throws Exception {
            ((BHost)this.navObj).setNavDisplayName(this.oldValue);
            this.owner.repaint();
        }
    }

    public class HostSetDisplayNameCommand
    extends Command {
        public HostSetDisplayNameCommand(BWidget owner) {
            super(owner, UiLexicon.bajaui().module, "commands.setDisplayName");
        }

        public CommandArtifact doInvoke() throws Exception {
            String oldNavDisplayName;
            BObject navObj = ((BNavTree)this.getOwner()).getSelectedObject();
            String newDisplayName = oldNavDisplayName = this.getDisplayNameFormat(navObj);
            if (navObj != null && navObj instanceof BHost) {
                BWbFieldEditor displayEditor = BWbFieldEditor.makeFor((BObject)BFormat.DEFAULT);
                displayEditor.loadValue((BObject)BFormat.make((String)oldNavDisplayName));
                if (BDialog.open((BWidget)this.getShell(), (String)this.getLabel(), (Object)((Object)displayEditor), (int)3) == 2) {
                    return null;
                }
                newDisplayName = displayEditor.saveValue().toString().trim();
            }
            HostDisplayNameArtifact displayNameArtifact = new HostDisplayNameArtifact(this.getOwner(), navObj, oldNavDisplayName, newDisplayName);
            displayNameArtifact.redo();
            return displayNameArtifact;
        }

        private String getDisplayNameFormat(BObject navObj) {
            String navDisplayName = ((BHost)navObj).getNavDisplayFormat();
            if (navDisplayName == null || navDisplayName.equals("")) {
                navDisplayName = "%getDefaultNavDisplayName%";
            }
            return navDisplayName;
        }
    }
}

