/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.nav;

import com.tridium.sys.transfer.FileToFile;
import com.tridium.ui.BOptionDialog;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.util.BFileSearch;
import java.security.AccessController;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.BIScopedFileSpace;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.commands.CopyCommand;
import javax.baja.ui.commands.CutCommand;
import javax.baja.ui.commands.DeleteCommand;
import javax.baja.ui.commands.DuplicateCommand;
import javax.baja.ui.commands.PasteCommand;
import javax.baja.ui.commands.RenameCommand;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.commands.FileRenameCommand;
import javax.baja.workbench.nav.menu.BNavMenuAgent;
import javax.baja.workbench.nav.menu.NavMenuUtil;

public class BFileMenuAgent
extends BNavMenuAgent {
    public static final BFileMenuAgent INSTANCE = new BFileMenuAgent();
    public static final Type TYPE = Sys.loadType(BFileMenuAgent.class);
    static final int READONLY = 1;
    static final int ROOT = 2;
    public static boolean disable = AccessController.doPrivileged(() -> System.getProperty("workbench.disableIfNoPermission", "true")).equals("true");

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected BMenu doMakeMenu(BWidget owner, BObject target, Context cx) {
        BMenu newMenu;
        BIFile file;
        if (target instanceof BIScopedFileSpace) {
            BIScopedFileSpace fs = (BIScopedFileSpace)target;
            OrdQuery[] queries = fs.getOrdInSession().parse();
            OrdQuery query = queries[queries.length - 1];
            FilePath path = new FilePath(query.getScheme(), query.getBody());
            file = ((BFileSpace)target).resolveFile(path);
        } else {
            file = target instanceof BFileSpace ? ((BFileSpace)target).resolveFile(new FilePath("^")) : (BIFile)target;
        }
        BMenu menu = new BMenu();
        BMenu views = NavMenuUtil.makeViewsMenu(owner, (BObject)file);
        menu.add("views", (BValue)new BSubMenuItem((BIMenu)views));
        if (!(!file.isDirectory() || file.isReadonly() && disable || (newMenu = BFileMenuAgent.makeNewMenu(owner, (BDirectory)file)) == null)) {
            menu.add(null, (BValue)new BSubMenuItem((BIMenu)newMenu));
        }
        menu.add(null, (BValue)new BSeparator());
        BFileMenuAgent.addEditCommands(menu, owner, file);
        if (file.isDirectory() && file.getStore() instanceof BLocalFileStore) {
            menu.add(null, (BValue)new BSeparator());
            menu.add(null, (Command)new FindFilesCommand(owner, file));
        }
        return menu;
    }

    public static void addEditCommands(BMenu menu, BWidget owner, BIFile file) {
        String name;
        FilePath path = file.getFilePath();
        int mask = 0;
        if (file.isReadonly()) {
            mask |= 1;
        }
        if (path.depth() == 0) {
            mask |= 2;
        }
        if (path.depth() == 1 && (name = path.nameAt(0)).length() == 2 && name.charAt(1) == ':') {
            mask |= 2;
        }
        if (owner instanceof BTransferWidget) {
            BTransferWidget transfer = (BTransferWidget)owner;
            BFileMenuAgent.addCut(menu, transfer, file, mask);
            BFileMenuAgent.addCopy(menu, transfer, file, mask);
            BFileMenuAgent.addPaste(menu, transfer, file, mask);
            BFileMenuAgent.addDuplicate(menu, transfer, file, mask);
            BFileMenuAgent.addDelete(menu, transfer, file, mask);
        }
        BFileMenuAgent.addRename(menu, owner, file, mask);
    }

    public static void addCut(BMenu menu, BTransferWidget owner, BIFile file, int mask) {
        CutCommand cmd = new CutCommand(owner);
        if ((BFileMenuAgent.isReadonlyOrRoot(mask) || !owner.isCutEnabled()) && disable) {
            cmd.setEnabled(false);
        }
        menu.add("cut", (Command)cmd);
    }

    public static void addCopy(BMenu menu, BTransferWidget owner, BIFile file, int mask) {
        CopyCommand cmd = new CopyCommand(owner);
        if (!owner.isCopyEnabled() && disable) {
            cmd.setEnabled(false);
        }
        menu.add("copy", (Command)cmd);
    }

    public static void addPaste(BMenu menu, BTransferWidget owner, BIFile file, int mask) {
        PasteCommand cmd = new PasteCommand(owner);
        if ((BFileMenuAgent.isReadonly(mask) || !owner.isPasteEnabled()) && disable) {
            cmd.setEnabled(false);
        }
        menu.add("paste", (Command)cmd);
    }

    public static void addDuplicate(BMenu menu, BTransferWidget owner, BIFile file, int mask) {
        DuplicateCommand cmd = new DuplicateCommand(owner);
        if ((BFileMenuAgent.isReadonlyOrRoot(mask) || !owner.isDuplicateEnabled()) && disable) {
            cmd.setEnabled(false);
        }
        menu.add("duplicate", (Command)cmd);
    }

    public static void addDelete(BMenu menu, BTransferWidget owner, BIFile file, int mask) {
        DeleteCommand cmd = new DeleteCommand(owner);
        if ((BFileMenuAgent.isReadonlyOrRoot(mask) || !owner.isDeleteEnabled()) && disable) {
            cmd.setEnabled(false);
        }
        menu.add("delete", (Command)cmd);
    }

    public static void addRename(BMenu menu, BWidget owner, BIFile file, int mask) {
        Object cmd = owner instanceof BTransferWidget ? new RenameCommand((BTransferWidget)owner) : new FileRenameCommand(owner, file);
        if (BFileMenuAgent.isReadonlyOrRoot(mask) && disable) {
            cmd.setEnabled(false);
        }
        menu.add("rename", (Command)cmd);
    }

    public static BMenu makeNewMenu(BWidget owner, BDirectory dir) {
        try {
            BMenu menu = new BMenu(UiLexicon.bajaui().getText("menu.new.label"));
            menu.add("xdir", (Command)new NewDirCommand(owner, dir));
            BDirectory newFileDir = (BDirectory)BOrd.make((String)"file:!defaults/workbench/newfiles").get();
            BIFile[] list = newFileDir.listFiles();
            for (int i = 0; list != null && i < list.length; ++i) {
                if (i == 0) {
                    menu.add(null, (BValue)new BSeparator());
                }
                menu.add("x" + i, (Command)new NewFileCommand(owner, dir, list[i]));
            }
            return menu;
        }
        catch (Exception e) {
            System.out.println("WARNING:  Cannot make new menu: " + e);
            return null;
        }
    }

    public static String promptName(BWidget owner, String label, BDirectory dir, String suggestedName) {
        String name = FileToFile.getUniqueFilename((BDirectory)dir, (String)suggestedName);
        while ((name = BOptionDialog.promptFileName((BWidget)owner, (String)label, (String)name)) != null) {
            if (FileToFile.isUniqueFilename((BDirectory)dir, (String)name)) {
                return name;
            }
            BDialog.error((BWidget)owner, (Object)UiLexicon.bajaui().getText("newFile.duplicateName", new Object[]{name}));
        }
        return null;
    }

    static boolean isReadonly(int mask) {
        return (mask & 1) != 0;
    }

    static boolean isRoot(int mask) {
        return (mask & 2) != 0;
    }

    static boolean isReadonlyOrRoot(int mask) {
        return BFileMenuAgent.isReadonly(mask) || BFileMenuAgent.isRoot(mask);
    }

    public static class FindFilesCommand
    extends Command {
        BIFile dir;

        public FindFilesCommand(BWidget owner, BIFile dir) {
            super(owner, UiLexicon.bajaui().module, "commands.findFiles");
            this.dir = dir;
        }

        public CommandArtifact doInvoke() throws Exception {
            BWidgetShell shell = this.getOwner().getShell();
            if (shell instanceof BNiagaraWbShell) {
                BFileSearch.findFiles((BNiagaraWbShell)shell, this.dir.getFilePath().toString());
            }
            return null;
        }
    }

    public static class NewFileCommand
    extends Command {
        BDirectory target;
        BIFile source;

        public NewFileCommand(BWidget owner, BDirectory target, BIFile source) {
            super(owner, source.getFileName());
            this.target = target;
            this.source = source;
            this.icon = BImage.make((BIcon)source.getNavIcon());
        }

        public CommandArtifact doInvoke() throws Exception {
            String label = UiLexicon.bajaui().getText("newFile.prompt");
            String name = BFileMenuAgent.promptName(this.getOwner(), label, this.target, this.source.getFileName());
            if (name == null) {
                return null;
            }
            FilePath.verifyValidName((String)name);
            BIFile newFile = this.target.getFileSpace().makeFile(this.target.getFilePath().merge(name));
            BajaFileUtil.pipe((BIFile)this.source, (BIFile)newFile);
            return null;
        }
    }

    public static class NewDirCommand
    extends Command {
        BDirectory target;

        public NewDirCommand(BWidget owner, BDirectory target) {
            super(owner, UiLexicon.bajaui().module, "commands.newDir");
            this.target = target;
        }

        public CommandArtifact doInvoke() throws Exception {
            String label = UiLexicon.bajaui().getText("newDir.prompt");
            String name = BFileMenuAgent.promptName(this.getOwner(), label, this.target, "Folder");
            if (name == null) {
                return null;
            }
            FilePath.verifyValidName((String)name);
            this.target.getFileSpace().makeDir(this.target.getFilePath().merge(name));
            return null;
        }
    }
}

