/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.nav;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.workbench.nav.BFileMenuAgent;
import javax.baja.file.BIFile;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.nav.menu.BNavMenuAgent;
import javax.baja.workbench.nav.menu.NavMenuUtil;

public class BBogFileMenuAgent
extends BNavMenuAgent {
    public static final BBogFileMenuAgent INSTANCE = new BBogFileMenuAgent();
    public static final Type TYPE = Sys.loadType(BBogFileMenuAgent.class);
    public static final BModule module = TYPE.getModule();
    public static final UiLexicon lex = UiLexicon.makeUiLexicon((BModule)module);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected BMenu doMakeMenu(BWidget owner, BObject target, Context cx) {
        BBogFile bogFile = (BBogFile)target;
        BMenu menu = new BMenu();
        BMenu fileViews = NavMenuUtil.makeViewsMenu(owner, target, bogFile.getAbsoluteOrd());
        menu.add("fileViews", (BValue)new BSubMenuItem((BIMenu)fileViews));
        menu.add(null, (BValue)new BSeparator());
        menu.add("save", (Command)new Save(owner, bogFile));
        menu.add("close", (Command)new Close(owner, bogFile));
        menu.add(null, (BValue)new BSeparator());
        BFileMenuAgent.addEditCommands(menu, owner, (BIFile)bogFile);
        return menu;
    }

    public static class Close
    extends Command {
        BBogFile bogFile;

        public Close(BWidget owner, BBogFile bogFile) {
            super(owner, module, "bogFile.close");
            this.bogFile = bogFile;
            this.setEnabled(bogFile.isOpen());
        }

        public CommandArtifact doInvoke() throws Exception {
            if (this.bogFile.isModified()) {
                String msg = lex.getText("bogFile.confirmClose", new Object[]{this.bogFile.getFileName()});
                int buttons = 14;
                int result = BDialog.confirm((BWidget)this.getOwner(), null, (Object)msg, (int)buttons);
                if (result == 2) {
                    return null;
                }
                if (result == 4) {
                    this.bogFile.save();
                }
            }
            this.bogFile.close();
            return null;
        }
    }

    public static class Save
    extends Command {
        BBogFile bogFile;

        public Save(BWidget owner, BBogFile bogFile) {
            super(owner, module, "bogFile.save");
            this.bogFile = bogFile;
            this.setEnabled(bogFile.isModified());
        }

        public CommandArtifact doInvoke() throws Exception {
            this.bogFile.save();
            this.getShell().repaint();
            return null;
        }
    }
}

