/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.kiosk;

import com.tridium.fox.sys.BFoxService;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.sys.Nre;
import com.tridium.ui.NullUiEnv;
import com.tridium.ui.UiEnv;
import com.tridium.workbench.kiosk.BKioskProfileConfig;
import com.tridium.workbench.shell.BGeneralOptions;
import com.tridium.workbench.shell.BNiagaraWbFrame;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BWbApplication;
import com.tridium.workbench.shell.WbMain;
import java.security.AccessController;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.naming.BHost;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordCache;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.kiosk.BKioskSplash;

public class BKioskService
extends BAbstractService
implements BWbApplication.LogoffListener,
BIRestrictedComponent {
    public static final Property splash = BKioskService.newProperty((int)0, (BValue)BTypeSpec.make((String)"workbench", (String)"DefaultKioskSplash"), (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"workbench:KioskSplash")));
    public static final Property splashImage = BKioskService.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"file:ImageFile")));
    public static final Property splashFill = BKioskService.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Property autoLoginUsername = BKioskService.newProperty((int)0, (String)"", null);
    public static final Property autoLoginPassword = BKioskService.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    public static final Property autoLogoffEnabled = BKioskService.newProperty((int)0, (boolean)true, null);
    public static final Property autoLogoffPeriod = BKioskService.newProperty((int)0, (BValue)BRelTime.make((long)900000L), null);
    public static final Type TYPE = Sys.loadType(BKioskService.class);
    private static final BIcon icon = BIcon.std((String)"workbench.png");

    public BTypeSpec getSplash() {
        return (BTypeSpec)this.get(splash);
    }

    public void setSplash(BTypeSpec v) {
        this.set(splash, (BValue)v, null);
    }

    public BOrd getSplashImage() {
        return (BOrd)this.get(splashImage);
    }

    public void setSplashImage(BOrd v) {
        this.set(splashImage, (BValue)v, null);
    }

    public BBrush getSplashFill() {
        return (BBrush)this.get(splashFill);
    }

    public void setSplashFill(BBrush v) {
        this.set(splashFill, (BValue)v, null);
    }

    public String getAutoLoginUsername() {
        return this.getString(autoLoginUsername);
    }

    public void setAutoLoginUsername(String v) {
        this.setString(autoLoginUsername, v, null);
    }

    public BPassword getAutoLoginPassword() {
        return (BPassword)this.get(autoLoginPassword);
    }

    public void setAutoLoginPassword(BPassword v) {
        this.set(autoLoginPassword, (BValue)v, null);
    }

    public boolean getAutoLogoffEnabled() {
        return this.getBoolean(autoLogoffEnabled);
    }

    public void setAutoLogoffEnabled(boolean v) {
        this.setBoolean(autoLogoffEnabled, v, null);
    }

    public BRelTime getAutoLogoffPeriod() {
        return (BRelTime)this.get(autoLogoffPeriod);
    }

    public void setAutoLogoffPeriod(BRelTime v) {
        this.set(autoLogoffPeriod, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        if (!this.getComponentSpace().isProxyComponentSpace()) {
            this.getComponentSpace().enableMixIn(BKioskProfileConfig.TYPE);
        }
    }

    public void serviceStopped() throws Exception {
        super.serviceStopped();
        if (!this.getComponentSpace().isProxyComponentSpace()) {
            this.getComponentSpace().disableMixIn(BKioskProfileConfig.TYPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stationStarted() throws Exception {
        try {
            super.stationStarted();
            if (!this.isOperational()) {
                return;
            }
            if (UiEnv.get() instanceof NullUiEnv) {
                this.configFatal(Lexicon.make((BModule)TYPE.getModule(), (String)Sys.getLanguage()).getText("kioskInvalidUI"));
                return;
            }
            Object object = UiEnv.appLock;
            synchronized (object) {
                if (UiEnv.app == null) {
                    UiEnv.app = new BWbApplication();
                    UiEnv.app.start();
                }
            }
            WbMain.doCheckLicense();
            WbMain.boot();
            new Thread(){

                @Override
                public void run() {
                    BFoxService.waitUntilPortOpen((long)10000L);
                    if (BKioskService.this.autoLogin()) {
                        return;
                    }
                    BKioskService.this.openSplash();
                }
            }.start();
        }
        catch (Throwable e) {
            this.configFatal(e.toString());
        }
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentForRestrictedComponent((BComponent)parent, (BIRestrictedComponent)this);
    }

    void openSplash() {
        BKioskSplash splash = (BKioskSplash)this.getSplash().getResolvedType().getInstance();
        UiEnv.get().setKiosk((BWidgetShell)splash);
        splash.open();
        splash.relayout();
    }

    boolean autoLogin() {
        try {
            BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
            BUser user = userService.getUser(this.getAutoLoginUsername());
            if (user == null) {
                return false;
            }
            BGeneralOptions.make().setAutoLogoffEnabled(false);
            BNiagaraWbShell shell = this.doLogin(user, BPassword.make((String)AccessController.doPrivileged(() -> ((BPassword)this.getAutoLoginPassword()).getValue())));
            shell.commands.logoff.setEnabled(false);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean login(String username, String password) throws Exception {
        BUser user = null;
        try {
            BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
            user = (BUser)userService.get(username);
            if (user == null) {
                return false;
            }
            if (!userService.canLogin(user)) {
                return false;
            }
            if (!((BPasswordCache)user.getAuthenticator()).validate(password)) {
                return false;
            }
        }
        catch (AuthenticationException e) {
            return false;
        }
        BGeneralOptions gopt = BGeneralOptions.make();
        gopt.setAutoLogoffEnabled(this.getAutoLogoffEnabled());
        gopt.setAutoLogoffPeriod(this.getAutoLogoffPeriod());
        this.doLogin(user, BPassword.make((String)password));
        return true;
    }

    BNiagaraWbShell doLogin(BUser user, BPassword password) throws Exception {
        String lang = user.getLanguage();
        if (lang.length() > 0) {
            Nre.setDefaultLocale((String)lang);
        }
        BUsernameAndPassword credentials = new BUsernameAndPassword(user.getUsername(), password);
        BFoxService foxService = (BFoxService)Sys.getService((Type)BFoxService.TYPE);
        boolean useFoxs = false;
        int port = -1;
        if (foxService.getFoxEnabled()) {
            port = foxService.getFoxPort().getBindingPort();
        }
        if (foxService.getFoxsEnabled()) {
            port = foxService.getFoxsPort().getBindingPort();
            useFoxs = true;
        }
        if (port == -1) {
            throw new BajaException("Fox not enabled.");
        }
        BFoxSession session = BFoxSession.make((BHost)BLocalHost.INSTANCE, (int)port, (boolean)useFoxs);
        session.disconnect();
        session.setCredentials((BICredentials)credentials);
        session = BFoxSession.connect((BFoxSession)session);
        BKioskProfileConfig profileConfig = BKioskProfileConfig.get(user);
        Type profileType = profileConfig.getTypeSpec().getResolvedType();
        WbMain.kioskCredentials = credentials;
        BWbApplication.logOffListener = this;
        BOrd home = BOrd.make((BOrd)session.getNavOrd(), (BOrd)user.getHomePage());
        BNiagaraWbFrame shell = WbMain.openFrame(null, home, profileType);
        return shell;
    }

    @Override
    public void logoff() {
        WbMain.kioskCredentials = null;
        BWbApplication.logOffListener = null;
        this.openSplash();
        BWbApplication app = (BWbApplication)BWidget.getApplication();
        BWidgetShell[] shells = app.getShells();
        for (int i = 0; i < shells.length; ++i) {
            BWidgetShell shell = shells[i];
            if (!(shell instanceof BNiagaraWbFrame)) continue;
            ((BNiagaraWbFrame)shell).close();
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

