/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.crypto.core.cert.SigningUtil;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecurityInitializer;
import java.security.AccessController;
import java.security.KeyStore;
import java.util.Enumeration;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public class BWbCertificateAliasFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BWbCertificateAliasFE.class);
    private BTextDropDown field = new BTextDropDown();

    @Override
    public Type getType() {
        return TYPE;
    }

    public BWbCertificateAliasFE() {
        this.setContent((BWidget)this.field);
        this.linkTo("lk0", (BComponent)this.field, (Slot)BTextDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.field, (Slot)BTextDropDown.actionPerformed, (Slot)actionPerformed);
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        this.field.getEditor().setEditable(!readonly);
        this.field.setDropDownEnabled(!readonly);
    }

    @Override
    protected void doLoadValue(BObject v, Context cx) {
        BString alias = (BString)v;
        this.field.setText(alias.getString());
        this.field.getList().removeAllItems();
        try {
            CoreCryptoManager ccm = AccessController.doPrivileged(() -> {
                try {
                    return CoreCryptoManager.get((ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider());
                }
                catch (Exception e) {
                    return null;
                }
            });
            KeyStore keyStore = ccm.getKeyStore().getKeyStore();
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String s = aliases.nextElement();
                if (!SigningUtil.isValidSigningCert((String)s, (KeyStore)keyStore)) continue;
                this.field.getList().addItem((Object)s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected BObject doSaveValue(BObject v, Context cx) {
        return BString.make((String)this.field.getText());
    }
}

