/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.workbench.util.WbUtil;
import javax.baja.gx.BImage;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.user.BUser;
import javax.baja.user.BUserPrototypes;
import javax.baja.user.BUserService;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BUserPrototypeFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BUserPrototypeFE.class);
    BTextDropDown field = new BTextDropDown("", 20, true);

    public BUserPrototypeFE() {
        this.setContent((BWidget)this.field);
        this.linkTo("la", (BComponent)this.field, (Slot)BTextDropDown.valueModified, (Slot)setModified);
        this.linkTo("lb", (BComponent)this.field, (Slot)BTextDropDown.actionPerformed, (Slot)actionPerformed);
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        this.field.getEditor().setEditable(!readonly);
        this.field.setDropDownEnabled(!readonly);
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) {
        this.build(value.toString());
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) {
        return BString.make((String)this.field.getText().trim());
    }

    private void build(String value) {
        this.field.setText(value);
        this.field.getList().removeAllItems();
        try {
            BComponent[] protos = this.loadPrototypes();
            this.field.getList().addItem((Object)new Item());
            for (int i = 0; i < protos.length; ++i) {
                this.field.getList().addItem((Object)new Item(protos[i]));
                if (!protos[i].getName().equals(value)) continue;
                this.field.getList().setSelectedIndex(i);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private BComponent[] loadPrototypes() throws Exception {
        BUserService service = (BUserService)WbUtil.findService(this, BUserService.TYPE);
        if (service == null) {
            return new BUser[0];
        }
        BUserPrototypes prototypes = service.getUserPrototypes();
        prototypes.lease();
        return prototypes.getPrototypes();
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static class Item {
        String name;
        BImage icon;

        Item() {
            this.name = "";
            this.icon = BImage.NULL;
        }

        Item(BComponent prototype) {
            this.name = prototype.getName();
            this.icon = BImage.make((BIcon)prototype.getIcon());
        }

        public String toString() {
            return this.name;
        }
    }
}

