/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Id;
import javax.baja.tag.RelationInfo;
import javax.baja.tag.TagDictionary;
import javax.baja.tag.TagDictionaryService;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.list.BList;
import javax.baja.ui.options.BMruButton;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.BTypeSpec;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BRelationIdFE
extends BWbFieldEditor {
    public static final Action dctnryChanged = BRelationIdFE.newAction((int)0, null);
    public static final Action nameChanged = BRelationIdFE.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BRelationIdFE.class);
    private BString curRelationId;
    private BWbShell wbShell;
    private TagDictionaryService service;
    private BListDropDown dctnrybox = new BListDropDown();
    private BListDropDown namebox = new BListDropDown();
    private BMruButton history;
    private boolean autoSaveHistory = true;
    private BGridPane pane;

    public void dctnryChanged() {
        this.invoke(dctnryChanged, null, null);
    }

    public void nameChanged() {
        this.invoke(nameChanged, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BRelationIdFE() {
        this.linkTo("lk3", (BComponent)this.dctnrybox, (Slot)BListDropDown.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk4", (BComponent)this.dctnrybox, (Slot)BListDropDown.valueModified, (Slot)dctnryChanged);
        this.linkTo("lk5", (BComponent)this.dctnrybox, (Slot)BListDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk6", (BComponent)this.namebox, (Slot)BListDropDown.valueModified, (Slot)nameChanged);
        this.linkTo("lk7", (BComponent)this.namebox, (Slot)BListDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk8", (BComponent)this.namebox, (Slot)BListDropDown.actionPerformed, (Slot)actionPerformed);
        this.history = new BMruButton("relIdFE", (IFilter)new MruFilter());
        this.history.setMruController((BMruButton.MruController)new MruController());
        this.history.setButtonStyle(BButtonStyle.toolBar);
    }

    public void started() {
        this.wbShell = this.getWbShell();
        BObject val = this.getCurrentValue();
        if (val != null) {
            this.lockModifiedState();
            this.doLoadValue(val, this.getCurrentContext());
            this.unlockModifiedState();
        }
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        this.dctnrybox.setDropDownEnabled(!readonly);
        this.namebox.setDropDownEnabled(!readonly);
        this.history.setEnabled(!readonly);
    }

    @Override
    public void computePreferredSize() {
        super.computePreferredSize();
        BListDropDown fe = new BListDropDown();
        fe.computePreferredSize();
        this.setPreferredSize(this.getPreferredWidth(), fe.getPreferredHeight());
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) {
        if (this.wbShell == null) {
            return;
        }
        BString curRelationId = (BString)value;
        this.loadDictionaryList(this.dctnrybox);
        if (this.pane != null) {
            this.pane.remove("dctnrybox");
            this.pane.remove("namebox");
            this.pane.remove("history");
        }
        this.initToCurrentSelection(curRelationId.getString());
        if (this.dctnrybox.getList().getSelectedIndex() == -1) {
            this.dctnrybox.getList().setSelectedIndex(0);
        }
        if (this.namebox.getList().getSelectedIndex() == -1 && this.dctnrybox.getSelectedItem() != null) {
            this.loadRelationsList((TagDictionary)this.dctnrybox.getSelectedItem(), this.namebox);
            this.namebox.getList().setSelectedIndex(0);
        }
        this.initToCurrentSelection(curRelationId.getString());
        this.pane = new BGridPane(3);
        this.pane.setHalign(BHalign.left);
        this.pane.add("dctnrybox", (BValue)this.dctnrybox);
        this.pane.add("namebox", (BValue)this.namebox);
        this.pane.add("history", (BValue)this.history);
        this.setContent((BWidget)this.pane);
        this.repaint();
    }

    private void initToCurrentSelection(String qname) {
        Id id = null;
        try {
            id = Id.newId((String)qname);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (id != null) {
            String dName = id.getDictionary();
            String name = id.getName();
            this.getTagDictionaryService();
            Optional optional = this.service.getTagDictionary(dName);
            if (optional.isPresent()) {
                this.dctnrybox.getList().setSelectedItem(optional.get());
            } else {
                this.dctnrybox.getList().setSelectedIndex(0);
            }
            this.namebox.getList().setSelectedItem((Object)id);
        }
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        String qname = ((Id)this.namebox.getSelectedItem()).getQName();
        if (qname == null) {
            return BString.DEFAULT;
        }
        BString rtnStr = BString.make((String)qname);
        if (this.autoSaveHistory) {
            this.saveHistory(rtnStr);
        }
        return rtnStr;
    }

    public void saveHistory() {
        this.saveHistory((BString)this.getCurrentValue());
    }

    private void saveHistory(BString qname) {
        try {
            this.history.getMruOptions().save(qname.encodeToString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setAutoSaveHistory(boolean b) {
        this.autoSaveHistory = b;
    }

    public boolean getAutoSaveHistory() {
        return this.autoSaveHistory;
    }

    public void doDctnryChanged() {
        TagDictionary dictionary = (TagDictionary)this.dctnrybox.getSelectedItem();
        this.loadRelationsList(dictionary, this.namebox);
    }

    public void doNameChanged() {
        System.out.println("relationId.name changed: " + ((Id)this.namebox.getSelectedItem()).getQName());
    }

    protected void loadDictionaryList(BListDropDown listBox) {
        if (this.service == null) {
            this.service = this.getTagDictionaryService();
        }
        Collection tagDictionaries = this.service.getTagDictionaries();
        BList list = listBox.getList();
        list.removeAllItems();
        for (TagDictionary dictionary : tagDictionaries) {
            if (!dictionary.getRelations().hasNext()) continue;
            list.addItem((Object)dictionary);
        }
    }

    protected void loadRelationsList(TagDictionary dictionary, BListDropDown listBox) {
        Iterator relations = dictionary.getRelations();
        BList list = listBox.getList();
        list.removeAllItems();
        while (relations.hasNext()) {
            list.addItem((Object)((RelationInfo)relations.next()).getRelationId());
        }
    }

    public TagDictionaryService getTagDictionaryService() {
        if (this.service != null) {
            return this.service;
        }
        try {
            OrdTarget activeOrdTarget = this.wbShell.getActiveOrdTarget();
            BComponent baseComp = activeOrdTarget.getComponent();
            this.service = baseComp.getTagDictionaryService();
            ((BComponent)this.service).lease(Integer.MAX_VALUE);
            return this.service;
        }
        catch (UnresolvedException ex) {
            return null;
        }
    }

    class MruFilter
    implements IFilter {
        MruFilter() {
        }

        public boolean accept(Object obj) {
            return obj instanceof RelationInfo;
        }
    }

    class MruController
    extends BMruButton.MruController {
        MruController() {
        }

        public void select(String value) {
            try {
                BRelationIdFE.this.loadValue((BObject)BTypeSpec.make((String)value), BRelationIdFE.this.getCurrentContext());
                BRelationIdFE.this.setModified();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

